/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcpchannel.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.tcpchannel.internal.ChannelSelector;
import com.ibm.ws.tcpchannel.internal.NioSocketIOChannel;
import com.ibm.ws.tcpchannel.internal.TCPBaseRequestContext;
import com.ibm.ws.tcpchannel.internal.TCPFactoryConfiguration;
import com.ibm.ws.tcpchannel.internal.TCPReadRequestContextImpl;
import com.ibm.ws.tcpchannel.internal.TCPWriteRequestContextImpl;
import com.ibm.ws.tcpchannel.internal.WorkQueueManager;
import com.ibm.wsspi.channelfw.VirtualConnection;
import java.io.IOException;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;

public class SocketRWChannelSelector
extends ChannelSelector
implements Runnable {
    private static final TraceComponent tc = Tr.register(SocketRWChannelSelector.class, (String)"TCPChannel", (String)"com.ibm.ws.tcpchannel.internal.resources.TCPChannelMessages");
    private WorkQueueManager wqm = null;
    private int countIndex = -1;
    private final int channelType;
    private final int wakeupOption;
    private boolean wakeupNeeded = false;

    protected SocketRWChannelSelector(int _wakeupOption, WorkQueueManager _wqm, int _index, int _channelType, boolean _checkCancel) throws IOException {
        super(_checkCancel);
        this.wqm = _wqm;
        this.countIndex = _index;
        this.channelType = _channelType;
        this.wakeupOption = _wakeupOption;
        boolean bl = this.wakeupNeeded = _wakeupOption == 1;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Created RW selector: " + this), (Object[])new Object[0]);
        }
    }

    protected SocketRWChannelSelector(int _wakeupOption, WorkQueueManager _wqm, int _index, int _channelType, boolean _checkCancel, boolean _startImmediately) throws IOException {
        super(_checkCancel, _startImmediately);
        this.wqm = _wqm;
        this.countIndex = _index;
        this.channelType = _channelType;
        this.wakeupOption = _wakeupOption;
        boolean bl = this.wakeupNeeded = _wakeupOption == 1;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Created RW selector: " + this), (Object[])new Object[0]);
        }
    }

    @Override
    protected void addWork(Object toAdd) {
        this.addToWorkQueue(toAdd);
        if ((this.wakeupNeeded || this.wakeupOption == 3 && !((TCPBaseRequestContext)toAdd).isForceQueue()) && !this.wakeupPending) {
            this.wakeupPending = true;
            this.wakeup();
        }
    }

    @Override
    protected boolean performRequest() {
        VirtualConnection vci = null;
        boolean completeOperation = true;
        TCPBaseRequestContext req = null;
        SelectionKey selectedKey = null;
        Set<SelectionKey> keySet = this.selector.selectedKeys();
        Iterator<SelectionKey> selectedIterator = keySet.iterator();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("performRequest - processing " + keySet.size() + " items"), (Object[])new Object[0]);
        }
        while (selectedIterator.hasNext()) {
            selectedKey = selectedIterator.next();
            selectedIterator.remove();
            req = (TCPBaseRequestContext)selectedKey.attachment();
            vci = req.getTCPConnLink().getVirtualConnection();
            completeOperation = true;
            if (vci == null) {
                completeOperation = false;
            } else if (vci.isInputStateTrackingOperational() && !req.blockedThread) {
                completeOperation = false;
                if (req.isRequestTypeRead()) {
                    if (vci.requestPermissionToFinishRead()) {
                        completeOperation = true;
                    }
                } else if (vci.requestPermissionToFinishWrite()) {
                    completeOperation = true;
                }
            }
            if (completeOperation) {
                if (!this.wqm.dispatch(req, null)) continue;
                try {
                    selectedKey.interestOps(0);
                }
                catch (CancelledKeyException cancelledKeyException) {}
                continue;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((Object)this, (TraceComponent)tc, (String)("IO cancelled on closed key " + selectedKey), (Object[])new Object[0]);
            }
            try {
                selectedKey.interestOps(0);
            }
            catch (CancelledKeyException cancelledKeyException) {}
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void updateSelector() {
        boolean bTrace = TraceComponent.isAnyTracingEnabled();
        VirtualConnection vci = null;
        NioSocketIOChannel ioSocket = null;
        TCPBaseRequestContext work = null;
        Queue<Object> queue = this.getWorkQueue();
        if (bTrace && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("updateSelector - processing " + queue.size() + " items"), (Object[])new Object[0]);
        }
        while (!queue.isEmpty()) {
            block38: {
                Object object;
                work = (TCPBaseRequestContext)queue.remove();
                ioSocket = (NioSocketIOChannel)work.getTCPConnLink().getSocketIOChannel();
                vci = work.getTCPConnLink().getVirtualConnection();
                if (vci == null) {
                    if (!bTrace || !tc.isEventEnabled()) continue;
                    SocketChannel channel = ioSocket != null ? ioSocket.getChannel() : null;
                    Tr.event((Object)this, (TraceComponent)tc, (String)("Ignoring due to null vc on " + (channel != null ? channel.toString() : "<UNKNOWN>")), (Object[])new Object[0]);
                    continue;
                }
                int selectorOp = work.isRequestTypeRead() ? 1 : 4;
                SelectionKey key = this.getKey(ioSocket.getChannel());
                if (key != null) {
                    if (bTrace && tc.isEventEnabled()) {
                        Tr.event((Object)this, (TraceComponent)tc, (String)("changing interest ops for channel " + ioSocket.getChannel() + " to " + selectorOp + " for key " + key), (Object[])new Object[0]);
                    }
                    if (vci.isInputStateTrackingOperational()) {
                        object = vci.getLockObject();
                        synchronized (object) {
                            key.interestOps(selectorOp);
                            if (work.isRequestTypeRead()) {
                                if (((TCPReadRequestContextImpl)work).getReadCompletedCallback() != null) {
                                    vci.setReadStatetoCloseAllowedNoSync();
                                }
                            } else if (((TCPWriteRequestContextImpl)work).getWriteCompletedCallback() != null) {
                                vci.setWriteStatetoCloseAllowedNoSync();
                            }
                            if (vci.getCloseWaiting()) {
                                vci.getLockObject().notify();
                            }
                        }
                    } else {
                        key.interestOps(selectorOp);
                    }
                } else {
                    if (work.isRequestTypeRead()) {
                        ioSocket.setChannelSelectorRead(this);
                    } else {
                        ioSocket.setChannelSelectorWrite(this);
                    }
                    try {
                        if (vci.isInputStateTrackingOperational()) {
                            object = vci.getLockObject();
                            synchronized (object) {
                                SelectionKey selKey = ioSocket.register(this.selector, selectorOp, work);
                                if (bTrace && tc.isEventEnabled()) {
                                    Tr.event((Object)this, (TraceComponent)tc, (String)("registered " + ioSocket.getChannel() + ", key is " + selKey), (Object[])new Object[0]);
                                }
                                this.updateCount();
                                if (work.isRequestTypeRead()) {
                                    if (((TCPReadRequestContextImpl)work).getReadCompletedCallback() != null) {
                                        vci.setReadStatetoCloseAllowedNoSync();
                                    }
                                } else if (((TCPWriteRequestContextImpl)work).getWriteCompletedCallback() != null) {
                                    vci.setWriteStatetoCloseAllowedNoSync();
                                }
                                if (vci.getCloseWaiting()) {
                                    vci.getLockObject().notify();
                                }
                                break block38;
                            }
                        }
                        SelectionKey selKey = ioSocket.register(this.selector, selectorOp, work);
                        if (bTrace && tc.isEventEnabled()) {
                            Tr.event((Object)this, (TraceComponent)tc, (String)("registered " + ioSocket.getChannel() + ", key is " + selKey), (Object[])new Object[0]);
                        }
                        this.updateCount();
                    }
                    catch (ClosedChannelException cce) {
                        boolean completeOperation = true;
                        if (bTrace && tc.isEventEnabled()) {
                            Tr.event((Object)this, (TraceComponent)tc, (String)("SocketChannel register for " + ioSocket + " failed, exception is: " + cce), (Object[])new Object[0]);
                        }
                        if (vci.isInputStateTrackingOperational() && !work.blockedThread) {
                            completeOperation = false;
                            if (work.isRequestTypeRead()) {
                                if (vci.requestPermissionToFinishRead()) {
                                    completeOperation = true;
                                }
                            } else if (vci.requestPermissionToFinishWrite()) {
                                completeOperation = true;
                            }
                        }
                        if (!completeOperation || this.wqm.dispatch(work, cce)) continue;
                        this.addWork(work);
                        continue;
                    }
                }
            }
            if (!work.hasTimeout() || work.getTimeoutTime() >= this.nextTimeoutTime) continue;
            this.nextTimeoutTime = work.getTimeoutTime();
        }
        if (null != work) {
            this.waitingToQuit = false;
            this.quit = false;
        }
    }

    @Override
    protected void updateCount() {
        int selectorCount = this.selector.keys().size();
        if (selectorCount > 0) {
            this.waitingToQuit = false;
        }
        this.wqm.updateCount(this.countIndex, selectorCount, this.channelType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void channelSelectorClose() {
        Object object = this.wqm.shutdownSync;
        synchronized (object) {
            try {
                this.selector.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.wqm.updateCount(this.countIndex, -1, this.channelType);
        }
    }

    @Override
    protected void checkForTimeouts() {
        boolean bTrace = TraceComponent.isAnyTracingEnabled();
        long now = this.currentTime;
        if (now < this.nextTimeoutTime) {
            if (bTrace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"checkForTimeouts bypassing timeout processing", (Object[])new Object[0]);
            }
            return;
        }
        Set<SelectionKey> selectorKeys = this.selector.keys();
        if (bTrace && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("checkForTimeouts - checking " + selectorKeys.size() + " keys for timeouts"), (Object[])new Object[0]);
        }
        if (selectorKeys.isEmpty()) {
            if (this.countIndex > 0) {
                if (this.waitingToQuit) {
                    this.quit = true;
                } else {
                    this.wqm.updateCount(this.countIndex, -2, this.channelType);
                    this.waitingToQuit = true;
                    this.nextTimeoutTime = now + TCPFactoryConfiguration.getChannelSelectorWaitToTerminate();
                }
            } else {
                this.nextTimeoutTime = now + TCPFactoryConfiguration.getChannelSelectorIdleTimeout();
            }
        } else {
            this.waitingToQuit = false;
            this.nextTimeoutTime = now + TCPFactoryConfiguration.getChannelSelectorIdleTimeout();
            for (SelectionKey key : selectorKeys) {
                try {
                    TCPBaseRequestContext req;
                    if (key.interestOps() <= 0 || !(req = (TCPBaseRequestContext)key.attachment()).hasTimeout()) continue;
                    if (req.getTimeoutTime() <= now) {
                        String ioeMessage = "Socket operation timed out before it could be completed";
                        try {
                            if (bTrace && tc.isEventEnabled()) {
                                Tr.event((Object)this, (TraceComponent)tc, (String)("Inactivity timeout on channel " + req.getTCPConnLink().getSocketIOChannel().getChannel()), (Object[])new Object[0]);
                            }
                            SocketAddress iaLocal = req.getTCPConnLink().getSocketIOChannel().getSocket().getLocalSocketAddress();
                            SocketAddress iaRemote = req.getTCPConnLink().getSocketIOChannel().getSocket().getRemoteSocketAddress();
                            ioeMessage = ioeMessage + " local=" + iaLocal + " remote=" + iaRemote;
                        }
                        catch (Exception iaLocal) {
                            // empty catch block
                        }
                        SocketTimeoutException e = new SocketTimeoutException(ioeMessage);
                        if (this.wqm.dispatch(req, e)) {
                            key.interestOps(0);
                            continue;
                        }
                        this.nextTimeoutTime = now;
                        continue;
                    }
                    if (req.getTimeoutTime() >= this.nextTimeoutTime) continue;
                    this.nextTimeoutTime = req.getTimeoutTime();
                }
                catch (CancelledKeyException cke) {}
            }
        }
    }
}

