/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.telemetry20.internal.http;

import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.container.service.app.deploy.ApplicationInfo;
import com.ibm.ws.container.service.state.ApplicationStateListener;
import com.ibm.ws.container.service.state.StateChangeException;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import io.openliberty.http.monitor.HttpStatAttributes;
import io.openliberty.http.monitor.metrics.HTTPMetricAdapter;
import io.openliberty.microprofile.telemetry.internal.interfaces.OpenTelemetryAccessor;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.metrics.DoubleHistogram;
import io.opentelemetry.context.Context;
import io.opentelemetry.semconv.ErrorAttributes;
import io.opentelemetry.semconv.HttpAttributes;
import io.opentelemetry.semconv.NetworkAttributes;
import io.opentelemetry.semconv.ServerAttributes;
import io.opentelemetry.semconv.UrlAttributes;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={HTTPMetricAdapter.class, ApplicationStateListener.class}, configurationPolicy=ConfigurationPolicy.IGNORE)
public class MPTelemetryHTTPMetricsAdapterImpl
implements HTTPMetricAdapter,
ApplicationStateListener {
    private static final TraceComponent tc = Tr.register(MPTelemetryHTTPMetricsAdapterImpl.class, (String)"TELEMETRY", null);
    private static final String INSTR_SCOPE = "io.openliberty.microprofile.telemetry20.internal.http";
    private static final String NO_APP_NAME_IDENTIFIER = "io.openliberty.microprofile.telemetry20.internal.http.no.app.name";
    private static final double NANO_CONVERSION = 1.0E-9;
    private static final Double[] BUCKET_BOUNDARIES = new Double[]{0.005, 0.01, 0.025, 0.05, 0.075, 0.1, 0.25, 0.5, 0.75, 1.0, 2.5, 5.0, 7.5, 10.0};
    private static final List<Double> BUCKET_BOUNDARIES_LIST = Arrays.asList(BUCKET_BOUNDARIES);
    private static Map<String, Map<String, Attributes>> appNameToAttributesMap = new ConcurrentHashMap<String, Map<String, Attributes>>();
    private final WeakHashMap<OpenTelemetry, DoubleHistogram> threadUnsafeHTTPHistogramMap = new WeakHashMap();
    private final ReadWriteLock httpHistogramMapLock = new ReentrantReadWriteLock();
    static final long serialVersionUID = -4161731769583851062L;

    public void updateHttpMetrics(HttpStatAttributes httpStatAttributes, Duration duration) {
        OpenTelemetry otelInstance = OpenTelemetryAccessor.getOpenTelemetryInfo().getOpenTelemetry();
        if (otelInstance == null && (otelInstance = OpenTelemetryAccessor.getOpenTelemetryInfo().getOpenTelemetry()) == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)String.format("Unable to resolve an OpenTelemetry instance for the HttpStatAttributes [%s]", httpStatAttributes.toString()), (Object[])new Object[0]);
            }
            return;
        }
        DoubleHistogram httpHistogram = this.getHTTPHistogram(otelInstance);
        Context ctx = Context.current();
        double seconds = (double)duration.toNanos() * 1.0E-9;
        String appName = this.getApplicationName();
        appName = appName == null ? NO_APP_NAME_IDENTIFIER : appName;
        String keyID = httpStatAttributes.getHttpStatID();
        Map attributesMap = appNameToAttributesMap.computeIfAbsent(appName, x -> new ConcurrentHashMap());
        Attributes attributes = attributesMap.computeIfAbsent(keyID, x -> this.retrieveAttributes(httpStatAttributes));
        httpHistogram.record(seconds, attributes, ctx);
    }

    private String getApplicationName() {
        J2EEName name;
        ComponentMetaData metaData = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
        if (metaData != null && (name = metaData.getJ2EEName()) != null) {
            return name.getApplication();
        }
        return null;
    }

    private Attributes retrieveAttributes(HttpStatAttributes httpStatAttributes) {
        String httpRoute;
        AttributesBuilder attributesBuilder = Attributes.builder();
        attributesBuilder.put(HttpAttributes.HTTP_REQUEST_METHOD, (Object)httpStatAttributes.getRequestMethod());
        attributesBuilder.put(UrlAttributes.URL_SCHEME, (Object)httpStatAttributes.getScheme());
        Integer responseStatus = httpStatAttributes.getResponseStatus();
        if (responseStatus != null) {
            attributesBuilder.put(HttpAttributes.HTTP_RESPONSE_STATUS_CODE, (Object)responseStatus);
        }
        if ((httpRoute = httpStatAttributes.getHttpRoute()) != null) {
            attributesBuilder.put(HttpAttributes.HTTP_ROUTE, (Object)httpRoute);
        }
        attributesBuilder.put(NetworkAttributes.NETWORK_PROTOCOL_VERSION, (Object)httpStatAttributes.getNetworkProtocolVersion());
        attributesBuilder.put(ServerAttributes.SERVER_ADDRESS, (Object)httpStatAttributes.getServerName());
        attributesBuilder.put(ServerAttributes.SERVER_PORT, (Object)httpStatAttributes.getServerPort());
        String errorType = httpStatAttributes.getErrorType();
        if (errorType != null) {
            attributesBuilder.put(ErrorAttributes.ERROR_TYPE, (Object)errorType);
        }
        return attributesBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DoubleHistogram getHTTPHistogram(OpenTelemetry otelInstance) {
        try {
            this.httpHistogramMapLock.readLock().lock();
            if (this.threadUnsafeHTTPHistogramMap.containsKey(otelInstance)) {
                DoubleHistogram doubleHistogram = this.threadUnsafeHTTPHistogramMap.get(otelInstance);
                return doubleHistogram;
            }
        }
        finally {
            this.httpHistogramMapLock.readLock().unlock();
        }
        try {
            this.httpHistogramMapLock.writeLock().lock();
            DoubleHistogram doubleHistogram = this.threadUnsafeHTTPHistogramMap.computeIfAbsent(otelInstance, openTelemetry -> openTelemetry.getMeterProvider().get(INSTR_SCOPE).histogramBuilder("http.server.request.duration").setUnit("s").setDescription("Duration of HTTP server requests.").setExplicitBucketBoundariesAdvice(BUCKET_BOUNDARIES_LIST).build());
            return doubleHistogram;
        }
        finally {
            this.httpHistogramMapLock.writeLock().unlock();
        }
    }

    public void applicationStarting(ApplicationInfo appInfo) throws StateChangeException {
    }

    public void applicationStarted(ApplicationInfo appInfo) throws StateChangeException {
    }

    public void applicationStopping(ApplicationInfo appInfo) {
    }

    public void applicationStopped(ApplicationInfo appInfo) {
        String appName = appInfo.getDeploymentName();
        Map<String, Attributes> map = appNameToAttributesMap.remove(appName);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)String.format("Detected that application %s has stopped. Removed a corresponding Map<String, Attributes> entry? [%b]", appName, map != null), (Object[])new Object[0]);
        }
    }
}

