/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.util.rofl;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.yoko.io.SimplyCloseable;
import org.apache.yoko.util.rofl.Rofl;

public final class RoflThreadLocal {
    private static final Logger LOGGER = Logger.getLogger(RoflThreadLocal.class.getName());
    private static final ThreadLocal<Stack> threadLocalStack = ThreadLocal.withInitial(() -> new Stack());

    private RoflThreadLocal() {
    }

    public static SimplyCloseable override() {
        Stack info = threadLocalStack.get();
        info.override = true;
        return () -> {
            info.override = false;
        };
    }

    public static SimplyCloseable push(Rofl rofl) {
        Stack info = threadLocalStack.get();
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer(String.format("ROFL thread local version pushed onto stack: %s", rofl));
        }
        info.head = new Frame(rofl, info.head);
        return RoflThreadLocal::pop;
    }

    public static Rofl get() {
        Rofl rofl;
        Stack info = threadLocalStack.get();
        boolean override = info.override;
        Rofl rofl2 = rofl = override ? null : info.head.value;
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer(String.format("ROFL thread local version retrieved: %s, override is %b", rofl, override));
        }
        return rofl;
    }

    public static Rofl pop() {
        Stack info = threadLocalStack.get();
        Rofl rofl = info.head.value;
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer(String.format("ROFL thread local version popped from stack: %s", rofl));
        }
        info.head = info.head.prev;
        return rofl;
    }

    public static void reset() {
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("ROFL thread local stack reset");
        }
        threadLocalStack.remove();
    }

    private static final class Frame {
        private static final Frame DEFAULT = new Frame();
        final Rofl value;
        final Frame prev;

        private Frame() {
            this.value = Rofl.NONE;
            this.prev = this;
        }

        Frame(Rofl value, Frame prev) {
            this.value = value;
            this.prev = prev;
        }

        static /* synthetic */ Frame access$000() {
            return DEFAULT;
        }
    }

    private static final class Stack {
        public Frame head = Frame.access$000();
        public boolean override = false;

        private Stack() {
        }
    }
}

