/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.objectManager;

import com.ibm.ws.objectManager.AbstractSingleFileObjectStore;
import com.ibm.ws.objectManager.BTree;
import com.ibm.ws.objectManager.InvalidStoreSignatureException;
import com.ibm.ws.objectManager.ManagedObject;
import com.ibm.ws.objectManager.ObjectManager;
import com.ibm.ws.objectManager.ObjectManagerByteArrayOutputStream;
import com.ibm.ws.objectManager.ObjectManagerException;
import com.ibm.ws.objectManager.ObjectManagerState;
import com.ibm.ws.objectManager.PermanentIOException;
import com.ibm.ws.objectManager.PermanentNIOException;
import com.ibm.ws.objectManager.StoreFileInUseException;
import com.ibm.ws.objectManager.TemporaryIOException;
import com.ibm.ws.objectManager.Token;
import com.ibm.ws.objectManager.UnexpectedExceptionException;
import com.ibm.ws.objectManager.utils.Trace;
import com.ibm.ws.objectManager.utils.Tracing;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.TreeSet;

public final class SingleFileObjectStore
extends AbstractSingleFileObjectStore {
    private static final Class cclass = SingleFileObjectStore.class;
    private static Trace trace = ObjectManager.traceFactory.getTrace(cclass, "ObjectManagerStore");
    private static final long serialVersionUID = 5641115480865092449L;
    private transient FileChannel storeChannel;
    private transient ByteBuffer sharedBuffer;
    private transient FileLock storeFileLock;

    public SingleFileObjectStore(String storeName, ObjectManager objectManager) throws ObjectManagerException {
        super(storeName, objectManager, 0);
        String methodName = "<init>";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "<init>", new Object[]{storeName, objectManager});
            trace.exit(this, cclass, "<init>");
        }
    }

    public SingleFileObjectStore(String storeName, ObjectManager objectManager, int storeStrategy) throws ObjectManagerException {
        super(storeName, objectManager, storeStrategy);
        String methodName = "<init>";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "<init>", new Object[]{storeName, objectManager, new Integer(storeStrategy)});
            trace.exit(this, cclass, "<init>");
        }
    }

    @Override
    public synchronized void open(ObjectManagerState objectManagerState) throws ObjectManagerException {
        String methodName = "open";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "open", objectManagerState);
        }
        super.open(objectManagerState);
        this.sharedBuffer = ByteBuffer.allocateDirect(0x100000);
        this.storeChannel = this.storeFile.getChannel();
        try {
            this.storeFileLock = this.storeChannel.tryLock();
        }
        catch (IOException exception) {
            ObjectManager.ffdc.processException(this, cclass, "<init>", exception, "1:137:1.39");
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "open", new Object[]{exception});
            }
            throw new PermanentIOException((Object)this, exception);
        }
        if (this.storeFileLock == null) {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "open", "via StoreFileInUseException, storeName=" + this.storeName + "(String)");
            }
            throw new StoreFileInUseException(this, this.storeName);
        }
        try {
            ByteBuffer storeHeader = ByteBuffer.allocate(4096);
            this.storeChannel.read(storeHeader);
            storeHeader.flip();
            int versionRead = storeHeader.getInt();
            char[] signatureRead = new char["++ObjectManager.SingleFileObjectStore++".length()];
            for (int i = 0; i < "++ObjectManager.SingleFileObjectStore++".length(); ++i) {
                signatureRead[i] = storeHeader.getChar();
            }
            if (!new String(signatureRead).equals("++ObjectManager.SingleFileObjectStore++")) {
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "open", new Object[]{signatureRead});
                }
                throw new InvalidStoreSignatureException(this, new String(signatureRead), "++ObjectManager.SingleFileObjectStore++");
            }
            long objectStoreIdentifierRead = storeHeader.getLong();
            if (Tracing.isAnyTracingEnabled() && trace.isDebugEnabled()) {
                trace.debug((Object)this, cclass, "open", new Object[]{new Integer(versionRead), new String(signatureRead), new Long(objectStoreIdentifierRead)});
            }
            if (this.objectStoreIdentifier == -1) {
                this.objectStoreIdentifier = (int)objectStoreIdentifierRead;
            }
            long directoryRootByteAddress = storeHeader.getLong();
            long directoryRootLength = storeHeader.getLong();
            int directoryMinimumNodeSize = storeHeader.getInt();
            long freeSpaceStoreAreaByteAddress = storeHeader.getLong();
            long freeSpaceStoreAreaLength = storeHeader.getLong();
            long freeSpaceCount = storeHeader.getLong();
            this.sequenceNumber = storeHeader.getLong();
            this.storeFileSizeUsed = storeHeader.getLong();
            this.minimumStoreFileSize = storeHeader.getLong();
            this.maximumStoreFileSize = storeHeader.getLong();
            this.cachedManagedObjectsSize = storeHeader.getInt();
            this.storeFileSizeAllocated = this.storeFile.length();
            if (Tracing.isAnyTracingEnabled() && trace.isDebugEnabled()) {
                trace.debug((Object)this, cclass, "open", new Object[]{new Long(directoryRootByteAddress), new Long(directoryRootLength), new Integer(directoryMinimumNodeSize), new Long(freeSpaceStoreAreaByteAddress), new Long(freeSpaceStoreAreaLength), new Long(freeSpaceCount), new Long(this.sequenceNumber), new Long(this.storeFileSizeUsed), new Long(this.minimumStoreFileSize), new Long(this.maximumStoreFileSize), new Integer(this.cachedManagedObjectsSize), new Long(this.storeFileSizeAllocated)});
            }
            if (this.storeStrategy == 0 || this.storeStrategy == 2) {
                this.cachedManagedObjects = new SoftReference[this.cachedManagedObjectsSize];
                this.directory = new Directory(directoryMinimumNodeSize, directoryRootByteAddress, directoryRootLength);
                if (freeSpaceStoreAreaByteAddress != 0L) {
                    this.freeSpaceStoreArea = this.directory.makeStoreArea(102L, freeSpaceStoreAreaByteAddress, freeSpaceStoreAreaLength);
                }
                this.readFreeSpaceMap(freeSpaceCount);
            } else if (this.storeStrategy == 1) {
                this.reservedSize = Runtime.getRuntime().totalMemory() < Integer.MAX_VALUE ? new AbstractSingleFileObjectStore.Atomic32BitLong(0L) : new AbstractSingleFileObjectStore.Atomic64BitLong(0L);
                this.clear();
            }
        }
        catch (BufferUnderflowException exception) {
            if (Tracing.isAnyTracingEnabled() && trace.isEventEnabled()) {
                trace.event(this, cclass, "open", exception);
            }
            if (objectManagerState.getObjectManagerStateState() == 2) {
                ObjectManager.ffdc.processException(this, cclass, "open", exception, "1:267:1.39");
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "open", new Object[]{"Buffer underflow:270"});
                }
                throw new PermanentNIOException((Object)this, exception);
            }
            this.minimumStoreFileSize = 0L;
            this.maximumStoreFileSize = Long.MAX_VALUE;
            this.cachedManagedObjectsSize = 10000;
            this.cachedManagedObjects = new SoftReference[this.cachedManagedObjectsSize];
            this.directory = new Directory(10, 0L, 0L);
            this.freeSpaceByAddressHead = null;
            this.freeSpaceByLength = new TreeSet(new AbstractSingleFileObjectStore.LengthComparator());
            this.freeSpaceStoreArea = null;
            this.sequenceNumber = 200L;
            this.storeFileSizeAllocated = this.storeFileSizeUsed = 8192L;
            this.writeHeader();
            this.force();
        }
        catch (IOException exception) {
            ObjectManager.ffdc.processException(this, cclass, "open", exception, "1:302:1.39");
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, cclass, "open");
            }
            throw new PermanentIOException((Object)this, exception);
        }
        this.directoryReservedSize = this.directory.spaceRequired();
        this.reservedSize = Runtime.getRuntime().totalMemory() < Integer.MAX_VALUE ? new AbstractSingleFileObjectStore.Atomic32BitLong(0L) : new AbstractSingleFileObjectStore.Atomic64BitLong(0L);
        this.addSpaceOverhead = 77;
        this.setAllocationAllowed();
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "open");
        }
    }

    private void readFreeSpaceMap(long freeSpaceCount) throws ObjectManagerException {
        String methodName = "readFreeSpaceMap";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "readFreeSpaceMap", new Object[]{new Long(freeSpaceCount)});
        }
        this.freeSpaceByAddressHead = null;
        this.freeSpaceByLength = new TreeSet(new AbstractSingleFileObjectStore.LengthComparator());
        if (this.freeSpaceStoreArea != null) {
            try {
                ByteBuffer byteBuffer = ByteBuffer.allocate((int)freeSpaceCount * 16);
                this.storeChannel.read(byteBuffer, this.freeSpaceStoreArea.byteAddress);
                byteBuffer.flip();
                AbstractSingleFileObjectStore.FreeSpace freeSpaceByAddressTail = null;
                int i = 0;
                while ((long)i < freeSpaceCount) {
                    AbstractSingleFileObjectStore.FreeSpace freeSpace = new AbstractSingleFileObjectStore.FreeSpace(byteBuffer.getLong(), byteBuffer.getLong());
                    if (freeSpaceByAddressTail != null && freeSpace.address < freeSpaceByAddressTail.address) {
                        AbstractSingleFileObjectStore.FreeSpace sortEntry = this.freeSpaceByAddressHead;
                        while (sortEntry != null) {
                            if (sortEntry.address > freeSpace.address) {
                                freeSpace.next = sortEntry;
                                freeSpace.prev = sortEntry.prev;
                                if (sortEntry.prev != null) {
                                    sortEntry.prev.next = freeSpace;
                                } else {
                                    this.freeSpaceByAddressHead = freeSpace;
                                }
                                sortEntry.prev = freeSpace;
                                break;
                            }
                            sortEntry = sortEntry.next;
                        }
                        if (sortEntry == null) {
                            RuntimeException exception = new RuntimeException();
                            ObjectManager.ffdc.processException(this, cclass, "readFreeSpaceMap", exception, "1:395:1.39");
                            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                                trace.exit(this, cclass, "readFreeSpaceMap");
                            }
                            throw new UnexpectedExceptionException((Object)this, exception);
                        }
                    } else {
                        if (freeSpaceByAddressTail == null) {
                            this.freeSpaceByAddressHead = freeSpace;
                        } else {
                            freeSpace.prev = freeSpaceByAddressTail;
                            freeSpaceByAddressTail.next = freeSpace;
                        }
                        freeSpaceByAddressTail = freeSpace;
                    }
                    this.freeSpaceByLength.add(freeSpace);
                    ++i;
                }
            }
            catch (IOException exception) {
                ObjectManager.ffdc.processException(this, cclass, "readFreeSpaceMap", exception, "1:425:1.39");
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit(this, cclass, "readFreeSpaceMap");
                }
                this.objectManagerState.requestShutdown();
                throw new PermanentIOException((Object)this, exception);
            }
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "readFreeSpaceMap");
        }
    }

    @Override
    public ManagedObject get(Token token) throws ObjectManagerException {
        String methodName = "get";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "get", new Object[]{token});
        }
        ++this.numberOfGetRequests;
        ManagedObject objectFromStore = null;
        Directory.StoreArea storeArea = (Directory.StoreArea)this.directory.getEntry(new Long(token.storedObjectIdentifier));
        if (storeArea != null) {
            if (Tracing.isAnyTracingEnabled() && trace.isDebugEnabled()) {
                trace.debug((Object)this, cclass, "get", new Object[]{storeArea});
            }
            ByteBuffer serializedBuffer = ByteBuffer.allocate((int)storeArea.length);
            this.getLock.readLock().lock();
            try {
                this.storeChannel.read(serializedBuffer, storeArea.byteAddress);
            }
            catch (IOException exception) {
                ObjectManager.ffdc.processException(this, cclass, "get", exception, "1:480:1.39");
                if (this.storeChannel.isOpen()) {
                    TemporaryIOException tioe = new TemporaryIOException((Object)this, exception);
                    if (trace.isEntryEnabled()) {
                        trace.exit((Object)this, cclass, "get", tioe);
                    }
                    throw tioe;
                }
                this.objectManagerState.requestShutdown();
                PermanentIOException pioe = new PermanentIOException((Object)this, exception);
                if (trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "get", pioe);
                }
                throw pioe;
            }
            finally {
                this.getLock.readLock().unlock();
            }
            byte[] managedObjectBytes = serializedBuffer.array();
            objectFromStore = ManagedObject.restoreFromSerializedBytes(managedObjectBytes, this.objectManagerState);
            this.cache(objectFromStore);
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "get", new Object[]{objectFromStore});
        }
        return objectFromStore;
    }

    @Override
    public synchronized void close() throws ObjectManagerException {
        String methodName = "close";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "close");
        }
        try {
            if (this.storeFileLock != null) {
                this.storeFileLock.release();
            }
            if (this.storeChannel != null) {
                this.storeChannel.close();
            }
        }
        catch (IOException exception) {
            ObjectManager.ffdc.processException(this, cclass, "close", exception, "1:570:1.39");
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "close", exception);
            }
            throw new PermanentIOException((Object)this, exception);
        }
        super.close();
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "close");
        }
    }

    @Override
    final AbstractSingleFileObjectStore.Directory makeDirectory(int minimumNodeSize, long directoryRootByteAddress, long directoryRootLength) throws ObjectManagerException {
        return new Directory(minimumNodeSize, directoryRootByteAddress, directoryRootLength);
    }

    @Override
    final void write(ManagedObject managedObject) throws ObjectManagerException {
        String methodName = "write";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "write", new Object[]{managedObject});
        }
        ObjectManagerByteArrayOutputStream byteArrayOutputStream = null;
        byte[] serializedBytes = null;
        int serializedBytesLength = 0;
        if (this.usesSerializedForm) {
            if (managedObject.state != 7) {
                byteArrayOutputStream = managedObject.freeLatestSerializedBytes();
            }
        } else if (managedObject.state == 8) {
            byteArrayOutputStream = managedObject.getSerializedBytes();
        }
        if (byteArrayOutputStream != null) {
            Directory.StoreArea existingStoreArea;
            AbstractSingleFileObjectStore.FreeSpace freeSpace;
            Directory.StoreArea storeArea;
            serializedBytes = byteArrayOutputStream.getBuffer();
            serializedBytesLength = byteArrayOutputStream.getCount();
            boolean addToDirectory = false;
            if (this.objectManagerState.getObjectManagerStateState() == 2) {
                storeArea = (Directory.StoreArea)this.directory.getEntry(new Long(managedObject.owningToken.storedObjectIdentifier));
                if (storeArea == null || storeArea.length < (long)serializedBytesLength || storeArea.length + 17L > (long)serializedBytesLength) {
                    freeSpace = this.allocateSpace(serializedBytesLength);
                    storeArea = (Directory.StoreArea)this.directory.makeStoreArea(managedObject.owningToken.storedObjectIdentifier, freeSpace.address, freeSpace.length);
                    addToDirectory = true;
                }
            } else {
                freeSpace = this.allocateSpace(serializedBytesLength);
                storeArea = (Directory.StoreArea)this.directory.makeStoreArea(managedObject.owningToken.storedObjectIdentifier, freeSpace.address, freeSpace.length);
                addToDirectory = true;
            }
            ++this.numberOfManagedObjectsWritten;
            try {
                int iLength;
                for (int iStart = 0; iStart < serializedBytesLength; iStart += iLength) {
                    this.sharedBuffer.clear();
                    iLength = Math.min(this.sharedBuffer.remaining(), serializedBytesLength - iStart);
                    this.sharedBuffer.put(serializedBytes, iStart, iLength);
                    this.sharedBuffer.flip();
                    this.writeBuffer(this.sharedBuffer, storeArea.byteAddress + (long)iStart);
                }
            }
            catch (BufferOverflowException exception) {
                ObjectManager.ffdc.processException(this, cclass, "write", exception, "1:734:1.39");
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit(this, cclass, "write");
                }
                throw new PermanentNIOException((Object)this, exception);
            }
            if (addToDirectory && (existingStoreArea = (Directory.StoreArea)this.directory.putEntry(storeArea)) != null) {
                this.newFreeSpace.add(existingStoreArea);
            }
            this.checkpointReleaseSize += byteArrayOutputStream.getReleaseSize();
            this.objectManagerState.returnByteArrayOutputStreamToPool(byteArrayOutputStream);
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "write");
        }
    }

    @Override
    final void writeFreeSpace() throws ObjectManagerException {
        String methodName = "writeFreeSpace";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "writeFreeSpace");
        }
        this.sharedBuffer.clear();
        long freeSpaceByteAddress = this.freeSpaceStoreArea.byteAddress;
        AbstractSingleFileObjectStore.FreeSpace freeSpace = this.freeSpaceByAddressHead;
        while (freeSpace != null) {
            this.sharedBuffer.putLong(freeSpace.address);
            this.sharedBuffer.putLong(freeSpace.length);
            if (this.sharedBuffer.remaining() < 16) {
                this.sharedBuffer.flip();
                int bytesWritten = this.writeBuffer(this.sharedBuffer, freeSpaceByteAddress);
                freeSpaceByteAddress += (long)bytesWritten;
                this.sharedBuffer.clear();
            }
            freeSpace = freeSpace.next;
        }
        this.sharedBuffer.flip();
        this.writeBuffer(this.sharedBuffer, freeSpaceByteAddress);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "writeFreeSpace");
        }
    }

    private int writeBuffer(ByteBuffer byteBuffer, long byteAddress) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "writeBuffer", new Object[]{new Integer(byteBuffer.hashCode()), new Long(byteAddress)});
        }
        int bytesWritten = 0;
        try {
            while (byteBuffer.hasRemaining()) {
                bytesWritten += this.storeChannel.write(byteBuffer, byteAddress + (long)bytesWritten);
            }
        }
        catch (IOException exception) {
            ObjectManager.ffdc.processException(this, cclass, "writeBuffer", exception, "1:833:1.39");
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, cclass, "writeBuffer");
            }
            this.objectManagerState.requestShutdown();
            throw new PermanentIOException((Object)this, exception);
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "writeBuffer", new Object[]{new Integer(bytesWritten)});
        }
        return bytesWritten;
    }

    @Override
    final void writeHeader() throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "writeHeader");
        }
        this.sharedBuffer.clear();
        this.sharedBuffer.putInt(1);
        for (int i = 0; i < "++ObjectManager.SingleFileObjectStore++".length(); ++i) {
            this.sharedBuffer.putChar("++ObjectManager.SingleFileObjectStore++".charAt(i));
        }
        this.sharedBuffer.putLong(this.objectStoreIdentifier);
        this.sharedBuffer.putLong(((Directory.Node)this.directory.root).byteAddress);
        this.sharedBuffer.putLong(((Directory.Node)this.directory.root).length);
        this.sharedBuffer.putInt(this.directory.getMinimumNodeSize());
        if (this.freeSpaceStoreArea == null) {
            this.sharedBuffer.putLong(0L);
            this.sharedBuffer.putLong(0L);
        } else {
            this.sharedBuffer.putLong(this.freeSpaceStoreArea.byteAddress);
            this.sharedBuffer.putLong(this.freeSpaceStoreArea.length);
        }
        this.sharedBuffer.putLong(this.freeSpaceByLength.size());
        this.sharedBuffer.putLong(this.sequenceNumber);
        this.sharedBuffer.putLong(this.storeFileSizeUsed);
        this.sharedBuffer.putLong(this.minimumStoreFileSize);
        this.sharedBuffer.putLong(this.maximumStoreFileSize);
        this.sharedBuffer.putInt(this.cachedManagedObjectsSize);
        this.sharedBuffer.flip();
        this.writeBuffer(this.sharedBuffer, 0L);
        this.sharedBuffer.flip();
        this.writeBuffer(this.sharedBuffer, 4096L);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "writeHeader");
        }
    }

    @Override
    void force() throws ObjectManagerException {
        String methodName = "force";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "force");
        }
        try {
            this.storeChannel.force(false);
        }
        catch (IOException exception) {
            ObjectManager.ffdc.processException(this, cclass, "force", exception, "1:923:1.39");
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, cclass, "force");
            }
            this.objectManagerState.requestShutdown();
            throw new PermanentIOException((Object)this, exception);
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "force");
        }
    }

    final class Directory
    extends AbstractSingleFileObjectStore.Directory {
        private final Class cclass;

        Directory(int minimumNodeSize, long directoryRootByteAddress, long directoryRootLength) throws ObjectManagerException {
            super(minimumNodeSize, directoryRootByteAddress, directoryRootLength);
            this.cclass = Directory.class;
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, this.cclass, "<init>", new Object[]{new Integer(minimumNodeSize), new Long(directoryRootByteAddress), new Long(directoryRootLength)});
            }
            if (directoryRootLength > 0L) {
                this.root = new Node(directoryRootByteAddress, directoryRootLength);
            }
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, this.cclass, "<init>");
            }
        }

        @Override
        BTree.Node makeNode(BTree.Node parent) throws ObjectManagerException {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, Directory.class, "makeNode", new Object[]{parent});
            }
            Node newNode = new Node((Node)parent);
            newNode.modified = true;
            newNode.dormantFlushCount = 2;
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, Directory.class, "makeNode", new Object[]{newNode});
            }
            return newNode;
        }

        @Override
        BTree.Entry makeEntry(Object key, Object value) throws ObjectManagerException {
            StoreArea newEntry = new StoreArea(key, value);
            return newEntry;
        }

        @Override
        AbstractSingleFileObjectStore.Directory.StoreArea makeStoreArea(long identifier, long byteAddress, long length) throws ObjectManagerException {
            return new StoreArea(identifier, byteAddress, length);
        }

        class Node
        extends AbstractSingleFileObjectStore.Directory.Node {
            private final Class cclass;

            Node(Node parent) {
                super(parent);
                this.cclass = Node.class;
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.entry((Object)this, this.cclass, "<init>", new Object[]{parent});
                }
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit(this, this.cclass, "<init>");
                }
            }

            Node(long byteAddress, long length) throws ObjectManagerException {
                super(null);
                this.cclass = Node.class;
                String methodName = "<init>";
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.entry((Object)this, this.cclass, "<init>", new Object[]{new Long(byteAddress), new Long(length)});
                }
                this.byteAddress = byteAddress;
                this.length = length;
                ++SingleFileObjectStore.this.numberOfDirectoryNodesRead;
                SingleFileObjectStore.this.getLock.readLock().lock();
                try {
                    ByteBuffer byteBuffer = ByteBuffer.allocate((int)length);
                    SingleFileObjectStore.this.storeChannel.read(byteBuffer, byteAddress);
                    byteBuffer.flip();
                    this.numberOfKeys = byteBuffer.getInt();
                    byte flag = byteBuffer.get();
                    if (flag == 1) {
                        this.isLeaf = false;
                    }
                    StoreArea previous = null;
                    for (int i = 0; i < this.numberOfKeys; ++i) {
                        StoreArea storeArea = (StoreArea)Directory.this.makeStoreArea(byteBuffer.getLong(), byteBuffer.getLong(), byteBuffer.getLong());
                        if (previous == null) {
                            this.first = storeArea;
                        } else {
                            previous.next = storeArea;
                        }
                        previous = storeArea;
                        if (this.isLeaf) continue;
                        storeArea.childByteAddress = byteBuffer.getLong();
                        storeArea.childLength = byteBuffer.getLong();
                    }
                    if (!this.isLeaf) {
                        StoreArea storeArea = new StoreArea(null, null);
                        storeArea.childByteAddress = byteBuffer.getLong();
                        storeArea.childLength = byteBuffer.getLong();
                        previous.next = storeArea;
                    }
                }
                catch (IOException exception) {
                    ObjectManager.ffdc.processException(this, this.cclass, "<init>", exception, "1:1166:1.39");
                    if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                        trace.exit(this, this.cclass, "<init>");
                    }
                    SingleFileObjectStore.this.objectManagerState.requestShutdown();
                    throw new PermanentIOException((Object)this, exception);
                }
                finally {
                    SingleFileObjectStore.this.getLock.readLock().unlock();
                }
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit(this, this.cclass, "<init>");
                }
            }

            @Override
            void write() throws ObjectManagerException {
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.entry((Object)this, this.cclass, "write", new Object[]{new Long(this.byteAddress), new Long(this.length)});
                }
                if (this.modified) {
                    if (!this.isLeaf) {
                        StoreArea storeArea = (StoreArea)this.first;
                        while (storeArea != null) {
                            if (storeArea.child != null) {
                                ((Node)storeArea.child).write();
                                storeArea.childByteAddress = ((Node)storeArea.child).byteAddress;
                                storeArea.childLength = ((Node)storeArea.child).length;
                            }
                            storeArea = (StoreArea)storeArea.next;
                        }
                    }
                    SingleFileObjectStore.this.sharedBuffer.clear();
                    long directoryByteAddress = this.byteAddress;
                    SingleFileObjectStore.this.sharedBuffer.putInt(this.numberOfKeys);
                    if (this.isLeaf) {
                        SingleFileObjectStore.this.sharedBuffer.put((byte)0);
                    } else {
                        SingleFileObjectStore.this.sharedBuffer.put((byte)1);
                    }
                    StoreArea storeArea = (StoreArea)this.first;
                    while (storeArea != null) {
                        if (storeArea.getKey() != null) {
                            SingleFileObjectStore.this.sharedBuffer.putLong(storeArea.identifier);
                            SingleFileObjectStore.this.sharedBuffer.putLong(storeArea.byteAddress);
                            SingleFileObjectStore.this.sharedBuffer.putLong(storeArea.length);
                        }
                        if (!this.isLeaf) {
                            SingleFileObjectStore.this.sharedBuffer.putLong(storeArea.getChildByteAddress());
                            SingleFileObjectStore.this.sharedBuffer.putLong(storeArea.getChildLength());
                        }
                        if (SingleFileObjectStore.this.sharedBuffer.remaining() < 40) {
                            SingleFileObjectStore.this.sharedBuffer.flip();
                            int bytesWritten = SingleFileObjectStore.this.writeBuffer(SingleFileObjectStore.this.sharedBuffer, directoryByteAddress);
                            directoryByteAddress += (long)bytesWritten;
                            SingleFileObjectStore.this.sharedBuffer.clear();
                        }
                        storeArea = (StoreArea)storeArea.next;
                    }
                    SingleFileObjectStore.this.sharedBuffer.flip();
                    SingleFileObjectStore.this.writeBuffer(SingleFileObjectStore.this.sharedBuffer, directoryByteAddress);
                    this.modified = false;
                }
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit(this, this.cclass, "write");
                }
            }
        }

        class StoreArea
        extends AbstractSingleFileObjectStore.Directory.StoreArea {
            private final Class cclass;

            StoreArea(Object key, Object value) {
                super(key, value);
                this.cclass = StoreArea.class;
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.entry((Object)this, this.cclass, "<init>", new Object[]{key, value});
                }
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit(this, this.cclass, "<init>");
                }
            }

            StoreArea(long identifier, long byteAddress, long length) {
                super(identifier, byteAddress, length);
                this.cclass = StoreArea.class;
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.entry((Object)this, this.cclass, "<init>", new Object[]{new Long(identifier), new Long(byteAddress), new Long(length)});
                }
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit(this, this.cclass, "<init>");
                }
            }

            @Override
            BTree.Node getChild() throws ObjectManagerException {
                BTree.Node childRef;
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.entry((Object)this, this.cclass, "getChild", new Object[]{new Long(this.identifier), new Long(this.childByteAddress), new Long(this.childLength)});
                }
                if ((childRef = this.child) == null && this.childLength != 0L) {
                    SoftReference softReference = this.childSoftReference;
                    if (softReference != null) {
                        this.child = childRef = (BTree.Node)softReference.get();
                    }
                    if (childRef == null) {
                        this.child = childRef = new Node(this.childByteAddress, this.childLength);
                    }
                }
                if (childRef != null) {
                    ((Node)childRef).dormantFlushCount = 2;
                }
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, this.cclass, "getChild", new Object[]{childRef});
                }
                return childRef;
            }
        }
    }
}

