/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.server.clientsupport;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.common.CommsByteBuffer;
import com.ibm.ws.sib.comms.common.CommsByteBufferPool;
import com.ibm.ws.sib.comms.common.CommsUtils;
import com.ibm.ws.sib.comms.common.XidProxy;
import com.ibm.ws.sib.comms.server.ConversationState;
import com.ibm.ws.sib.comms.server.IdToTransactionTable;
import com.ibm.ws.sib.comms.server.ServerLinkLevelState;
import com.ibm.ws.sib.comms.server.clientsupport.CATConnection;
import com.ibm.ws.sib.comms.server.clientsupport.StaticCATHelper;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.JFapByteBuffer;
import com.ibm.ws.sib.transactions.mpspecific.MSSIXAResourceProvider;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SITransaction;
import com.ibm.wsspi.sib.core.SIXAResource;
import com.ibm.wsspi.sib.core.exception.SIConnectionUnavailableException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

public class StaticCATXATransaction {
    private static String CLASS_NAME = StaticCATXATransaction.class.getName();
    private static CommsByteBufferPool poolManager = CommsByteBufferPool.getInstance();
    private static final TraceComponent tc = SibTr.register(StaticCATXATransaction.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.comms.CWSICMessages");

    public static void rcvXAOpen(CommsByteBuffer request, Conversation conversation, int requestNumber, boolean allocatedFromBufferPool, boolean partOfExchange) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"rcvXAOpen", (Object)new Object[]{request, conversation, "" + requestNumber, "" + allocatedFromBufferPool, "" + partOfExchange});
        }
        short connectionObjectId = request.getShort();
        int clientTransactionId = request.getInt();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Connection Object ID", (Object)connectionObjectId);
            SibTr.debug((TraceComponent)tc, (String)"Transaction ID", (Object)clientTransactionId);
        }
        try {
            conversation.send((JFapByteBuffer)poolManager.allocate(), 176, requestNumber, 7, true, Conversation.ThrottlingPolicy.BLOCK_THREAD, null);
        }
        catch (SIException e) {
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvXAOpen"), (String)"3-013-0001");
            SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2027", (Object)((Object)e));
        }
        request.release(allocatedFromBufferPool);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"rcvXAOpen");
        }
    }

    public static void rcvXAStart(CommsByteBuffer request, Conversation conversation, int requestNumber, boolean allocatedFromBufferPool, boolean partOfExchange) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"rcvXAStart", (Object)new Object[]{request, conversation, "" + requestNumber, "" + allocatedFromBufferPool, "" + partOfExchange});
        }
        ConversationState convState = (ConversationState)conversation.getAttachment();
        try {
            int clientTransactionId = request.getInt();
            CATConnection catConn = (CATConnection)convState.getObject(convState.getConnectionObjectId());
            SICoreConnection connection = catConn.getSICoreConnection();
            ServerLinkLevelState linkState = (ServerLinkLevelState)conversation.getLinkLevelAttachment();
            SIXAResource xaResource = (SIXAResource)linkState.getTransactionTable().get(clientTransactionId, true);
            if (xaResource == null) {
                try {
                    xaResource = connection.getSIXAResource();
                }
                catch (SIConnectionUnavailableException e) {
                    if (!convState.hasMETerminated()) {
                        FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvXAStart"), (String)"3-013-0030");
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    }
                    throw new SIErrorException((Throwable)e);
                }
                catch (SIResourceException e) {
                    FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvXAStart"), (String)"3-013-0031");
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    }
                    throw new XAException(-3);
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"XAResource Object ID", (Object)clientTransactionId);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Getting Xid");
            }
            Xid xid = request.getXid();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Completed:", (Object)xid);
            }
            int flags = request.getInt();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Flags: ", (Object)flags);
            }
            xaResource.start(xid, flags);
            linkState.getTransactionTable().addGlobalTransactionBranch(clientTransactionId, conversation.getId(), xaResource, (XidProxy)xid, false);
            try {
                conversation.send((JFapByteBuffer)poolManager.allocate(), 177, requestNumber, 7, true, Conversation.ThrottlingPolicy.BLOCK_THREAD, null);
            }
            catch (SIException e) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvXAStart"), (String)"3-013-0003");
                SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2027", (Object)((Object)e));
            }
        }
        catch (XAException e) {
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvXAStart"), (String)"3-013-0004");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("XAException - RC: " + e.errorCode), (Object)e);
            }
            StaticCATHelper.sendExceptionToClient(e, "3-013-0004", conversation, requestNumber);
        }
        request.release(allocatedFromBufferPool);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"rcvXAStart");
        }
    }

    public static void rcvXAEnd(CommsByteBuffer request, Conversation conversation, int requestNumber, boolean allocatedFromBufferPool, boolean partOfExchange) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"rcvXAEnd", (Object)new Object[]{request, conversation, "" + requestNumber, "" + allocatedFromBufferPool, "" + partOfExchange});
        }
        ConversationState convState = (ConversationState)conversation.getAttachment();
        ServerLinkLevelState linkState = (ServerLinkLevelState)conversation.getLinkLevelAttachment();
        try {
            int clientTransactionId = request.getInt();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"XAResource Object ID", (Object)clientTransactionId);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Getting Xid");
            }
            Xid xid = request.getXid();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Completed:", (Object)xid);
            }
            int flags = request.getInt();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Flags: ", (Object)flags);
            }
            boolean requiresMSResource = false;
            if (conversation.getHandshakeProperties().getFapLevel() >= 5) {
                boolean bl = requiresMSResource = request.get() == 1;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"requires MS resource: ", (Object)("" + requiresMSResource));
                }
            }
            SITransaction tran = linkState.getTransactionTable().get(clientTransactionId);
            linkState.getTransactionTable().endGlobalTransactionBranch(clientTransactionId, (XidProxy)xid);
            if (tran != IdToTransactionTable.INVALID_TRANSACTION) {
                SIXAResource xaResource = StaticCATXATransaction.getResourceFromTran(tran, convState, requiresMSResource);
                xaResource.end(xid, flags);
            }
            try {
                conversation.send((JFapByteBuffer)poolManager.allocate(), 178, requestNumber, 7, true, Conversation.ThrottlingPolicy.BLOCK_THREAD, null);
            }
            catch (SIException e) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvXAClose"), (String)"3-013-0006");
                SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2027", (Object)((Object)e));
            }
        }
        catch (XAException e) {
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvXAClose"), (String)"3-013-0007");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("XAException - RC: " + e.errorCode), (Object)e);
            }
            StaticCATHelper.sendExceptionToClient(e, "3-013-0007", conversation, requestNumber);
        }
        request.release(allocatedFromBufferPool);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"rcvXAEnd");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rcvXAPrepare(CommsByteBuffer request, Conversation conversation, int requestNumber, boolean allocatedFromBufferPool, boolean partOfExchange) throws SIException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"rcvXAPrepare", (Object)new Object[]{request, conversation, "" + requestNumber, "" + allocatedFromBufferPool, "" + partOfExchange});
        }
        ConversationState convState = (ConversationState)conversation.getAttachment();
        ServerLinkLevelState linkState = (ServerLinkLevelState)conversation.getLinkLevelAttachment();
        SIXAResource tran = null;
        int clientTransactionId = 0;
        XidProxy xid = null;
        boolean optimizedTx = CommsUtils.requiresOptimizedTransaction((Conversation)conversation);
        try {
            clientTransactionId = request.getInt();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"XAResource Object ID", (Object)clientTransactionId);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Getting Xid");
            }
            xid = (XidProxy)request.getXid();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Completed:", (Object)xid);
            }
            boolean endRequired = false;
            int endFlags = 0;
            if (optimizedTx) {
                endRequired = request.get() == 1;
                endFlags = request.getInt();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"End Required:", (Object)("" + endRequired));
                    SibTr.debug((TraceComponent)tc, (String)"End Flags:", (Object)("" + endFlags));
                }
            }
            boolean requiresMSResource = false;
            if (conversation.getHandshakeProperties().getFapLevel() >= 5) {
                boolean bl = requiresMSResource = request.get() == 1;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Requires MS Resource:", (Object)("" + requiresMSResource));
                }
            }
            if (endRequired) {
                linkState.getTransactionTable().endOptimizedGlobalTransactionBranch(clientTransactionId, endFlags);
            }
            if ((tran = linkState.getTransactionTable().getResourceForGlobalTransactionBranch(clientTransactionId, xid)) == IdToTransactionTable.INVALID_TRANSACTION) {
                Throwable throwable = linkState.getTransactionTable().getExceptionForRollbackOnlyGlobalTransactionBranch(clientTransactionId, xid);
                if (throwable instanceof SIException) {
                    throw (SIException)throwable;
                }
                String errorMsg = nls.getFormattedMessage("TRANSACTION_MARKED_AS_ERROR_SICO2029", new Object[]{throwable}, null);
                XAException xa = new XAException(errorMsg);
                xa.initCause(throwable);
                xa.errorCode = 104;
                throw xa;
            }
            SIXAResource xaResource = StaticCATXATransaction.getResourceFromTran((SITransaction)tran, convState, requiresMSResource);
            boolean isUnitOfWorkInError = false;
            if (tran != null) {
                isUnitOfWorkInError = linkState.getTransactionTable().isGlobalTransactionBranchRollbackOnly(clientTransactionId, xid);
            }
            if (isUnitOfWorkInError) {
                xaResource.rollback((Xid)xid);
                Throwable throwable = linkState.getTransactionTable().getExceptionForRollbackOnlyGlobalTransactionBranch(clientTransactionId, xid);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"The transaction was marked as error due to", (Object)throwable);
                }
                XAException xa = new XAException(nls.getFormattedMessage("TRANSACTION_MARKED_AS_ERROR_SICO2029", new Object[]{throwable}, null));
                xa.initCause(throwable);
                xa.errorCode = 104;
                throw xa;
            }
            int rc = 0;
            try {
                rc = xaResource.prepare((Xid)xid);
            }
            finally {
                if (tran != null) {
                    linkState.getTransactionTable().removeGlobalTransactionBranch(clientTransactionId, xid);
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Prepare returned: " + rc));
            }
            if (rc == 3) {
                linkState.getDispatchableMap().removeDispatchableForGlobalTransaction(clientTransactionId, xid);
            }
            CommsByteBuffer reply = poolManager.allocate();
            reply.putInt(rc);
            try {
                conversation.send((JFapByteBuffer)reply, 179, requestNumber, 7, true, Conversation.ThrottlingPolicy.BLOCK_THREAD, null);
            }
            catch (SIException e) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvXAPrepare"), (String)"3-013-0009");
                SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2027", (Object)((Object)e));
            }
        }
        catch (XAException e) {
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvXAPrepare"), (String)"3-013-0010");
            if (tran != null && e.errorCode >= 100 && e.errorCode <= 107) {
                block30: {
                    try {
                        linkState.getTransactionTable().removeGlobalTransactionBranch(clientTransactionId, xid);
                    }
                    catch (SIErrorException sie) {
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block30;
                        SibTr.debug((TraceComponent)tc, (String)("Caught SIErrorException when calling remoteGlobalTransactionBranch: " + (Object)((Object)sie)));
                    }
                }
                linkState.getDispatchableMap().removeDispatchableForGlobalTransaction(clientTransactionId, xid);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("XAException - RC: " + e.errorCode), (Object)e);
            }
            StaticCATHelper.sendExceptionToClient(e, "3-013-0010", conversation, requestNumber);
        }
        request.release(allocatedFromBufferPool);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"rcvXAPrepare");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rcvXACommit(CommsByteBuffer request, Conversation conversation, int requestNumber, boolean allocatedFromBufferPool, boolean partOfExchange) throws SIException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"rcvXACommit", (Object)new Object[]{request, conversation, "" + requestNumber, "" + allocatedFromBufferPool, "" + partOfExchange});
        }
        ConversationState convState = (ConversationState)conversation.getAttachment();
        ServerLinkLevelState linkState = (ServerLinkLevelState)conversation.getLinkLevelAttachment();
        boolean onePhase = false;
        boolean optimizedTx = CommsUtils.requiresOptimizedTransaction((Conversation)conversation);
        try {
            byte onePhaseByte;
            int clientTransactionId = request.getInt();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"XAResource Object ID", (Object)clientTransactionId);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Getting Xid");
            }
            XidProxy xid = (XidProxy)request.getXid();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Completed:", (Object)xid);
            }
            if ((onePhaseByte = request.get()) == 1) {
                onePhase = true;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"One phase:", (Object)onePhase);
            }
            boolean endRequired = false;
            int endFlags = 0;
            if (optimizedTx) {
                endRequired = request.get() == 1;
                endFlags = request.getInt();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"End Required:", (Object)("" + endRequired));
                    SibTr.debug((TraceComponent)tc, (String)"End Flags:", (Object)("" + endFlags));
                }
            }
            boolean requiresMSResource = false;
            if (conversation.getHandshakeProperties().getFapLevel() >= 5) {
                boolean bl = requiresMSResource = request.get() == 1;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Requires MS Resource:", (Object)("" + requiresMSResource));
                }
            }
            IdToTransactionTable transactionTable = linkState.getTransactionTable();
            if (endRequired) {
                transactionTable.endOptimizedGlobalTransactionBranch(clientTransactionId, endFlags);
            }
            SIXAResource tran = null;
            boolean isInvalidTransaction = false;
            boolean isUnitOfWorkInError = false;
            Throwable rollbackException = null;
            IdToTransactionTable idToTransactionTable = transactionTable;
            synchronized (idToTransactionTable) {
                tran = transactionTable.getResourceForGlobalTransactionBranch(clientTransactionId, xid);
                if (tran != null) {
                    boolean bl = isInvalidTransaction = tran == IdToTransactionTable.INVALID_TRANSACTION;
                    if (!isInvalidTransaction) {
                        isUnitOfWorkInError = transactionTable.isGlobalTransactionBranchRollbackOnly(clientTransactionId, xid);
                    }
                    if (isInvalidTransaction || isUnitOfWorkInError) {
                        rollbackException = transactionTable.getExceptionForRollbackOnlyGlobalTransactionBranch(clientTransactionId, xid);
                    }
                    if (!isInvalidTransaction) {
                        transactionTable.removeGlobalTransactionBranch(clientTransactionId, xid);
                    }
                }
            }
            SIXAResource xaResource = StaticCATXATransaction.getResourceFromTran((SITransaction)tran, convState, requiresMSResource);
            if (isInvalidTransaction) {
                if (rollbackException instanceof SIException) {
                    throw (SIException)rollbackException;
                }
                String errorMsg = nls.getFormattedMessage("TRANSACTION_MARKED_AS_ERROR_SICO2029", new Object[]{rollbackException}, null);
                XAException xa = new XAException(errorMsg);
                xa.initCause(rollbackException);
                xa.errorCode = 104;
                throw xa;
            }
            if (isUnitOfWorkInError) {
                xaResource.rollback((Xid)xid);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"The transaction was marked as error due to", (Object)rollbackException);
                }
                XAException xa = new XAException(nls.getFormattedMessage("TRANSACTION_MARKED_AS_ERROR_SICO2029", new Object[]{rollbackException}, null));
                xa.initCause(rollbackException);
                xa.errorCode = 104;
                throw xa;
            }
            xaResource.commit((Xid)xid, onePhase);
            try {
                conversation.send((JFapByteBuffer)poolManager.allocate(), 180, requestNumber, 7, true, Conversation.ThrottlingPolicy.BLOCK_THREAD, null);
            }
            catch (SIException e) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvXACommit"), (String)"3-013-0012");
                SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2027", (Object)((Object)e));
            }
        }
        catch (XAException e) {
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvXACommit"), (String)"3-013-0013");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("XAException - RC: " + e.errorCode), (Object)e);
            }
            StaticCATHelper.sendExceptionToClient(e, "3-013-0013", conversation, requestNumber);
        }
        request.release(allocatedFromBufferPool);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"rcvXACommit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rcvXARollback(CommsByteBuffer request, Conversation conversation, int requestNumber, boolean allocatedFromBufferPool, boolean partOfExchange) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"rcvXARollback", (Object)new Object[]{request, conversation, "" + requestNumber, "" + allocatedFromBufferPool, "" + partOfExchange});
        }
        ConversationState convState = (ConversationState)conversation.getAttachment();
        ServerLinkLevelState linkState = (ServerLinkLevelState)conversation.getLinkLevelAttachment();
        boolean optimizedTx = CommsUtils.requiresOptimizedTransaction((Conversation)conversation);
        try {
            int clientTransactionId = request.getInt();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"XAResource Object ID", (Object)clientTransactionId);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Getting Xid");
            }
            XidProxy xid = (XidProxy)request.getXid();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Completed:", (Object)xid);
            }
            boolean endRequired = false;
            int endFlags = 0;
            if (optimizedTx) {
                endRequired = request.get() == 1;
                endFlags = request.getInt();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"End Required:", (Object)("" + endRequired));
                    SibTr.debug((TraceComponent)tc, (String)"End Flags:", (Object)("" + endFlags));
                }
            }
            boolean requiresMSResource = false;
            if (conversation.getHandshakeProperties().getFapLevel() >= 5) {
                boolean bl = requiresMSResource = request.get() == 1;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Requires MS Resource:", (Object)("" + requiresMSResource));
                }
            }
            IdToTransactionTable transactionTable = linkState.getTransactionTable();
            if (endRequired) {
                transactionTable.endOptimizedGlobalTransactionBranch(clientTransactionId, endFlags);
            }
            SIXAResource tran = null;
            IdToTransactionTable idToTransactionTable = transactionTable;
            synchronized (idToTransactionTable) {
                tran = transactionTable.getResourceForGlobalTransactionBranch(clientTransactionId, xid);
                if (tran != null) {
                    transactionTable.removeGlobalTransactionBranch(clientTransactionId, xid);
                }
            }
            if (tran != IdToTransactionTable.INVALID_TRANSACTION) {
                SIXAResource xaResource = StaticCATXATransaction.getResourceFromTran((SITransaction)tran, convState, requiresMSResource);
                xaResource.rollback((Xid)xid);
            }
            try {
                conversation.send((JFapByteBuffer)poolManager.allocate(), 181, requestNumber, 7, true, Conversation.ThrottlingPolicy.BLOCK_THREAD, null);
            }
            catch (SIException e) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvXARollback"), (String)"3-013-0015");
                SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2027", (Object)((Object)e));
            }
        }
        catch (XAException e) {
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvXARollback"), (String)"3-013-0016");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("XAException - RC: " + e.errorCode), (Object)e);
            }
            StaticCATHelper.sendExceptionToClient(e, "3-013-0016", conversation, requestNumber);
        }
        request.release(allocatedFromBufferPool);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"rcvXARollback");
        }
    }

    public static void rcvXARecover(CommsByteBuffer request, Conversation conversation, int requestNumber, boolean allocatedFromBufferPool, boolean partOfExchange) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"rcvXARecover", (Object)new Object[]{request, conversation, "" + requestNumber, "" + allocatedFromBufferPool, "" + partOfExchange});
        }
        ConversationState convState = (ConversationState)conversation.getAttachment();
        ServerLinkLevelState linkState = (ServerLinkLevelState)conversation.getLinkLevelAttachment();
        try {
            SITransaction tran;
            int clientTransactionId = request.getInt();
            int flags = request.getInt();
            boolean requiresMSResource = false;
            if (conversation.getHandshakeProperties().getFapLevel() >= 5) {
                boolean bl = requiresMSResource = request.get() == 1;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"XAResource Object ID", (Object)clientTransactionId);
                SibTr.debug((TraceComponent)tc, (String)"Flags: ", (Object)flags);
            }
            if ((tran = linkState.getTransactionTable().get(clientTransactionId, true)) == IdToTransactionTable.INVALID_TRANSACTION) {
                throw new XAException(-3);
            }
            SIXAResource xaResource = StaticCATXATransaction.getResourceFromTran(tran, convState, requiresMSResource);
            Xid[] xids = xaResource.recover(flags);
            CommsByteBuffer reply = poolManager.allocate();
            if (xids == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"recover() returned null");
                }
                reply.putShort(0);
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Serializing " + xids.length + " Xids"));
                }
                reply.putShort(xids.length);
                for (int x = 0; x < xids.length; ++x) {
                    reply.putXid(xids[x]);
                }
            }
            try {
                conversation.send((JFapByteBuffer)reply, 182, requestNumber, 7, true, Conversation.ThrottlingPolicy.BLOCK_THREAD, null);
            }
            catch (SIException e) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvXARecover"), (String)"3-013-0018");
                SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2027", (Object)((Object)e));
            }
        }
        catch (XAException e) {
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvXARecover"), (String)"3-013-0019");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("XAException - RC: " + e.errorCode), (Object)e);
            }
            StaticCATHelper.sendExceptionToClient(e, "3-013-0019", conversation, requestNumber);
        }
        request.release(allocatedFromBufferPool);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"rcvXARecover");
        }
    }

    public static void rcvXAForget(CommsByteBuffer request, Conversation conversation, int requestNumber, boolean allocatedFromBufferPool, boolean partOfExchange) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"rcvXAForget", (Object)new Object[]{request, conversation, "" + requestNumber, "" + allocatedFromBufferPool, "" + partOfExchange});
        }
        ConversationState convState = (ConversationState)conversation.getAttachment();
        ServerLinkLevelState linkState = (ServerLinkLevelState)conversation.getLinkLevelAttachment();
        try {
            SIXAResource tran;
            int clientTransactionId = request.getInt();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"XAResource Object ID", (Object)clientTransactionId);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Getting Xid");
            }
            XidProxy xid = (XidProxy)request.getXid();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Completed:", (Object)xid);
            }
            boolean requiresMSResource = false;
            if (conversation.getHandshakeProperties().getFapLevel() >= 5) {
                boolean bl = requiresMSResource = request.get() == 1;
            }
            if ((tran = linkState.getTransactionTable().getResourceForGlobalTransactionBranch(clientTransactionId, xid)) == IdToTransactionTable.INVALID_TRANSACTION) {
                linkState.getTransactionTable().removeGlobalTransactionBranch(clientTransactionId, xid);
            } else {
                SIXAResource xaResource = StaticCATXATransaction.getResourceFromTran((SITransaction)tran, convState, requiresMSResource);
                xaResource.forget((Xid)xid);
                if (tran != null) {
                    linkState.getTransactionTable().removeGlobalTransactionBranch(clientTransactionId, xid);
                }
            }
            try {
                conversation.send((JFapByteBuffer)poolManager.allocate(), 183, requestNumber, 7, true, Conversation.ThrottlingPolicy.BLOCK_THREAD, null);
            }
            catch (SIException e) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvXAForget"), (String)"3-013-0021");
                SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2027", (Object)((Object)e));
            }
        }
        catch (XAException e) {
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvXAForget"), (String)"3-013-0022");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("XAException - RC: " + e.errorCode), (Object)e);
            }
            StaticCATHelper.sendExceptionToClient(e, "3-013-0022", conversation, requestNumber);
        }
        request.release(allocatedFromBufferPool);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"rcvXAForget");
        }
    }

    public static void rcvXA_getTxTimeout(CommsByteBuffer request, Conversation conversation, int requestNumber, boolean allocatedFromBufferPool, boolean partOfExchange) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"rcvXA_getTxTimeout", (Object)new Object[]{request, conversation, "" + requestNumber, "" + allocatedFromBufferPool, "" + partOfExchange});
        }
        try {
            int clientTransactionId = request.getInt();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"XAResource Object ID", (Object)clientTransactionId);
            }
            ServerLinkLevelState linkState = (ServerLinkLevelState)conversation.getLinkLevelAttachment();
            SITransaction tran = linkState.getTransactionTable().get(clientTransactionId, true);
            int timeout = 0;
            if (tran != null && tran != IdToTransactionTable.INVALID_TRANSACTION) {
                SIXAResource xaResource = (SIXAResource)tran;
                timeout = xaResource.getTransactionTimeout();
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Timeout: " + timeout));
            }
            CommsByteBuffer reply = poolManager.allocate();
            reply.putInt(timeout);
            try {
                conversation.send((JFapByteBuffer)reply, 184, requestNumber, 7, true, Conversation.ThrottlingPolicy.BLOCK_THREAD, null);
            }
            catch (SIException e) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvXA_getTxTimeout"), (String)"3-013-0024");
                SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2027", (Object)((Object)e));
            }
        }
        catch (XAException e) {
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvXA_getTxTimeout"), (String)"3-013-0025");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("XAException - RC: " + e.errorCode), (Object)e);
            }
            StaticCATHelper.sendExceptionToClient(e, "3-013-0025", conversation, requestNumber);
        }
        request.release(allocatedFromBufferPool);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"rcvXA_getTxTimeout");
        }
    }

    public static void rcvXA_setTxTimeout(CommsByteBuffer request, Conversation conversation, int requestNumber, boolean allocatedFromBufferPool, boolean partOfExchange) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"rcvXA_setTxTimeout", (Object)new Object[]{request, conversation, "" + requestNumber, "" + allocatedFromBufferPool, "" + partOfExchange});
        }
        try {
            int clientTransactionId = request.getInt();
            int timeout = request.getInt();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"XAResource Object ID", (Object)clientTransactionId);
                SibTr.debug((TraceComponent)tc, (String)"Timeout", (Object)timeout);
            }
            ServerLinkLevelState linkState = (ServerLinkLevelState)conversation.getLinkLevelAttachment();
            SITransaction tran = linkState.getTransactionTable().get(clientTransactionId, true);
            boolean success = false;
            if (tran != null && tran != IdToTransactionTable.INVALID_TRANSACTION) {
                SIXAResource xaResource = (SIXAResource)tran;
                success = xaResource.setTransactionTimeout(timeout);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Result: " + success));
            }
            CommsByteBuffer reply = poolManager.allocate();
            if (success) {
                reply.put((byte)1);
            } else {
                reply.put((byte)0);
            }
            try {
                conversation.send((JFapByteBuffer)reply, 185, requestNumber, 7, true, Conversation.ThrottlingPolicy.BLOCK_THREAD, null);
            }
            catch (SIException e) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvXA_setTxTimeout"), (String)"3-013-0027");
                SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2027", (Object)((Object)e));
            }
        }
        catch (XAException e) {
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvXA_setTxTimeout"), (String)"3-013-0028");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("XAException - RC: " + e.errorCode), (Object)e);
            }
            StaticCATHelper.sendExceptionToClient(e, "3-013-0028", conversation, requestNumber);
        }
        request.release(allocatedFromBufferPool);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"rcvXA_setTxTimeout");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static SIXAResource getResourceFromTran(SITransaction tran, ConversationState convState, boolean msgStoreResource) throws XAException {
        SIXAResource result;
        block14: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"getResourceFromTran", (Object)new Object[]{tran, convState, msgStoreResource});
            }
            result = null;
            if (tran != null) {
                result = (SIXAResource)tran;
            } else {
                try {
                    SICoreConnection cc = ((CATConnection)convState.getObject(convState.getConnectionObjectId())).getSICoreConnection();
                    if (msgStoreResource) {
                        if (cc instanceof MSSIXAResourceProvider) {
                            result = ((MSSIXAResourceProvider)cc).getMSSIXAResource();
                            break block14;
                        } else {
                            SIErrorException e = new SIErrorException();
                            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".getResourceFromTran"), (String)"3-013-0034");
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                            }
                            throw e;
                        }
                    }
                    result = cc.getSIXAResource();
                }
                catch (SIConnectionUnavailableException e) {
                    if (!convState.hasMETerminated()) {
                        FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".getResourceFromTran"), (String)"3-013-0032");
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    }
                    throw new SIErrorException((Throwable)e);
                }
                catch (SIResourceException e) {
                    FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".getResourceFromTran"), (String)"3-013-0033");
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    }
                    throw new XAException(-3);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getResourceFromTran", (Object)result);
        }
        return result;
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.comms.server.impl/src/com/ibm/ws/sib/comms/server/clientsupport/StaticCATXATransaction.java, SIB.comms, WASX.SIB, aa1225.01 1.55");
        }
    }
}

