/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.cdi.internal.util;

import java.lang.reflect.Method;
import java.util.Optional;
import javax.validation.ValidatorFactory;
import org.hibernate.validator.HibernateValidatorFactory;
import org.hibernate.validator.internal.properties.DefaultGetterPropertySelectionStrategy;
import org.hibernate.validator.spi.properties.ConstrainableExecutable;
import org.hibernate.validator.spi.properties.GetterPropertySelectionStrategy;

public class GetterPropertySelectionStrategyHelper {
    private final GetterPropertySelectionStrategy getterPropertySelectionStrategy;

    private GetterPropertySelectionStrategyHelper(GetterPropertySelectionStrategy getterPropertySelectionStrategy) {
        this.getterPropertySelectionStrategy = getterPropertySelectionStrategy;
    }

    public Optional<String> getProperty(Method method) {
        return this.getterPropertySelectionStrategy.getProperty((ConstrainableExecutable)new ConstrainableMethod(method));
    }

    public static GetterPropertySelectionStrategyHelper forValidationFactory(ValidatorFactory factory) {
        Object getterPropertySelectionStrategy = factory instanceof HibernateValidatorFactory ? ((HibernateValidatorFactory)factory.unwrap(HibernateValidatorFactory.class)).getGetterPropertySelectionStrategy() : new DefaultGetterPropertySelectionStrategy();
        return new GetterPropertySelectionStrategyHelper((GetterPropertySelectionStrategy)getterPropertySelectionStrategy);
    }

    private static class ConstrainableMethod
    implements ConstrainableExecutable {
        private final Method method;

        private ConstrainableMethod(Method method) {
            this.method = method;
        }

        public Class<?> getReturnType() {
            return this.method.getReturnType();
        }

        public String getName() {
            return this.method.getName();
        }

        public Class<?>[] getParameterTypes() {
            return this.method.getParameterTypes();
        }
    }
}

