/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa;

import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.PersistenceConfiguration;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.spi.ClassTransformer;
import jakarta.persistence.spi.LoadState;
import jakarta.persistence.spi.PersistenceUnitInfo;
import jakarta.persistence.spi.ProviderUtil;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.exceptions.PersistenceUnitLoadingException;
import org.eclipse.persistence.internal.jpa.EntityManagerFactoryImpl;
import org.eclipse.persistence.internal.jpa.EntityManagerFactoryProvider;
import org.eclipse.persistence.internal.jpa.EntityManagerSetupImpl;
import org.eclipse.persistence.internal.jpa.deployment.JPAInitializer;
import org.eclipse.persistence.internal.jpa.deployment.JavaSECMPInitializer;
import org.eclipse.persistence.internal.jpa.deployment.PersistenceUnitProcessor;
import org.eclipse.persistence.internal.jpa.deployment.SEPersistenceUnitInfo;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;

public class PersistenceProvider
implements jakarta.persistence.spi.PersistenceProvider,
ProviderUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EntityManagerFactoryImpl createEntityManagerFactoryImpl(PersistenceUnitInfo puInfo, Map properties, boolean requiresConnection) {
        if (puInfo != null) {
            String puName;
            EntityManagerSetupImpl emSetupImpl;
            String sessionName;
            String uniqueName;
            boolean isNew;
            block23: {
                isNew = false;
                uniqueName = null;
                sessionName = null;
                emSetupImpl = null;
                puName = puInfo.getPersistenceUnitName();
                JPAInitializer initializer = this.getInitializer(puInfo.getPersistenceUnitName(), properties);
                try {
                    if (EntityManagerSetupImpl.mustBeCompositeMember(puInfo)) {
                        emSetupImpl = new EntityManagerSetupImpl(puName, puName);
                        emSetupImpl.predeploy(puInfo, properties);
                        isNew = true;
                        break block23;
                    }
                    uniqueName = initializer.isPersistenceUnitUniquelyDefinedByName() ? puName : initializer.createUniquePersistenceUnitName(puInfo);
                    sessionName = EntityManagerSetupImpl.getOrBuildSessionName(properties, puInfo, uniqueName);
                    Map<String, EntityManagerSetupImpl> map = EntityManagerFactoryProvider.emSetupImpls;
                    synchronized (map) {
                        emSetupImpl = EntityManagerFactoryProvider.getEntityManagerSetupImpl(sessionName);
                        if (emSetupImpl == null) {
                            emSetupImpl = initializer.extractInitialEmSetupImpl(puName);
                            if (emSetupImpl != null) {
                                emSetupImpl.changeSessionName(sessionName);
                            } else {
                                emSetupImpl = initializer.callPredeploy((SEPersistenceUnitInfo)puInfo, properties, uniqueName, sessionName);
                            }
                            emSetupImpl.predeploy(emSetupImpl.getPersistenceUnitInfo(), properties);
                            EntityManagerFactoryProvider.addEntityManagerSetupImpl(sessionName, emSetupImpl);
                            isNew = true;
                        }
                    }
                }
                catch (Exception e) {
                    throw PersistenceUnitLoadingException.exceptionSearchingForPersistenceResources(initializer.getInitializationClassLoader(), e);
                }
            }
            if (!isNew) {
                if (!uniqueName.equals(emSetupImpl.getPersistenceUnitUniqueName())) {
                    throw PersistenceUnitLoadingException.sessionNameAlreadyInUse(sessionName, uniqueName, emSetupImpl.getPersistenceUnitUniqueName());
                }
                boolean undeployed = false;
                EntityManagerSetupImpl entityManagerSetupImpl = emSetupImpl;
                synchronized (entityManagerSetupImpl) {
                    if (emSetupImpl.isUndeployed()) {
                        undeployed = true;
                    } else {
                        emSetupImpl.predeploy(emSetupImpl.getPersistenceUnitInfo(), properties);
                    }
                }
                if (undeployed) {
                    return (EntityManagerFactoryImpl)this.createEntityManagerFactory(puName, properties);
                }
            }
            EntityManagerFactoryImpl factory = null;
            try {
                factory = new EntityManagerFactoryImpl(emSetupImpl, properties);
                emSetupImpl.setRequiresConnection(requiresConnection);
                emSetupImpl.preInitializeCanonicalMetamodel(factory);
                if (emSetupImpl.shouldGetSessionOnCreateFactory(properties)) {
                    factory.getDatabaseSession();
                }
                return factory;
            }
            catch (RuntimeException ex) {
                if (factory != null) {
                    factory.close();
                } else {
                    emSetupImpl.undeploy();
                }
                throw ex;
            }
        }
        return null;
    }

    public EntityManagerFactory createEntityManagerFactory(String emName, Map<?, ?> properties) {
        HashMap nonNullProperties;
        HashMap hashMap = nonNullProperties = properties == null ? new HashMap() : properties;
        if (PersistenceProvider.checkForProviderProperty(nonNullProperties)) {
            String name = emName == null ? "" : emName;
            JPAInitializer initializer = this.getInitializer(name, nonNullProperties);
            return this.createEntityManagerFactoryImpl(initializer.findPersistenceUnitInfo(name, nonNullProperties), nonNullProperties, true);
        }
        return null;
    }

    public EntityManagerFactory createEntityManagerFactory(PersistenceConfiguration configuration) {
        URL rootURL;
        if (!PersistenceProvider.isProviderEclipseLink(configuration)) {
            return null;
        }
        JPAInitializer initializer = this.getInitializer(configuration.name(), configuration.properties());
        StackWalker stackWalker = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
        StackWalker.StackFrame frame = stackWalker.walk(stream -> stream.dropWhile(f -> PersistenceProvider.class.getName().equals(f.getClassName())).dropWhile(f -> f.getClassName().startsWith("jakarta.persistence")).findFirst().orElse(null));
        if (frame != null) {
            try {
                rootURL = PrivilegedAccessHelper.callDoPrivileged(() -> frame.getDeclaringClass().getProtectionDomain().getCodeSource().getLocation());
            }
            catch (SecurityException e) {
                Class<?> callerClass = frame.getDeclaringClass();
                rootURL = callerClass.getResource(callerClass.getSimpleName() + ".class");
                if (rootURL == null) {
                    throw new PersistenceException(ExceptionLocalization.buildMessage("custom_pu_create_error_no_caller_class_url", new String[]{configuration.name(), callerClass.getName()}));
                }
                String classSuffix = callerClass.getName().replaceAll("\\.", "/") + ".class";
                try {
                    rootURL = PersistenceUnitProcessor.computePURootURL(rootURL, classSuffix);
                }
                catch (IOException | URISyntaxException ex) {
                    throw new PersistenceException(ExceptionLocalization.buildMessage("custom_pu_create_error", new String[]{configuration.name()}), (Throwable)ex);
                }
            }
        } else {
            throw new PersistenceException(ExceptionLocalization.buildMessage("custom_pu_create_error_no_caller", new String[]{configuration.name()}));
        }
        return this.createEntityManagerFactoryImpl(initializer.customPersistenceUnitInfo(configuration, rootURL), Collections.emptyMap(), true);
    }

    public void generateSchema(PersistenceUnitInfo info, Map properties) {
        if (PersistenceProvider.checkForProviderProperty(properties)) {
            this.createContainerEntityManagerFactoryImpl(info, properties, false).close();
        }
    }

    public boolean generateSchema(String persistenceUnitName, Map properties) {
        JPAInitializer initializer;
        SEPersistenceUnitInfo puInfo;
        Map nonNullProperties;
        String puName = persistenceUnitName == null ? "" : persistenceUnitName;
        Map map = nonNullProperties = properties == null ? new HashMap() : properties;
        if (PersistenceProvider.checkForProviderProperty(nonNullProperties) && (puInfo = (initializer = this.getInitializer(puName, nonNullProperties)).findPersistenceUnitInfo(puName, nonNullProperties)) != null && PersistenceProvider.checkForProviderProperty(properties)) {
            this.createEntityManagerFactoryImpl(puInfo, properties, false).close();
            return true;
        }
        return false;
    }

    public JPAInitializer getInitializer(String emName, Map m) {
        ClassLoader classLoader = this.getClassLoader(emName, m);
        return JavaSECMPInitializer.getJavaSECMPInitializer(classLoader);
    }

    static boolean isProviderEclipseLink(PersistenceConfiguration configuration) {
        if (configuration.properties().containsKey("jakarta.persistence.provider")) {
            return PersistenceProvider.isProviderPropertyEclipseLink(configuration.properties().get("jakarta.persistence.provider"));
        }
        if (configuration.provider() != null && !configuration.provider().isEmpty()) {
            return PersistenceProvider.checkEclipseLinkProviderClassName(configuration.provider());
        }
        return true;
    }

    public static boolean checkForProviderProperty(Map<?, ?> properties) {
        return !properties.containsKey("jakarta.persistence.provider") || PersistenceProvider.isProviderPropertyEclipseLink(properties.get("jakarta.persistence.provider"));
    }

    private static boolean isProviderPropertyEclipseLink(Object providerProperty) {
        String providerString;
        String providerClassName;
        String string = providerClassName = providerProperty instanceof String ? (providerString = (String)providerProperty) : null;
        if (providerProperty instanceof Class) {
            Class providerClass = (Class)providerProperty;
            providerClassName = providerClass.getName();
        }
        return providerClassName != null && PersistenceProvider.checkEclipseLinkProviderClassName(providerClassName);
    }

    private static boolean checkEclipseLinkProviderClassName(String providerClassName) {
        return PersistenceProvider.class.getName().equals(providerClassName) || EntityManagerFactoryProvider.class.getName().equals(providerClassName);
    }

    public EntityManagerFactory createContainerEntityManagerFactory(PersistenceUnitInfo info, Map properties) {
        return this.createContainerEntityManagerFactoryImpl(info, properties, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EntityManagerFactory createContainerEntityManagerFactoryImpl(PersistenceUnitInfo info, Map properties, boolean requiresConnection) {
        JavaSECMPInitializer.setIsInContainer(true);
        Map nonNullProperties = properties == null ? new HashMap() : properties;
        String forceTargetServer = EntityManagerFactoryProvider.getConfigPropertyAsString("eclipselink.target-server.enforce", null);
        if ("true".equalsIgnoreCase(forceTargetServer)) {
            nonNullProperties.remove("eclipselink.target-server");
        }
        EntityManagerSetupImpl emSetupImpl = null;
        if (EntityManagerSetupImpl.mustBeCompositeMember(info)) {
            emSetupImpl = new EntityManagerSetupImpl(info.getPersistenceUnitName(), info.getPersistenceUnitName());
            emSetupImpl.predeploy(info, nonNullProperties);
        } else {
            boolean isNew = false;
            ClassTransformer transformer = null;
            String uniqueName = PersistenceUnitProcessor.buildPersistenceUnitName(info.getPersistenceUnitRootUrl(), info.getPersistenceUnitName(), null);
            String sessionName = EntityManagerSetupImpl.getOrBuildSessionName(nonNullProperties, info, uniqueName);
            Map<String, EntityManagerSetupImpl> map = EntityManagerFactoryProvider.emSetupImpls;
            synchronized (map) {
                emSetupImpl = EntityManagerFactoryProvider.getEntityManagerSetupImpl(sessionName);
                if (emSetupImpl == null) {
                    emSetupImpl = new EntityManagerSetupImpl(uniqueName, sessionName);
                    isNew = true;
                    emSetupImpl.setIsInContainerMode(true);
                    transformer = emSetupImpl.predeploy(info, nonNullProperties);
                    EntityManagerFactoryProvider.addEntityManagerSetupImpl(sessionName, emSetupImpl);
                }
            }
            if (!isNew) {
                if (!uniqueName.equals(emSetupImpl.getPersistenceUnitUniqueName())) {
                    throw PersistenceUnitLoadingException.sessionNameAlreadyInUse(sessionName, uniqueName, emSetupImpl.getPersistenceUnitUniqueName());
                }
                boolean undeployed = false;
                EntityManagerSetupImpl entityManagerSetupImpl = emSetupImpl;
                synchronized (entityManagerSetupImpl) {
                    if (emSetupImpl.isUndeployed()) {
                        undeployed = true;
                    } else {
                        transformer = emSetupImpl.predeploy(emSetupImpl.getPersistenceUnitInfo(), nonNullProperties);
                    }
                }
                if (undeployed) {
                    return this.createContainerEntityManagerFactory(info, properties);
                }
            }
            if (transformer != null) {
                info.addTransformer(transformer);
            }
        }
        EntityManagerFactoryImpl factory = null;
        try {
            factory = new EntityManagerFactoryImpl(emSetupImpl, nonNullProperties);
            emSetupImpl.setRequiresConnection(requiresConnection);
            emSetupImpl.preInitializeCanonicalMetamodel(factory);
            if (emSetupImpl.shouldGetSessionOnCreateFactory(nonNullProperties)) {
                factory.getDatabaseSession();
            }
            return factory;
        }
        catch (RuntimeException ex) {
            if (factory != null) {
                factory.close();
            } else {
                emSetupImpl.undeploy();
            }
            throw ex;
        }
    }

    public ProviderUtil getProviderUtil() {
        return this;
    }

    public LoadState isLoadedWithoutReference(Object entity, String attributeName) {
        if (entity instanceof PersistenceWeaved) {
            return this.isLoadedWithReference(entity, attributeName);
        }
        return LoadState.UNKNOWN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoadState isLoadedWithReference(Object entity, String attributeName) {
        Map<String, EntityManagerSetupImpl> map = EntityManagerFactoryProvider.emSetupImpls;
        synchronized (map) {
            for (EntityManagerSetupImpl setup : EntityManagerFactoryProvider.emSetupImpls.values()) {
                Boolean isLoaded;
                if (!setup.isDeployed() || (isLoaded = EntityManagerFactoryImpl.isLoaded(entity, setup.getSession())) == null) continue;
                if (isLoaded.booleanValue() && attributeName != null) {
                    isLoaded = EntityManagerFactoryImpl.isLoaded(entity, attributeName, setup.getSession());
                }
                if (isLoaded == null) continue;
                return isLoaded != false ? LoadState.LOADED : LoadState.NOT_LOADED;
            }
            return LoadState.UNKNOWN;
        }
    }

    public LoadState isLoaded(Object entity) {
        if (entity instanceof PersistenceWeaved) {
            return this.isLoadedWithReference(entity, null);
        }
        return LoadState.UNKNOWN;
    }

    public ClassLoader getClassLoader(String emName, Map properties) {
        ClassLoader classloader = null;
        if (properties != null) {
            classloader = (ClassLoader)properties.get("eclipselink.classloader");
        }
        if (classloader == null) {
            classloader = Thread.currentThread().getContextClassLoader();
        }
        return classloader;
    }
}

