/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.netty.internal.tcp;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.netty.bootstrap.AbstractBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.openliberty.netty.internal.BootstrapConfiguration;
import io.openliberty.netty.internal.BootstrapExtended;
import io.openliberty.netty.internal.ChannelInitializerWrapper;
import io.openliberty.netty.internal.ConfigConstants;
import io.openliberty.netty.internal.ServerBootstrapExtended;
import io.openliberty.netty.internal.exception.NettyException;
import io.openliberty.netty.internal.impl.NettyFrameworkImpl;
import io.openliberty.netty.internal.tcp.TCPChannelInitializerImpl;
import io.openliberty.netty.internal.tcp.TCPConfigurationImpl;
import java.net.Inet6Address;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.UnresolvedAddressException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.concurrent.Callable;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class TCPUtils {
    private static final TraceComponent tc = Tr.register(TCPUtils.class, (String[])new String[]{"TCPChannel", "Netty"}, (String)"com.ibm.ws.tcpchannel.internal.resources.TCPChannelMessages", (String)TCPUtils.class.getName());
    private static final int timeBetweenRetriesMsec = 1000;
    static final long serialVersionUID = 1838808247492979456L;

    public static ServerBootstrapExtended createTCPBootstrapInbound(NettyFrameworkImpl framework, Map<String, Object> tcpOptions) throws NettyException {
        TCPConfigurationImpl config = new TCPConfigurationImpl(tcpOptions, true);
        ServerBootstrapExtended bs = new ServerBootstrapExtended();
        bs.group(framework.getParentGroup(), framework.getChildGroup());
        bs.channel(NioServerSocketChannel.class);
        bs.applyConfiguration((BootstrapConfiguration)config);
        TCPChannelInitializerImpl tcpInitializer = new TCPChannelInitializerImpl(config, framework);
        bs.setBaseInitializer((ChannelInitializerWrapper)tcpInitializer);
        return bs;
    }

    public static BootstrapExtended createTCPBootstrapOutbound(NettyFrameworkImpl framework, Map<String, Object> tcpOptions) throws NettyException {
        TCPConfigurationImpl config = new TCPConfigurationImpl(tcpOptions, false);
        BootstrapExtended bs = new BootstrapExtended();
        bs.group(framework.getChildGroup());
        bs.channel(NioSocketChannel.class);
        bs.applyConfiguration((BootstrapConfiguration)config);
        TCPChannelInitializerImpl tcpInitializer = new TCPChannelInitializerImpl(config, framework);
        bs.setBaseInitializer((ChannelInitializerWrapper)tcpInitializer);
        return bs;
    }

    private static ChannelFuture open(NettyFrameworkImpl framework, Channel channel, TCPConfigurationImpl config, String inetHost, int inetPort, ChannelFutureListener openListener, int retryCount) {
        if (!channel.isOpen()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Channel not started because it was closed: " + channel), (Object[])new Object[0]);
            }
            return null;
        }
        ChannelFuture oFuture = null;
        if (inetHost.equals("*")) {
            inetHost = "0.0.0.0";
        }
        oFuture = config.isInbound() ? channel.bind((SocketAddress)new InetSocketAddress(inetHost, inetPort)) : channel.connect((SocketAddress)new InetSocketAddress(inetHost, inetPort));
        ChannelFuture openFuture = oFuture;
        String newHost = inetHost;
        openFuture.addListener(future -> {
            if (future.isSuccess()) {
                Object object;
                channel.attr(ConfigConstants.NAME_KEY).set((Object)config.getExternalName());
                channel.attr(ConfigConstants.HOST_KEY).set((Object)newHost);
                channel.attr(ConfigConstants.PORT_KEY).set((Object)inetPort);
                channel.attr(ConfigConstants.IS_INBOUND_KEY).set((Object)config.isInbound());
                channel.closeFuture().addListener(innerFuture -> TCPUtils.logChannelStopped(innerFuture, channel));
                if (config.isInbound()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Adding new channel group for " + channel), (Object[])new Object[0]);
                    }
                    object = framework.getActiveChannelsMap();
                    synchronized (object) {
                        framework.getActiveChannelsMap().put(channel, (ChannelGroup)new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE));
                    }
                }
                object = framework.getOutboundConnections();
                synchronized (object) {
                    framework.getOutboundConnections().add((Object)channel);
                }
                String hostLogString = newHost;
                SocketAddress addr = channel.localAddress();
                InetSocketAddress inetAddr = (InetSocketAddress)addr;
                String IPvType = "IPv4";
                if (inetAddr.getAddress() instanceof Inet6Address) {
                    IPvType = "IPv6";
                }
                hostLogString = newHost == "0.0.0.0" ? "*  (" + IPvType + ")" : config.getHostname() + "  (" + IPvType + ": " + inetAddr.getAddress().getHostAddress() + ")";
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("serverSocket getInetAddress is: " + inetAddr), (Object[])new Object[0]);
                    Tr.debug((TraceComponent)tc, (String)("serverSocket getLocalSocketAddress is: " + channel.localAddress()), (Object[])new Object[0]);
                    Tr.debug((TraceComponent)tc, (String)("serverSocket getInetAddress hostname is: " + inetAddr.getAddress().getHostName()), (Object[])new Object[0]);
                    Tr.debug((TraceComponent)tc, (String)("serverSocket getInetAddress address is: " + inetAddr.getAddress().getHostAddress()), (Object[])new Object[0]);
                    Tr.debug((TraceComponent)tc, (String)("channelConfig.getHostname() is: " + config.getHostname()), (Object[])new Object[0]);
                    Tr.debug((TraceComponent)tc, (String)("channelConfig.getPort() is: " + config.getPort()), (Object[])new Object[0]);
                }
                if (config.isInbound()) {
                    Tr.info((TraceComponent)tc, (String)"TCP_CHANNEL_STARTED", (Object[])new Object[]{config.getExternalName(), hostLogString, String.valueOf(inetPort)});
                } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"TCP_CHANNEL_STARTED", (Object[])new Object[]{config.getExternalName(), hostLogString, String.valueOf(inetPort)});
                }
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("open failed for " + config.getExternalName() + " due to: " + future.cause().getMessage()), (Object[])new Object[0]);
                }
                if (retryCount > 0) {
                    block31: {
                        if (!channel.isOpen()) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Channel not open so it must have been cancelled. Returning...", (Object[])new Object[0]);
                            }
                            return;
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("attempt " + retryCount + " of " + (config.getPortOpenRetries() + 1) + " failed to open the port, will try again after wait interval"), (Object[])new Object[0]);
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException x) {
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block31;
                            Tr.debug((TraceComponent)tc, (String)"sleep caught InterruptedException.  will proceed.", (Object[])new Object[0]);
                        }
                    }
                    TCPUtils.open(framework, channel, config, newHost, inetPort, openListener, retryCount - 1);
                } else {
                    if (!channel.isOpen()) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"No retries left and channel is not open so not printing any logs. Returning...", (Object[])new Object[0]);
                        }
                        return;
                    }
                    boolean unresolvedAddress = false;
                    for (Throwable cause = future.cause(); cause != null; cause = cause.getCause()) {
                        if (!(cause instanceof UnresolvedAddressException)) continue;
                        unresolvedAddress = true;
                        break;
                    }
                    if (unresolvedAddress) {
                        Tr.error((TraceComponent)tc, (String)"LOCAL_HOST_UNRESOLVED", (Object[])new Object[]{config.getExternalName(), newHost, String.valueOf(inetPort)});
                    } else if (config.isInbound()) {
                        Tr.error((TraceComponent)tc, (String)"BIND_ERROR", (Object[])new Object[]{config.getExternalName(), newHost, String.valueOf(inetPort), openFuture.cause().getMessage()});
                    } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"BIND_ERROR", (Object[])new Object[]{config.getExternalName(), newHost, String.valueOf(inetPort), openFuture.cause().getMessage()});
                    }
                }
            }
        });
        if (openListener != null) {
            openFuture.addListener((GenericFutureListener)TCPUtils.generateOpenListenerWrapper(framework, openListener));
        }
        return openFuture;
    }

    private static ChannelFutureListener generateOpenListenerWrapper(final NettyFrameworkImpl framework, final ChannelFutureListener listener) {
        return new ChannelFutureListener(){
            static final long serialVersionUID = 7985650594614330167L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            public void operationComplete(final ChannelFuture future) throws Exception {
                framework.getExecutorService().execute(new Runnable(){
                    static final long serialVersionUID = -3003960794804541334L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public void run() {
                        try {
                            listener.operationComplete((Future)future);
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, (String)"io.openliberty.netty.internal.tcp.TCPUtils$1$1", (String)"256", (Object)this, (Object[])new Object[0]);
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Exception caught running open listener!! Closing channel just in case", (Object[])new Object[0]);
                            }
                            future.channel().close();
                        }
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"io.openliberty.netty.internal.tcp.TCPUtils$1$1", 1.class, null, null);
                    }
                });
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"io.openliberty.netty.internal.tcp.TCPUtils$1", 1.class, null, null);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private static Channel startHelper(final NettyFrameworkImpl framework, final AbstractBootstrap bootstrap, final TCPConfigurationImpl config, final String inetHost, final int inetPort, final ChannelFutureListener openListener) throws NettyException {
        if (framework.isStopping()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"server is stopping, channel will not be started", (Object[])new Object[0]);
            }
            return null;
        }
        try {
            final Channel channel = System.getSecurityManager() == null ? bootstrap.register().channel() : AccessController.doPrivileged(new PrivilegedAction<ChannelFuture>(){
                static final long serialVersionUID = 8127791216300023767L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public ChannelFuture run() {
                    return bootstrap.register();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"io.openliberty.netty.internal.tcp.TCPUtils$2", 2.class, null, null);
                }
            }).channel();
            framework.runWhenServerStarted(new Callable<ChannelFuture>(){
                static final long serialVersionUID = 4674721495413083331L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public ChannelFuture call() {
                    return TCPUtils.open(framework, channel, config, inetHost, inetPort, openListener, config.getPortOpenRetries());
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"io.openliberty.netty.internal.tcp.TCPUtils$3", 3.class, null, null);
                }
            });
            return channel;
        }
        catch (Exception channel) {
            FFDCFilter.processException((Throwable)channel, (String)"io.openliberty.netty.internal.tcp.TCPUtils", (String)"298", null, (Object[])new Object[]{framework, bootstrap, config, inetHost, inetPort, openListener});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                void e;
                Tr.debug((TraceComponent)tc, (String)("NettyFramework signaled- caught exception: " + e.getMessage()), (Object[])new Object[0]);
            }
            return null;
        }
    }

    public static Channel startInbound(NettyFrameworkImpl framework, ServerBootstrapExtended bootstrap, String inetHost, int inetPort, ChannelFutureListener openListener) throws NettyException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("start (TCP): attempt to bind a channel at host " + inetHost + " port " + inetPort), (Object[])new Object[0]);
        }
        TCPConfigurationImpl config = (TCPConfigurationImpl)bootstrap.getConfiguration();
        return TCPUtils.startHelper(framework, (AbstractBootstrap)bootstrap, config, inetHost, inetPort, openListener);
    }

    public static Channel startOutbound(NettyFrameworkImpl framework, BootstrapExtended bootstrap, String inetHost, int inetPort, ChannelFutureListener openListener) throws NettyException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("startOutbound (TCP): attempt to connect to host " + inetHost + " port " + inetPort), (Object[])new Object[0]);
        }
        TCPConfigurationImpl config = (TCPConfigurationImpl)bootstrap.getConfiguration();
        return TCPUtils.startHelper(framework, (AbstractBootstrap)bootstrap, config, inetHost, inetPort, openListener);
    }

    public static void logChannelStopped(Channel channel) {
        String channelName = (String)channel.attr(ConfigConstants.NAME_KEY).get();
        String host = (String)channel.attr(ConfigConstants.HOST_KEY).get();
        Integer port = (Integer)channel.attr(ConfigConstants.PORT_KEY).get();
        Boolean inbound = (Boolean)channel.attr(ConfigConstants.IS_INBOUND_KEY).get();
        if (inbound != null && inbound.booleanValue()) {
            Tr.info((TraceComponent)tc, (String)"TCP_CHANNEL_STOPPED", (Object[])new Object[]{channelName, host, String.valueOf(port)});
        } else if (inbound != null && !inbound.booleanValue()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"TCP_CHANNEL_STOPPED", (Object[])new Object[]{channelName, host, String.valueOf(port)});
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Socket channel closed, local: " + channel.localAddress() + " remote: " + channel.remoteAddress()), (Object[])new Object[0]);
        }
    }

    public static void logChannelStopped(java.util.concurrent.Future<?> future, Channel channel) {
        boolean completed;
        TCPUtils.logChannelStopped(channel);
        boolean bl = completed = future.isDone() && !future.isCancelled();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Channel stop future: done and not cancelled --> {0} for port {1}", (Object[])new Object[]{completed, String.valueOf(channel.attr(ConfigConstants.PORT_KEY).get())});
        }
    }

    public static void logChannelStarted(Channel channel) {
        String channelName = (String)channel.attr(ConfigConstants.NAME_KEY).get();
        String host = (String)channel.attr(ConfigConstants.HOST_KEY).get();
        Integer port = (Integer)channel.attr(ConfigConstants.PORT_KEY).get();
        if (((Boolean)channel.attr(ConfigConstants.IS_INBOUND_KEY).get()).booleanValue()) {
            Tr.info((TraceComponent)tc, (String)"TCP_CHANNEL_STARTED", (Object[])new Object[]{channelName, host, String.valueOf(port)});
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"TCP_CHANNEL_STARTED", (Object[])new Object[]{channelName, host, String.valueOf(port)});
        }
    }
}

