/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.MessageDecodeFailedException;
import com.ibm.ws.sib.mfp.MessageRestoreFailedException;
import com.ibm.ws.sib.utils.DataSlice;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.List;

public abstract class JsMessageFactory {
    private static TraceComponent tc = SibTr.register(JsMessageFactory.class, (String)"SIBMfp", (String)"com.ibm.ws.sib.mfp.CWSIFMessages");
    private static JsMessageFactory instance = null;
    private static Exception createException = null;

    public static JsMessageFactory getInstance() throws Exception {
        if (instance == null) {
            throw createException;
        }
        return instance;
    }

    public abstract JsMessage createInboundJsMessage(byte[] var1, int var2, int var3) throws MessageDecodeFailedException;

    public abstract JsMessage createInboundJsMessage(byte[] var1, int var2, int var3, Object var4) throws MessageDecodeFailedException;

    public abstract JsMessage createInboundJsMessage(List<DataSlice> var1) throws MessageDecodeFailedException;

    public abstract JsMessage createInboundJsMessage(List<DataSlice> var1, Object var2) throws MessageDecodeFailedException;

    public abstract JsMessage createInboundWebMessage(String var1) throws MessageDecodeFailedException;

    public abstract JsMessage restoreJsMessage(List<DataSlice> var1, Object var2) throws MessageRestoreFailedException;

    private static void createFactoryInstance() throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createFactoryInstance");
        }
        try {
            Class<?> cls = Class.forName("com.ibm.ws.sib.mfp.impl.JsMessageFactoryImpl");
            instance = (JsMessageFactory)cls.newInstance();
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.mfp.JsMessageFactory.createFactoryInstance", (String)"134");
            SibTr.error((TraceComponent)tc, (String)"UNABLE_TO_CREATE_FACTORY_CWSIF0001", (Object)e);
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createFactoryInstance");
        }
    }

    static {
        try {
            JsMessageFactory.createFactoryInstance();
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.mfp.JsMessageFactory.<clinit>", (String)"95");
            createException = e;
        }
    }
}

