/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.objectManager;

import com.ibm.ws.objectManager.FileLogInput;
import com.ibm.ws.objectManager.FileLogOutput;
import com.ibm.ws.objectManager.InvalidLogFileSignatureException;
import com.ibm.ws.objectManager.LogFileExhaustedException;
import com.ibm.ws.objectManager.LogFileHeaderCorruptException;
import com.ibm.ws.objectManager.ObjectManager;
import com.ibm.ws.objectManager.ObjectManagerByteArrayOutputStream;
import com.ibm.ws.objectManager.ObjectManagerException;
import com.ibm.ws.objectManager.PermanentIOException;
import com.ibm.ws.objectManager.utils.Trace;
import com.ibm.ws.objectManager.utils.Tracing;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Date;

public class FileLogHeader {
    private static final Class cclass = FileLogHeader.class;
    private static Trace trace = ObjectManager.traceFactory.getTrace(cclass, "ObjectManagerLog");
    protected static final int headerLength = 4096;
    protected static final int writeVersion = 0;
    protected int instanceVersion = 0;
    protected byte sectorByte = 1;
    protected long startByteAddress;
    protected long fileSize;
    protected long headerSequence = 0L;
    protected long headerWriteTime;
    static final String signature = "++ObjectManager.LogFile++";

    protected FileLogHeader() throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "<init>");
            trace.exit(this, cclass, "<init>");
        }
    }

    protected FileLogHeader(RandomAccessFile logFile) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "<init>", "LogFile=" + logFile);
        }
        this.readHeader(logFile);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "<init>");
        }
    }

    private void readHeader(RandomAccessFile logFile) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "readHeader", new Object[]{logFile});
        }
        boolean validHeader = false;
        try {
            logFile.seek(0L);
            byte[] headerBytes = new byte[4096];
            for (int i = 1; i <= 2 && !validHeader; ++i) {
                logFile.readFully(headerBytes);
                validHeader = FileLogInput.restoreSectorBits(headerBytes, headerBytes[5]);
                if (!validHeader) continue;
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(headerBytes);
                DataInputStream inputStream = new DataInputStream(byteArrayInputStream);
                inputStream.skipBytes(1);
                this.instanceVersion = inputStream.readInt();
                this.sectorByte = inputStream.readByte();
                char[] signatureRead = new char[signature.length()];
                for (int ichar = 0; ichar < signature.length(); ++ichar) {
                    signatureRead[ichar] = inputStream.readChar();
                }
                this.startByteAddress = inputStream.readLong();
                this.fileSize = inputStream.readLong();
                this.headerSequence = inputStream.readLong();
                this.headerWriteTime = inputStream.readLong();
                if (!new String(signatureRead).equals(signature)) {
                    if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                        trace.exit((Object)this, cclass, "readheader", new Object[]{signatureRead});
                    }
                    throw new InvalidLogFileSignatureException(this, new String(signatureRead), signature);
                }
                if (!Tracing.isAnyTracingEnabled() || !trace.isDebugEnabled()) continue;
                trace.debug((Object)this, cclass, "readheader", new Object[]{new Integer(this.instanceVersion), new Byte(this.sectorByte), new Long(this.startByteAddress), new Long(this.fileSize), new Long(this.headerSequence), new Date(this.headerWriteTime)});
            }
        }
        catch (EOFException exception) {
            ObjectManager.ffdc.processException(this, cclass, "readHeader", exception, "1:188:1.8");
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "readHeader", exception);
            }
            throw new LogFileExhaustedException((Object)this, exception);
        }
        catch (IOException exception) {
            ObjectManager.ffdc.processException(this, cclass, "readHeader", exception, "1:199:1.8");
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "readHeader", exception);
            }
            throw new PermanentIOException((Object)this, exception);
        }
        if (!validHeader) {
            LogFileHeaderCorruptException logFileHeaderCorruptException = new LogFileHeaderCorruptException(this);
            ObjectManager.ffdc.processException(this, cclass, "readHeader", logFileHeaderCorruptException, "1:212:1.8");
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, cclass, "readHeader");
            }
            throw logFileHeaderCorruptException;
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "readHeader");
        }
    }

    protected long writeHeader(RandomAccessFile logFile) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "writeHeader", new Object[]{logFile, new Integer(this.instanceVersion), new Byte(this.sectorByte), new Long(this.startByteAddress), new Long(this.fileSize)});
        }
        ObjectManagerByteArrayOutputStream logHeaderStream = new ObjectManagerByteArrayOutputStream(4096);
        DataOutputStream logHeader = new DataOutputStream(logHeaderStream);
        try {
            logHeader.writeByte(0);
            logHeader.writeInt(this.instanceVersion);
            logHeader.writeByte(this.sectorByte);
            logHeader.writeChars(signature);
            logHeader.writeLong(this.startByteAddress);
            logHeader.writeLong(this.fileSize);
            logHeader.writeLong(++this.headerSequence);
            this.headerWriteTime = System.currentTimeMillis();
            logHeader.writeLong(this.headerWriteTime);
        }
        catch (IOException exception) {
            ObjectManager.ffdc.processException(this, cclass, "writeHeader", exception, "1:265:1.8");
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "writeHeader", exception);
            }
            throw new PermanentIOException((Object)this, exception);
        }
        long filePosition = 0L;
        byte[] headerBuffer = logHeaderStream.getBuffer();
        FileLogOutput.setSectorBits(headerBuffer, 0, this.sectorByte);
        try {
            logFile.seek(0L);
            for (int i = 0; i < 2; ++i) {
                logFile.write(headerBuffer, 0, 4096);
                filePosition += 4096L;
            }
        }
        catch (IOException exception) {
            ObjectManager.ffdc.processException(this, cclass, "writeHeader", exception, "1:298:1.8");
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "writeHeader", exception);
            }
            throw new PermanentIOException((Object)this, exception);
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "writeHeader", new Object[]{new Long(filePosition), new Long(this.headerSequence), new Date(this.headerWriteTime)});
        }
        return filePosition;
    }
}

