/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ras.instrument.internal.bci;

import com.ibm.ws.ras.instrument.internal.bci.AbstractRasMethodAdapter;
import com.ibm.ws.ras.instrument.internal.bci.AbstractTracingRasClassAdapter;
import com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingClassAdapter;
import com.ibm.ws.ras.instrument.internal.model.TraceOptionsData;
import java.util.List;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class WebSphereTrTracingMethodAdapter
extends AbstractRasMethodAdapter<AbstractTracingRasClassAdapter> {
    public WebSphereTrTracingMethodAdapter(AbstractTracingRasClassAdapter classAdapter, MethodVisitor visitor, int access, String methodName, String descriptor, String signature, String[] exceptions) {
        super(classAdapter, true, visitor, access, methodName, descriptor, signature, exceptions);
    }

    @Override
    public boolean onMethodEntry() {
        if (this.isTrivial() || this.isAlreadyTraced()) {
            return false;
        }
        if (this.isStaticInitializer()) {
            return false;
        }
        Label skipTraceLabel = new Label();
        this.visitInvokeTraceGuardMethod("isEntryEnabled", skipTraceLabel);
        this.visitGetTraceObjectField();
        this.visitLoadMethodName();
        this.createTraceArrayForParameters();
        this.visitMethodInsn(184, WebSphereTrTracingClassAdapter.TR_TYPE.getInternalName(), "entry", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{WebSphereTrTracingClassAdapter.TRACE_COMPONENT_TYPE, Type.getType(String.class), Type.getType(Object.class)}), false);
        this.visitLabel(skipTraceLabel);
        return true;
    }

    @Override
    public boolean onMethodReturn() {
        if (this.isTrivial() || this.isAlreadyTraced()) {
            return false;
        }
        if (this.isStaticInitializer()) {
            return false;
        }
        Label skipTraceLabel = new Label();
        this.visitInvokeTraceGuardMethod("isEntryEnabled", skipTraceLabel);
        boolean traceValueOnStack = this.setupReturnObjectValueForExitTrace();
        if (traceValueOnStack) {
            this.visitGetTraceObjectField();
            this.visitInsn(95);
            this.visitLoadMethodName();
            this.visitInsn(95);
            this.visitMethodInsn(184, WebSphereTrTracingClassAdapter.TR_TYPE.getInternalName(), "exit", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{WebSphereTrTracingClassAdapter.TRACE_COMPONENT_TYPE, Type.getType(String.class), Type.getType(Object.class)}), false);
        } else {
            this.visitGetTraceObjectField();
            this.visitLoadMethodName();
            this.visitMethodInsn(184, WebSphereTrTracingClassAdapter.TR_TYPE.getInternalName(), "exit", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{WebSphereTrTracingClassAdapter.TRACE_COMPONENT_TYPE, Type.getType(String.class)}), false);
        }
        this.visitLabel(skipTraceLabel);
        return true;
    }

    @Override
    public boolean onThrowInstruction() {
        if (!((AbstractTracingRasClassAdapter)this.getClassAdapter()).isTraceExceptionOnThrow() || this.isAlreadyTraced()) {
            return false;
        }
        Label skipTraceLabel = new Label();
        this.visitInvokeTraceGuardMethod("isDebugEnabled", skipTraceLabel);
        this.visitInsn(89);
        this.visitGetTraceObjectField();
        this.visitInsn(95);
        this.visitLdcInsn(this.getMethodName() + " is rasing exception");
        this.visitInsn(95);
        this.visitMethodInsn(184, WebSphereTrTracingClassAdapter.TR_TYPE.getInternalName(), "debug", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{WebSphereTrTracingClassAdapter.TRACE_COMPONENT_TYPE, Type.getType(String.class), Type.getType(Object.class)}), false);
        this.visitLabel(skipTraceLabel);
        return true;
    }

    @Override
    public boolean onExceptionHandlerEntry(Type exception, int var) {
        if (!((AbstractTracingRasClassAdapter)this.getClassAdapter()).isTraceExceptionOnHandling() || this.isAlreadyTraced()) {
            return false;
        }
        Label skipTraceLabel = new Label();
        this.visitInvokeTraceGuardMethod("isDebugEnabled", skipTraceLabel);
        if (var == -1) {
            this.visitInsn(89);
        } else {
            this.visitVarInsn(25, var);
        }
        this.visitGetTraceObjectField();
        this.visitInsn(95);
        this.visitLdcInsn(this.getMethodName() + " is handling exception");
        this.visitInsn(95);
        this.visitMethodInsn(184, WebSphereTrTracingClassAdapter.TR_TYPE.getInternalName(), "debug", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{WebSphereTrTracingClassAdapter.TRACE_COMPONENT_TYPE, Type.getType(String.class), Type.getType(Object.class)}), false);
        this.visitLabel(skipTraceLabel);
        return true;
    }

    @Override
    public void initializeTraceObjectField() {
        String traceGroupName;
        if (!((AbstractTracingRasClassAdapter)this.getClassAdapter()).isTraceObjectFieldInitializationRequired() || this.isAlreadyTraced()) {
            return;
        }
        TraceOptionsData traceOptionsData = ((AbstractTracingRasClassAdapter)this.getClassAdapter()).getTraceOptionsData();
        if (traceOptionsData == null) {
            return;
        }
        this.visitGetClassForType(Type.getObjectType((String)((AbstractTracingRasClassAdapter)this.getClassAdapter()).getClassInternalName()));
        List<String> traceGroups = traceOptionsData.getTraceGroups();
        String string = traceGroupName = traceGroups.isEmpty() ? null : traceGroups.get(0);
        if (traceGroupName != null) {
            this.visitLdcInsn(traceGroupName);
        } else {
            this.visitInsn(1);
        }
        String messageBundle = traceOptionsData.getMessageBundle();
        if (messageBundle != null) {
            this.visitLdcInsn(messageBundle);
        } else {
            this.visitInsn(1);
        }
        this.visitMethodInsn(184, WebSphereTrTracingClassAdapter.TR_TYPE.getInternalName(), "register", Type.getMethodDescriptor((Type)WebSphereTrTracingClassAdapter.TRACE_COMPONENT_TYPE, (Type[])new Type[]{Type.getType(Class.class), Type.getType(String.class), Type.getType(String.class)}), false);
        this.visitSetTraceObjectField();
    }

    private void visitInvokeTraceGuardMethod(String guardMethodName, Label skipTraceLabel) {
        this.visitMethodInsn(184, WebSphereTrTracingClassAdapter.TRACE_COMPONENT_TYPE.getInternalName(), "isAnyTracingEnabled", "()Z", false);
        this.visitJumpInsn(153, skipTraceLabel);
        this.visitGetTraceObjectField();
        this.visitJumpInsn(198, skipTraceLabel);
        this.visitGetTraceObjectField();
        this.visitMethodInsn(182, WebSphereTrTracingClassAdapter.TRACE_COMPONENT_TYPE.getInternalName(), guardMethodName, "()Z", false);
        this.visitJumpInsn(153, skipTraceLabel);
    }
}

