/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.gd.statestream;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.processor.exceptions.SIMPErrorException;
import com.ibm.ws.sib.processor.gd.statestream.TickData;
import com.ibm.ws.sib.processor.gd.statestream.TickRange;
import com.ibm.ws.sib.processor.gd.statestream.TickRangeObjectPool;
import com.ibm.ws.sib.processor.gd.statestream.TickRangeType;
import com.ibm.ws.sib.processor.utils.linkedlist2.LinkedList;
import com.ibm.ws.sib.utils.ras.SibTr;

public class LinkedRangeList
extends LinkedList {
    private TickRangeObjectPool tickRangePool;
    private static TraceComponent tc = SibTr.register(LinkedRangeList.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private TickRange cursor;
    private boolean error = false;

    public LinkedRangeList() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"LinkedRangeList");
        }
        this.tickRangePool = new TickRangeObjectPool("TickRangePool", 20);
        TickRange tr = this.getNewTickRange(TickRangeType.COMPLETED, 0L, 0L);
        this.put(tr);
        tr = this.getNewTickRange(TickRangeType.UNKNOWN, 1L, Long.MAX_VALUE);
        this.put(tr);
        this.cursor = tr;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"LinkedRangeList", (Object)this);
        }
    }

    protected TickRange getNewTickRange(TickRangeType type, long start, long end) {
        return this.tickRangePool.getNewTickRange(type, start, end);
    }

    protected TickRange getNewTickRange(TickRangeType type, long start, long end, TickData data) {
        return this.tickRangePool.getNewTickRange(type, start, end, data);
    }

    protected void returnTickRange(TickRange tr) {
    }

    protected TickRange cloneTickRange(TickRange old) {
        return this.getNewTickRange(old.type, old.start, old.end, old.data);
    }

    public boolean isInError() {
        return this.error;
    }

    protected void error() {
    }

    protected boolean setRange(TickRange tr) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setRange", (Object)new Object[]{tr});
        }
        boolean changed = this.setRange(tr, true);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setRange", (Object)new Boolean(changed));
        }
        return changed;
    }

    protected boolean setRange(TickRange tr, boolean errorCheck) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setRange", (Object)new Object[]{tr, new Boolean(errorCheck)});
        }
        boolean changed = false;
        if (tr.isInUse() || this.error) {
            SIMPErrorException e = new SIMPErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"com.ibm.ws.sib.processor.gd.statestream.LinkedRangeList", "1:136:1.7", this}, null));
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.gd.statestream.LinkedRangeList.setRange", (String)"1:143:1.7", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)e);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"setRange");
            }
            throw e;
        }
        changed = this.setRange(tr, errorCheck, true);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setRange", (Object)new Boolean(changed));
        }
        return changed;
    }

    private boolean setRange(TickRange tr, boolean errorCheck, boolean consolidateCompleted) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setRange", (Object)new Object[]{tr, new Boolean(errorCheck), new Boolean(consolidateCompleted)});
        }
        boolean changed = false;
        TickRange insertPoint = this.findRange(tr.start);
        if (insertPoint != null) {
            boolean midEnd;
            TickRangeType state = TickRangeType.stateTransition(tr.type, insertPoint.type);
            if (errorCheck && state == TickRangeType.ERROR) {
                this.error = true;
                SIMPErrorException e = new SIMPErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"com.ibm.ws.sib.processor.gd.statestream.LinkedRangeList", "1:186:1.7", this}, null));
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.gd.statestream.LinkedRangeList.setRange", (String)"1:193:1.7", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.exception((TraceComponent)tc, (Exception)e);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"setRange");
                }
                throw e;
            }
            if (consolidateCompleted && tr.type == TickRangeType.COMPLETED && tr.type == insertPoint.type) {
                if (insertPoint.end < Long.MAX_VALUE) {
                    tr.start = insertPoint.end + 1L;
                    if (tr.start <= tr.end) {
                        boolean bl = changed = this.setRange(tr, errorCheck) || changed;
                    }
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"setRange", (Object)new Boolean(changed));
                }
                return changed;
            }
            boolean midStart = tr.start > insertPoint.start;
            boolean bl = midEnd = tr.end <= insertPoint.end;
            if (midStart) {
                if (midEnd) {
                    if (tr.end == insertPoint.end) {
                        changed = true;
                        insertPoint.end = tr.start - 1L;
                        TickRange insertBefore = (TickRange)insertPoint.getNext();
                        if (insertBefore != null && consolidateCompleted && tr.type == TickRangeType.COMPLETED && tr.type == insertBefore.type) {
                            insertBefore.start = tr.start;
                        } else {
                            this.insertAfter(tr, insertPoint);
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"setRange", (Object)new Boolean(changed));
                        }
                        return changed;
                    }
                    TickRange tempInsert = this.cloneTickRange(insertPoint);
                    tempInsert.start = tr.start;
                    changed = this.setRange(tempInsert, false, false);
                    changed = this.setRange(tr, false) || changed;
                } else {
                    TickRange insertBefore = (TickRange)insertPoint.getNext();
                    changed = this.processRanges(tr, insertPoint, insertBefore, consolidateCompleted);
                }
            } else {
                TickRange insertBefore = insertPoint;
                insertPoint = (TickRange)insertPoint.getPrevious();
                changed = this.processRanges(tr, insertPoint, insertBefore, consolidateCompleted);
            }
        } else {
            this.error = true;
            SIMPErrorException e = new SIMPErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"com.ibm.ws.sib.processor.gd.statestream.LinkedRangeList", "1:301:1.7", this}, null));
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.gd.statestream.LinkedRangeList.setRange", (String)"1:308:1.7", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)e);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"setRange");
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setRange", (Object)new Boolean(changed));
        }
        return changed;
    }

    private boolean processRanges(TickRange tr, TickRange insertAfter, TickRange insertBefore, boolean consolidateCompleted) {
        TickRangeType state;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processRanges", (Object)new Object[]{tr, insertAfter, insertBefore, new Boolean(consolidateCompleted)});
        }
        boolean changed = false;
        while (insertBefore != null && tr.end >= insertBefore.end) {
            this.error = true;
            state = TickRangeType.stateTransition(tr.type, insertBefore.type);
            if (state == TickRangeType.ERROR) {
                this.error = true;
                SIMPErrorException e = new SIMPErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"com.ibm.ws.sib.processor.gd.statestream.LinkedRangeList", "1:364:1.7", this}, null));
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.gd.statestream.LinkedRangeList.processRanges", (String)"1:371:1.7", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.exception((TraceComponent)tc, (Exception)e);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"processRanges");
                }
                throw e;
            }
            insertBefore = this.removeRange(insertBefore);
        }
        if (insertBefore != null) {
            changed = true;
            if (tr.end >= insertBefore.start) {
                state = TickRangeType.stateTransition(tr.type, insertBefore.type);
                if (state == TickRangeType.ERROR) {
                    this.error = true;
                    SIMPErrorException e = new SIMPErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"com.ibm.ws.sib.processor.gd.statestream.LinkedRangeList", "1:404:1.7", this}, null));
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.gd.statestream.LinkedRangeList.processRanges", (String)"1:411:1.7", (Object)this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.exception((TraceComponent)tc, (Exception)e);
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"processRanges");
                    }
                    throw e;
                }
                insertBefore.start = tr.end + 1L;
            }
            if (consolidateCompleted) {
                boolean postConsolidation;
                boolean preConsolidation = tr.type == TickRangeType.COMPLETED && tr.type == insertAfter.type;
                boolean bl = postConsolidation = tr.type == TickRangeType.COMPLETED && tr.type == insertBefore.type;
                if (preConsolidation) {
                    if (postConsolidation) {
                        this.removeRange(insertBefore);
                        insertAfter.end = insertBefore.end;
                    } else {
                        insertAfter.end = tr.end;
                    }
                } else {
                    insertAfter.end = tr.start - 1L;
                    if (postConsolidation) {
                        insertBefore.start = tr.start;
                    } else {
                        this.insertAfter(tr, insertAfter);
                    }
                }
            } else {
                insertAfter.end = tr.start - 1L;
                this.insertAfter(tr, insertAfter);
            }
        } else {
            tr.end = Long.MAX_VALUE;
            this.insertAfter(tr, insertAfter);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processRanges", (Object)new Boolean(changed));
        }
        return changed;
    }

    private TickRange removeRange(TickRange range) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeRange", (Object)new Object[]{range});
        }
        if (this.cursor == range) {
            this.cursor = range == this.last ? (TickRange)this.cursor.getPrevious() : (TickRange)this.cursor.getNext();
        }
        TickRange next = (TickRange)range.getNext();
        this.remove(range);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeRange", (Object)next);
        }
        return next;
    }

    protected TickRange findRange(long tick) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"findRange", (Object)new Object[]{new Long(tick)});
        }
        TickRange found = null;
        long diff = this.cursor.diff(tick);
        while (diff != 0L) {
            if (diff > 0L) {
                if (this.cursor.end == Long.MAX_VALUE) break;
                this.cursor = (TickRange)this.cursor.getNext();
            } else {
                if (this.cursor.start == 0L) break;
                this.cursor = (TickRange)this.cursor.getPrevious();
            }
            diff = this.cursor.diff(tick);
        }
        if (diff == 0L) {
            found = this.cursor;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"findRange", (Object)found);
        }
        return found;
    }

    protected void setCursor(TickRange range) {
        this.cursor = range;
    }

    protected TickRange moveCursorToStart() {
        this.cursor = (TickRange)this.getFirst();
        return this.cursor;
    }

    protected TickRange moveCursorToEnd() {
        this.cursor = (TickRange)this.getLast();
        return this.cursor;
    }

    protected TickRange getCursor() {
        return this.cursor;
    }

    protected TickRange next() {
        TickRange next = null;
        this.cursor = (TickRange)this.cursor.getNext();
        if (this.cursor == null) {
            this.cursor = (TickRange)this.last;
        } else {
            next = this.cursor;
        }
        return next;
    }

    protected TickRange previous() {
        TickRange prev = null;
        this.cursor = (TickRange)this.cursor.getPrevious();
        if (this.cursor == null) {
            this.cursor = (TickRange)this.first;
        } else {
            prev = this.cursor;
        }
        return prev;
    }

    protected long getCompletedPrefix() {
        return ((TickRange)this.getFirst()).end;
    }

    public boolean containsState(TickRangeType state, long start, long end) {
        boolean found;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"containsState", (Object)new Object[]{state, new Long(start), new Long(end)});
        }
        TickRange curr = this.findRange(start);
        boolean bl = found = curr.type == state;
        while (!found && end > curr.end) {
            curr = (TickRange)curr.getNext();
            found = curr.type == state;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"containsState", (Object)new Boolean(found));
        }
        return found;
    }
}

