/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.rmi.impl;

import java.io.IOException;
import java.io.Serializable;
import java.rmi.Remote;
import java.util.Map;
import javax.rmi.CORBA.Util;
import javax.rmi.PortableRemoteObject;
import org.apache.yoko.rmi.impl.ObjectReaderBase;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.IndirectionException;
import org.omg.CORBA.portable.ValueInputStream;
import org.omg.CORBA_2_3.portable.InputStream;

public final class CorbaObjectReader
extends ObjectReaderBase {
    final InputStream in;
    private final Map<Integer, Serializable> offsetMap;

    CorbaObjectReader(org.omg.CORBA.portable.InputStream in, Map<Integer, Serializable> offsetMap, Serializable obj) throws IOException {
        super(obj);
        this.in = (InputStream)in;
        this.offsetMap = offsetMap;
    }

    @Override
    public void readFully(byte[] arr, int off, int val) {
        this.in.read_octet_array(arr, off, val);
    }

    @Override
    public int skipBytes(int len) {
        byte[] data = new byte[len];
        this.readFully(data, 0, len);
        return len;
    }

    @Override
    public boolean readBoolean() {
        return this.in.read_boolean();
    }

    @Override
    public byte readByte() {
        return this.in.read_octet();
    }

    @Override
    public int readUnsignedByte() {
        byte val = this.in.read_octet();
        return val & 0xFF;
    }

    @Override
    public short readShort() {
        return this.in.read_short();
    }

    @Override
    public int readUnsignedShort() {
        short val = this.in.read_short();
        return val & 0xFFFF;
    }

    @Override
    public char readChar() {
        return this.in.read_wchar();
    }

    @Override
    public int readInt() {
        return this.in.read_long();
    }

    @Override
    public long readLong() {
        return this.in.read_longlong();
    }

    @Override
    public float readFloat() {
        return this.in.read_float();
    }

    @Override
    public double readDouble() {
        return this.in.read_double();
    }

    @Override
    @Deprecated
    public String readLine() {
        char ch;
        StringBuilder buf = new StringBuilder();
        try {
            ch = (char)this.readUnsignedByte();
        }
        catch (MARSHAL ex) {
            return null;
        }
        while (true) {
            char ch2;
            buf.append(ch);
            try {
                ch = (char)this.readUnsignedByte();
            }
            catch (MARSHAL ex) {
                return buf.toString();
            }
            if (ch == '\n') {
                return buf.toString();
            }
            if (ch != '\r') continue;
            try {
                ch2 = (char)this.readUnsignedByte();
            }
            catch (MARSHAL ex) {
                return buf.toString();
            }
            if (ch2 == '\n') {
                return buf.toString();
            }
            ch = ch2;
        }
    }

    @Override
    public String readUTF() {
        return this.in.read_wstring();
    }

    @Override
    public java.lang.Object readAbstractObject() {
        try {
            return this.in.read_abstract_interface();
        }
        catch (IndirectionException ex) {
            return this.offsetMap.get(ex.offset);
        }
    }

    @Override
    public java.lang.Object readAny() {
        try {
            return Util.readAny((org.omg.CORBA.portable.InputStream)this.in);
        }
        catch (IndirectionException ex) {
            return this.offsetMap.get(ex.offset);
        }
    }

    @Override
    public java.lang.Object readValueObject() {
        try {
            return this.in.read_value();
        }
        catch (IndirectionException ex) {
            return this.offsetMap.get(ex.offset);
        }
    }

    @Override
    public java.lang.Object readValueObject(Class<?> clz) {
        try {
            return this.in.read_value(clz);
        }
        catch (IndirectionException ex) {
            return this.offsetMap.get(ex.offset);
        }
    }

    @Override
    public Object readCorbaObject(Class<?> type) {
        return this.in.read_Object();
    }

    @Override
    public Remote readRemoteObject(Class<?> type) {
        Object objref = this.in.read_Object();
        return (Remote)PortableRemoteObject.narrow((java.lang.Object)objref, type);
    }

    @Override
    public int read() {
        return this.readUnsignedByte();
    }

    @Override
    public int read(byte[] arr) {
        return this.read(arr, 0, arr.length);
    }

    @Override
    public int read(byte[] arr, int off, int len) {
        this.readFully(arr, off, len);
        return len;
    }

    @Override
    public long skip(long len) {
        this.skipBytes((int)len);
        return len;
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    protected void _startValue() {
        ((ValueInputStream)this.in).start_value();
    }

    @Override
    protected void _endValue() {
        ((ValueInputStream)this.in).end_value();
    }
}

