/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.netty.internal.impl;

import com.ibm.websphere.channelfw.EndPointMgr;
import com.ibm.websphere.channelfw.osgi.CHFWBundle;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.channelfw.internal.chains.EndPointMgrImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.kernel.feature.ServerStarted;
import com.ibm.ws.kernel.productinfo.ProductInfo;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.ServerQuiesceListener;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.openliberty.netty.internal.BootstrapConfiguration;
import io.openliberty.netty.internal.BootstrapExtended;
import io.openliberty.netty.internal.NettyFramework;
import io.openliberty.netty.internal.ServerBootstrapExtended;
import io.openliberty.netty.internal.exception.NettyException;
import io.openliberty.netty.internal.impl.NettyQuiesceListener;
import io.openliberty.netty.internal.impl.QuiesceHandler;
import io.openliberty.netty.internal.impl.QuiesceState;
import io.openliberty.netty.internal.tcp.TCPConfigurationImpl;
import io.openliberty.netty.internal.tcp.TCPUtils;
import io.openliberty.netty.internal.udp.UDPUtils;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(configurationPid={"io.openliberty.netty.internal"}, immediate=true, service={NettyFramework.class, ServerQuiesceListener.class}, property={"service.vendor=IBM"})
public class NettyFrameworkImpl
implements ServerQuiesceListener,
NettyFramework {
    private static final TraceComponent tc = Tr.register(NettyFrameworkImpl.class, (String)"Netty", (String)"com.ibm.ws.channelfw.internal.resources.ChannelfwMessages");
    private ExecutorService executorService = null;
    private static AtomicBoolean serverCompletelyStarted = new AtomicBoolean(false);
    private static Queue<FutureTask<ChannelFuture>> serverStartedTasks = new LinkedBlockingQueue<FutureTask<ChannelFuture>>();
    private static Object syncStarted = new Object(){
        static final long serialVersionUID = -8867004694885759496L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.netty.internal.impl.NettyFrameworkImpl$1", 1.class, null, null);
        }
    };
    private Map<Channel, ChannelGroup> activeChannelMap = new ConcurrentHashMap<Channel, ChannelGroup>();
    private ChannelGroup outboundConnections = new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE);
    private EventLoopGroup parentGroup;
    private EventLoopGroup childGroup;
    private CHFWBundle chfw;
    private volatile boolean isActive = false;
    private ScheduledExecutorService scheduledExecutorService = null;
    private static final String EVENTLOOP_THREADS_PROPERTY = "io.openliberty.netty.eventloop.threads";
    static final long serialVersionUID = -6278213817043655939L;

    @Activate
    protected void activate(ComponentContext context, Map<String, Object> config) {
        int threadNumber;
        if (!ProductInfo.getBetaEdition()) {
            return;
        }
        this.parentGroup = new NioEventLoopGroup(1);
        String eventloopThreadNumberProperty = System.getSecurityManager() == null ? System.getProperty(EVENTLOOP_THREADS_PROPERTY, "0") : AccessController.doPrivileged(new PrivilegedAction<String>(){
            static final long serialVersionUID = -6799061652304813007L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public String run() {
                return System.getProperty(NettyFrameworkImpl.EVENTLOOP_THREADS_PROPERTY, "0");
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"io.openliberty.netty.internal.impl.NettyFrameworkImpl$2", 2.class, null, null);
            }
        });
        try {
            threadNumber = Integer.parseInt(eventloopThreadNumberProperty);
        }
        catch (NumberFormatException numberFormatException) {
            FFDCFilter.processException((Throwable)numberFormatException, (String)"io.openliberty.netty.internal.impl.NettyFrameworkImpl", (String)"131", (Object)this, (Object[])new Object[]{context, config});
            threadNumber = 0;
        }
        if (threadNumber < 0) {
            threadNumber = 0;
        }
        this.childGroup = new NioEventLoopGroup(threadNumber);
    }

    @Deactivate
    protected void deactivate(ComponentContext context, Map<String, Object> properties) {
        if (!ProductInfo.getBetaEdition()) {
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)"Deactivate called", (Object[])new Object[]{context, properties});
        }
        EndPointMgrImpl.destroyEndpoints();
        this.stopEventLoops();
    }

    @Modified
    protected void modified(ComponentContext context, Map<String, Object> config) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)"Processing config", (Object[])new Object[]{config});
        }
    }

    @Reference(name="chfwBundle")
    protected void setChfwBundle(CHFWBundle bundle) {
        this.chfw = bundle;
    }

    protected void unsetChfwBundle(CHFWBundle bundle) {
    }

    @Reference(service=ExecutorService.class, cardinality=ReferenceCardinality.MANDATORY)
    protected void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    protected void unsetExecutorService(ExecutorService executorService) {
        this.executorService = null;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Reference(service=ScheduledExecutorService.class, cardinality=ReferenceCardinality.MANDATORY)
    protected void setScheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
        this.scheduledExecutorService = scheduledExecutorService;
    }

    protected void unsetScheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
        this.scheduledExecutorService = null;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean isStopping() {
        return NettyFrameworkImpl.isServerCompletelyStarted() && !this.isActive();
    }

    /*
     * WARNING - void declaration
     */
    public void serverStopping() {
        block9: {
            if (!ProductInfo.getBetaEdition()) {
                return;
            }
            QuiesceState.startQuiesce();
            if (this.isActive) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((Object)this, (TraceComponent)tc, (String)("Destroying all endpoints (closing all channels): " + this.activeChannelMap.keySet()), (Object[])new Object[0]);
                }
                this.isActive = false;
                long timeout = this.getDefaultChainQuiesceTimeout();
                if (timeout > 0L) {
                    if (this.activeChannelMap.isEmpty() && this.outboundConnections.isEmpty()) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"No connections to clean up, skipping quiesce creation.", (Object[])new Object[0]);
                        }
                        return;
                    }
                    NettyQuiesceListener quiesce = new NettyQuiesceListener(this, this.scheduledExecutorService, timeout);
                    try {
                        for (Channel channel : this.activeChannelMap.keySet()) {
                            channel.pipeline().fireUserEventTriggered((Object)QuiesceHandler.QUIESCE_EVENT);
                        }
                        quiesce.startTasks();
                    }
                    catch (Exception exception) {
                        void e;
                        FFDCFilter.processException((Throwable)exception, (String)"io.openliberty.netty.internal.impl.NettyFrameworkImpl", (String)"284", (Object)this, (Object[])new Object[0]);
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block9;
                        Tr.event((Object)this, (TraceComponent)tc, (String)"Exception occurred on quiesce", (Object[])new Object[]{e});
                    }
                }
            }
        }
    }

    private void stopEventLoops() {
        Future parent = null;
        Future child = null;
        Future global = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Gracefully shutting down parentGroup Event Loop " + this.parentGroup), (Object[])new Object[0]);
        }
        if (this.parentGroup != null) {
            parent = this.parentGroup.shutdownGracefully();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Gracefully shutting down childGroup Event Loop " + this.childGroup), (Object[])new Object[0]);
        }
        if (this.childGroup != null) {
            child = this.childGroup.shutdownGracefully();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Gracefully shutting down GlobalEventExecutor " + GlobalEventExecutor.INSTANCE), (Object[])new Object[0]);
        }
        global = GlobalEventExecutor.INSTANCE.shutdownGracefully();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Waiting for parentGroup Event Loop shutdown...", (Object[])new Object[0]);
        }
        if (parent != null) {
            parent.awaitUninterruptibly();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Waiting for childGroup Event Loop shutdown...", (Object[])new Object[0]);
        }
        if (child != null) {
            child.awaitUninterruptibly();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Waiting for GlobalEventExecutor shutdown...", (Object[])new Object[0]);
        }
        if (global != null) {
            global.awaitUninterruptibly();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Event loops finished clean up!", (Object[])new Object[0]);
        }
        QuiesceState.stopQuiesce();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Reference(service=ServerStarted.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL, policyOption=ReferencePolicyOption.GREEDY)
    protected void setServerStarted(ServiceReference<ServerStarted> ref) {
        if (!ProductInfo.getBetaEdition()) {
            return;
        }
        CountDownLatch latch = new CountDownLatch(serverStartedTasks.size());
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"Netty Framework signaled- Server Completely Started signal received", (Object[])new Object[0]);
        }
        Object object = syncStarted;
        synchronized (object) {
            FutureTask<ChannelFuture> task;
            while ((task = serverStartedTasks.poll()) != null) {
                try {
                    if (!task.isCancelled()) {
                        this.executorService.submit(new StartTaskRunnable(task, latch));
                        continue;
                    }
                    latch.countDown();
                }
                catch (Exception exception) {
                    void e;
                    FFDCFilter.processException((Throwable)exception, (String)"io.openliberty.netty.internal.impl.NettyFrameworkImpl", (String)"373", (Object)this, (Object[])new Object[]{ref});
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("caught exception performing late cycle server startup task: " + e), (Object[])new Object[0]);
                }
            }
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                FFDCFilter.processException((Throwable)e, (String)"io.openliberty.netty.internal.impl.NettyFrameworkImpl", (String)"382", (Object)this, (Object[])new Object[]{ref});
                throw new RuntimeException(e);
            }
            serverCompletelyStarted.set(true);
            this.isActive = true;
            syncStarted.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FutureTask<ChannelFuture> runWhenServerStarted(Callable<ChannelFuture> callable) throws Exception {
        if (!ProductInfo.getBetaEdition()) {
            FutureTask<ChannelFuture> future = new FutureTask<ChannelFuture>(callable);
            future.cancel(false);
            return future;
        }
        Object object = syncStarted;
        synchronized (object) {
            FutureTask<ChannelFuture> future = new FutureTask<ChannelFuture>(callable);
            if (!serverCompletelyStarted.get()) {
                serverStartedTasks.add(future);
            } else {
                this.executorService.submit(future);
            }
            return future;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FFDCIgnore(value={InterruptedException.class})
    public static void waitServerCompletelyStarted() {
        Object object = syncStarted;
        synchronized (object) {
            if (!serverCompletelyStarted.get()) {
                try {
                    syncStarted.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public static boolean isServerCompletelyStarted() {
        return serverCompletelyStarted.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerEndpointQuiesce(Channel chan, Callable quiesce) {
        Map<Channel, ChannelGroup> map = this.activeChannelMap;
        synchronized (map) {
            if (chan != null && this.getActiveChannelsMap().containsKey(chan)) {
                ChannelHandler quiesceHandler = chan.pipeline().get(QuiesceHandler.class);
                if (quiesceHandler != null) {
                    ((QuiesceHandler)quiesceHandler).setQuiesceTask(quiesce);
                } else {
                    chan.pipeline().addFirst(new ChannelHandler[]{new QuiesceHandler(quiesce)});
                }
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isWarningEnabled()) {
                Tr.warning((TraceComponent)tc, (String)"Attempted to add a Quiesce Task to a channel which is not an endpoint. Quiesce will not be added and will be ignored.", (Object[])new Object[0]);
            }
        }
    }

    protected synchronized void unsetServerStarted(ServiceReference<ServerStarted> ref) {
        serverCompletelyStarted.set(false);
    }

    @FFDCIgnore(value={NettyException.class})
    public ServerBootstrapExtended createTCPBootstrapInbound(Map<String, Object> tcpOptions) throws NettyException {
        try {
            return TCPUtils.createTCPBootstrapInbound(this, tcpOptions);
        }
        catch (NettyException e) {
            Tr.error((TraceComponent)tc, (String)"chain.initialization.error", (Object[])new Object[]{tcpOptions.get("ExternalName"), e.toString()});
            throw e;
        }
    }

    public BootstrapExtended createTCPBootstrapOutbound(Map<String, Object> tcpOptions) throws NettyException {
        return TCPUtils.createTCPBootstrapOutbound(this, tcpOptions);
    }

    public BootstrapExtended createUDPBootstrapInbound(Map<String, Object> options) throws NettyException {
        return UDPUtils.createUDPBootstrapInbound(this, options);
    }

    public BootstrapExtended createUDPBootstrapOutbound(Map<String, Object> options) throws NettyException {
        return UDPUtils.createUDPBootstrapOutbound(this, options);
    }

    @FFDCIgnore(value={NettyException.class})
    public Channel startInbound(ServerBootstrapExtended bootstrap, String inetHost, int inetPort, ChannelFutureListener bindListener) throws NettyException {
        BootstrapConfiguration config = bootstrap.getConfiguration();
        String externalName = "NOT_DEFINED";
        if (config != null && config instanceof TCPConfigurationImpl) {
            externalName = ((TCPConfigurationImpl)config).getExternalName();
        }
        try {
            return TCPUtils.startInbound(this, bootstrap, inetHost, inetPort, bindListener);
        }
        catch (NettyException e) {
            Tr.error((TraceComponent)tc, (String)"chain.initialization.error", (Object[])new Object[]{externalName, e.toString()});
            throw e;
        }
    }

    public Channel startInbound(BootstrapExtended bootstrap, String inetHost, int inetPort, ChannelFutureListener bindListener) throws NettyException {
        return UDPUtils.startInbound(this, bootstrap, inetHost, inetPort, bindListener);
    }

    public Channel startOutbound(BootstrapExtended bootstrap, String inetHost, int inetPort, ChannelFutureListener bindListener) throws NettyException {
        if (bootstrap.getConfiguration() instanceof TCPConfigurationImpl) {
            return TCPUtils.startOutbound(this, bootstrap, inetHost, inetPort, bindListener);
        }
        return UDPUtils.startOutbound(this, bootstrap, inetHost, inetPort, bindListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelFuture stop(Channel channel) {
        Map<Channel, ChannelGroup> map = this.activeChannelMap;
        synchronized (map) {
            ChannelFuture closeFuture = channel.close();
            ChannelGroup group = this.activeChannelMap.get(channel);
            if (group != null) {
                if (!QuiesceState.isQuiesceInProgress()) {
                    group.close().addListener(innerFuture -> {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("channel group" + group + " has closed..."), (Object[])new Object[0]);
                        }
                    });
                }
                this.activeChannelMap.remove(channel);
            }
            return closeFuture;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(Channel channel, long timeout) {
        ChannelFuture future;
        if (timeout == -1L) {
            timeout = this.getDefaultChainQuiesceTimeout();
        }
        Map<Channel, ChannelGroup> map = this.activeChannelMap;
        synchronized (map) {
            future = this.stop(channel);
        }
        if (future != null) {
            future.awaitUninterruptibly(timeout, TimeUnit.MILLISECONDS);
        }
    }

    public Set<Channel> getActiveChannels() {
        return this.activeChannelMap.keySet();
    }

    public Map<Channel, ChannelGroup> getActiveChannelsMap() {
        return this.activeChannelMap;
    }

    public ChannelGroup getOutboundConnections() {
        return this.outboundConnections;
    }

    public long getDefaultChainQuiesceTimeout() {
        if (this.chfw != null) {
            return this.chfw.getFramework().getDefaultChainQuiesceTimeout();
        }
        return 0L;
    }

    public void destroy() {
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("NettyFrameworkImpl@").append(Integer.toHexString(System.identityHashCode(this)));
        buf.append(": {");
        buf.append("Parent Group: ");
        buf.append(this.getParentGroup());
        if (this.getParentGroup() != null) {
            buf.append(" isShuttingDown? ");
            buf.append(this.getParentGroup().isShuttingDown());
            buf.append(" isShutDown? ");
            buf.append(this.getParentGroup().isShutdown());
            buf.append(" isTerminated? ");
            buf.append(this.getParentGroup().isTerminated());
        }
        buf.append(", Child Group: ");
        buf.append(this.getChildGroup());
        if (this.getChildGroup() != null) {
            buf.append(" isShuttingDown? ");
            buf.append(this.getChildGroup().isShuttingDown());
            buf.append(" isShutDown? ");
            buf.append(this.getChildGroup().isShutdown());
            buf.append(" isTerminated? ");
            buf.append(this.getChildGroup().isTerminated());
        }
        buf.append(", EndpointManager: ");
        buf.append(this.getEndpointManager());
        buf.append(", Default Chain Quiesce Timeout: ");
        buf.append(this.getDefaultChainQuiesceTimeout());
        buf.append(", Outbound Connections: ");
        buf.append(this.getOutboundConnections());
        buf.append(", Active Endpoints: ");
        buf.append(this.getActiveChannels());
        buf.append(", Active endpoint maps: ");
        buf.append(this.getActiveChannelsMap());
        buf.append(", Is Active: ");
        buf.append(this.isActive());
        buf.append(", Is Stopping: ");
        buf.append(this.isStopping());
        buf.append("}");
        return buf.toString();
    }

    public EventLoopGroup getParentGroup() {
        return this.parentGroup;
    }

    public EventLoopGroup getChildGroup() {
        return this.childGroup;
    }

    private void logChannelStopped(Channel channel) {
        if (channel instanceof NioServerSocketChannel || channel instanceof NioSocketChannel) {
            TCPUtils.logChannelStopped(channel);
        } else if (channel instanceof NioDatagramChannel) {
            UDPUtils.logChannelStopped(channel);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("unexpected channel type: " + channel), (Object[])new Object[0]);
        }
    }

    public EndPointMgr getEndpointManager() {
        return EndPointMgrImpl.getRef();
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class StartTaskRunnable
    implements Runnable {
        private FutureTask<ChannelFuture> task;
        private CountDownLatch latch;
        static final long serialVersionUID = 85457024492406885L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public StartTaskRunnable(FutureTask<ChannelFuture> task, CountDownLatch latch) {
            this.task = task;
            this.latch = latch;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void run() {
            block2: {
                this.task.run();
                try {
                    this.task.get(NettyFrameworkImpl.this.getDefaultChainQuiesceTimeout(), TimeUnit.MILLISECONDS);
                }
                catch (Exception exception) {
                    void e;
                    FFDCFilter.processException((Throwable)exception, (String)"io.openliberty.netty.internal.impl.NettyFrameworkImpl$StartTaskRunnable", (String)"407", (Object)this, (Object[])new Object[0]);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block2;
                    Tr.debug((TraceComponent)tc, (String)("caught exception performing startup task: " + e), (Object[])new Object[0]);
                }
            }
            this.latch.countDown();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.netty.internal.impl.NettyFrameworkImpl$StartTaskRunnable", StartTaskRunnable.class, null, null);
        }
    }
}

