/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.jmf.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.MfpConstants;
import com.ibm.ws.sib.mfp.jmf.JMFMessage;
import com.ibm.ws.sib.mfp.jmf.JMFMessageCorruptionException;
import com.ibm.ws.sib.mfp.jmf.JMFRegistry;
import com.ibm.ws.sib.mfp.jmf.JMFSchema;
import com.ibm.ws.sib.mfp.jmf.JMFUninitializedAccessException;
import com.ibm.ws.sib.mfp.jmf.JmfTr;
import com.ibm.ws.sib.mfp.jmf.impl.JSMessageImpl;
import com.ibm.ws.sib.mfp.jmf.impl.JSType;
import com.ibm.ws.sib.mfp.jmf.impl.JSchema;
import com.ibm.ws.sib.mfp.jmf.impl.JSchemaInterpreter;
import com.ibm.ws.sib.mfp.jmf.impl.MessageMap;
import com.ibm.ws.sib.mfp.jmf.impl.MessageMapTable;
import com.ibm.ws.sib.mfp.util.ArrayUtil;
import java.math.BigInteger;

public final class JSchemaInterpreterImpl
implements JSchemaInterpreter {
    private static TraceComponent tc = JmfTr.register(JSchemaInterpreterImpl.class, "SIBJmf", "com.ibm.ws.sib.mfp.CWSIFMessages");

    @Override
    public JMFMessage decode(JSchema schema, byte[] contents, int offset, int length) throws JMFMessageCorruptionException {
        return new JSMessageImpl(schema, contents, offset, length, true);
    }

    @Override
    public long[] checkSchemata(byte[] contents, int offset) throws JMFMessageCorruptionException {
        int numUnknown = 0;
        long[] unknownSchemata = null;
        try {
            int nSchemata = ArrayUtil.readShort(contents, offset);
            if (nSchemata < 0 || offset + 2 + nSchemata * 8 > contents.length) {
                JMFMessageCorruptionException jmce = new JMFMessageCorruptionException("Bad schemata length: " + nSchemata + " at offset " + offset);
                FFDCFilter.processException((Throwable)jmce, (String)"com.ibm.ws.sib.mfp.jmf.impl.JSchemaInterpreterImpl.checkSchemata", (String)"98", (Object)this, (Object[])new Object[]{MfpConstants.DM_BUFFER, contents, 0, contents.length});
                throw jmce;
            }
            offset += 2;
            unknownSchemata = new long[nSchemata];
            for (int i = 0; i < nSchemata; ++i) {
                long schemaId = ArrayUtil.readLong(contents, offset);
                offset += 8;
                JMFSchema schema = JMFRegistry.instance.retrieve(schemaId);
                if (schema != null) continue;
                unknownSchemata[numUnknown] = schemaId;
                ++numUnknown;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.mfp.jmf.impl.JSchemaInterpreterImpl.checkSchemata", (String)"101", (Object)this, (Object[])new Object[]{MfpConstants.DM_BUFFER, contents, 0, contents.length});
            throw new JMFMessageCorruptionException("Attempt to read beyond end of data buffer", e);
        }
        if (numUnknown > 0) {
            long[] result = new long[numUnknown];
            System.arraycopy(unknownSchemata, 0, result, 0, numUnknown);
            return result;
        }
        return new long[0];
    }

    @Override
    public JMFMessage newMessage(JSchema schema) {
        return new JSMessageImpl(schema);
    }

    @Override
    public JMFMessage reEncode(JMFMessage currMessage) {
        return currMessage;
    }

    public static synchronized MessageMap getMessageMap(JSchema sfs, BigInteger code) {
        MessageMap ans;
        MessageMapTable maps = (MessageMapTable)sfs.getInterpreterCache(1);
        if (maps == null) {
            BigInteger count = ((JSType)sfs.getJMFType()).getMultiChoiceCount();
            maps = new MessageMapTable(count);
            sfs.setInterpreterCache(1, maps);
        }
        if ((ans = maps.getMap(code)) == null) {
            ans = new MessageMap(sfs, code);
            maps.set(ans);
        }
        return ans;
    }

    public static MessageMap getMessageMap(JSchema sfs, int[] choices) throws JMFUninitializedAccessException {
        BigInteger multiChoice = MessageMap.getMultiChoice(choices, sfs);
        return JSchemaInterpreterImpl.getMessageMap(sfs, multiChoice);
    }
}

