/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container;

import com.ibm.ejs.container.EJBThreadData;
import com.ibm.ejs.container.EJSContainer;
import com.ibm.tx.jta.embeddable.EmbeddableTransactionManagerFactory;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.LocalTransaction.LocalTransactionCoordinator;
import com.ibm.ws.LocalTransaction.LocalTransactionCurrent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.traceinfo.ejbcontainer.TETxLifeCycleInfo;
import com.ibm.ws.tx.embeddable.EmbeddableWebSphereTransactionManager;
import jakarta.transaction.HeuristicMixedException;
import jakarta.transaction.HeuristicRollbackException;
import jakarta.transaction.NotSupportedException;
import jakarta.transaction.RollbackException;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import jakarta.transaction.UserTransaction;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.rmi.RemoteException;

public class UserTransactionWrapper
implements UserTransaction,
Serializable {
    private static final long serialVersionUID = 8016621367906146400L;
    private static final TraceComponent tc = Tr.register(UserTransactionWrapper.class, (String)"EJBContainer", (String)"com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.container.UserTransactionWrapper";
    public static final UserTransaction INSTANCE = new UserTransactionWrapper();
    private transient EJSContainer container;
    private transient UserTransaction userTransactionImpl;
    private transient EmbeddableWebSphereTransactionManager txCurrent;

    public UserTransactionWrapper() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"<init>", (Object[])new Object[0]);
        }
        this.initialize();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"readObject", (Object[])new Object[0]);
        }
        this.initialize();
    }

    private void initialize() {
        this.container = EJSContainer.getDefaultContainer();
        this.userTransactionImpl = this.container.userTransactionImpl;
        this.txCurrent = EmbeddableTransactionManagerFactory.getTransactionManager();
    }

    public void begin() throws NotSupportedException, SystemException {
        LocalTransactionCurrent ltcCurrent;
        LocalTransactionCoordinator lCoord;
        boolean entryEnabled;
        boolean bl = entryEnabled = TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled();
        if (entryEnabled) {
            Tr.entry((TraceComponent)tc, (String)"UserTransactionWrapper.begin", (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled() && (lCoord = (ltcCurrent = EmbeddableTransactionManagerFactory.getLocalTransactionCurrent()).getLocalTranCoord()) != null) {
            Tr.event((TraceComponent)tc, (String)("Tx Service will complete LTC cntxt: tid=" + Integer.toHexString(lCoord.hashCode()) + "(LTC)"), (Object[])new Object[0]);
        }
        EJBThreadData threadData = EJSContainer.getUserTransactionThreadData();
        this.userTransactionImpl.begin();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled() && this.txCurrent != null) {
            Tr.event((TraceComponent)tc, (String)("User Code began TX cntxt: " + this.txCurrent.getTransaction()), (Object[])new Object[0]);
        }
        try {
            this.container.processTxContextChange(threadData, false);
        }
        catch (RemoteException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.container.UserTransactionWrapper.begin", (String)"145", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"Exception during begin()", (Object)e);
            }
            this.userTransactionImpl.rollback();
            throw new SystemException(e.toString());
        }
        if (entryEnabled) {
            Tr.exit((TraceComponent)tc, (String)"UserTransactionWrapper.begin");
        }
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        boolean entryEnabled;
        boolean bl = entryEnabled = TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled();
        if (entryEnabled) {
            Tr.entry((TraceComponent)tc, (String)"UserTransactionWrapper.commit", (Object[])new Object[0]);
        }
        Transaction transaction = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled() && this.txCurrent != null) {
            transaction = this.txCurrent.getTransaction();
            Tr.event((TraceComponent)tc, (String)("User Code committing TX cntxt: " + transaction), (Object[])new Object[0]);
        }
        String idStr = null;
        if (TraceComponent.isAnyTracingEnabled() && TETxLifeCycleInfo.isTraceEnabled()) {
            idStr = this.txCurrent != null && transaction != null ? transaction.toString() : "NoTxCurrent";
        }
        EJBThreadData threadData = EJSContainer.getUserTransactionThreadData();
        try {
            this.userTransactionImpl.commit();
            if (TraceComponent.isAnyTracingEnabled() && TETxLifeCycleInfo.isTraceEnabled()) {
                int idx;
                idStr = idStr != null ? ((idx = idStr.indexOf("(")) != -1 ? idStr.substring(idx + 1, idStr.indexOf(")")) : ((idx = idStr.indexOf("tid=")) != -1 ? idStr.substring(idx + 4) : idStr)) : "NoTx";
                TETxLifeCycleInfo.traceUserTxCommit(idStr, "User Tx Commit");
            }
            this.changeToLocalContext(threadData);
        }
        catch (RollbackException rbe) {
            block14: {
                FFDCFilter.processException((Throwable)rbe, (String)"com.ibm.ejs.container.UserTransactionWrapper.commit", (String)"285", (Object)this);
                if (TraceComponent.isAnyTracingEnabled()) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"Exception during commit()", (Object)((Object)rbe));
                    }
                    if (TETxLifeCycleInfo.isTraceEnabled()) {
                        int idx;
                        idStr = idStr != null ? ((idx = idStr.indexOf("(")) != -1 ? idStr.substring(idx + 1, idStr.indexOf(")")) : ((idx = idStr.indexOf("tid=")) != -1 ? idStr.substring(idx + 4) : idStr)) : "NoTx";
                        TETxLifeCycleInfo.traceUserTxCommit(idStr, "User Tx Commit Failed");
                    }
                }
                try {
                    this.changeToLocalContext(threadData);
                }
                catch (Throwable ex) {
                    FFDCFilter.processException((Throwable)rbe, (String)"com.ibm.ejs.container.UserTransactionWrapper.commit", (String)"312", (Object)this);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEntryEnabled()) break block14;
                    Tr.exit((TraceComponent)tc, (String)"Exception during changeToLocalContext()", (Object)ex);
                }
            }
            throw rbe;
        }
        catch (RemoteException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.container.UserTransactionWrapper.commit", (String)"197", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"Exception during commit()", (Object)e);
            }
            throw new SystemException(e.toString());
        }
        if (entryEnabled) {
            Tr.exit((TraceComponent)tc, (String)"UserTransactionWrapper.commit");
        }
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        String idStr = null;
        if (TraceComponent.isAnyTracingEnabled()) {
            Transaction transaction;
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"UserTransactionWrapper.rollback", (Object[])new Object[0]);
            }
            Transaction transaction2 = transaction = this.txCurrent != null ? this.txCurrent.getTransaction() : null;
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("User Code rolling back TX cntxt: " + transaction), (Object[])new Object[0]);
            }
            if (TETxLifeCycleInfo.isTraceEnabled()) {
                idStr = this.txCurrent != null && transaction != null ? transaction.toString() : "NoTxCurrent";
            }
        }
        EJBThreadData threadData = EJSContainer.getUserTransactionThreadData();
        this.userTransactionImpl.rollback();
        try {
            if (TraceComponent.isAnyTracingEnabled() && TETxLifeCycleInfo.isTraceEnabled()) {
                int idx;
                idStr = idStr != null ? ((idx = idStr.indexOf("(")) != -1 ? idStr.substring(idx + 1, idStr.indexOf(")")) : ((idx = idStr.indexOf("tid=")) != -1 ? idStr.substring(idx + 4) : idStr)) : "NoTx";
                TETxLifeCycleInfo.traceUserTxCommit(idStr, "User Tx Rollback");
            }
            this.changeToLocalContext(threadData);
        }
        catch (RemoteException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.container.UserTransactionWrapper.rollback", (String)"237", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"Exception during rollback()", (Object)e);
            }
            throw new SystemException(e.toString());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"UserTransactionWrapper.rollback");
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        boolean entryEnabled;
        boolean bl = entryEnabled = TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled();
        if (entryEnabled) {
            Tr.entry((TraceComponent)tc, (String)"UserTransactionWrapper.setRollbackOnly", (Object[])new Object[0]);
        }
        this.userTransactionImpl.setRollbackOnly();
        if (entryEnabled) {
            Tr.exit((TraceComponent)tc, (String)"UserTransactionWrapper.setRollbackOnly");
        }
    }

    public int getStatus() throws SystemException {
        return this.userTransactionImpl.getStatus();
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        this.userTransactionImpl.setTransactionTimeout(seconds);
        if (TraceComponent.isAnyTracingEnabled() && TETxLifeCycleInfo.isTraceEnabled()) {
            String idStr = "NoTxCurrent";
            if (this.txCurrent != null) {
                int idx;
                Transaction transaction = this.txCurrent.getTransaction();
                if (transaction != null) {
                    idStr = transaction.toString();
                }
                idStr = idStr != null ? ((idx = idStr.indexOf("(")) != -1 ? idStr.substring(idx + 1, idStr.indexOf(")")) : ((idx = idStr.indexOf("tid=")) != -1 ? idStr.substring(idx + 4) : idStr)) : "NoTx";
            }
            TETxLifeCycleInfo.traceUserTxSetTimeout(idStr, "User Tx Set Timeout=" + seconds);
        }
    }

    private void changeToLocalContext(EJBThreadData threadData) throws RemoteException {
        LocalTransactionCurrent ltcCurrent;
        LocalTransactionCoordinator lCoord;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled() && (lCoord = (ltcCurrent = EmbeddableTransactionManagerFactory.getLocalTransactionCurrent()).getLocalTranCoord()) != null) {
            Tr.event((TraceComponent)tc, (String)("Tx Service began LTC cntxt: tid=" + Integer.toHexString(lCoord.hashCode()) + "(LTC)"), (Object[])new Object[0]);
        }
        this.container.processTxContextChange(threadData, true);
    }
}

