/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.runtime.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.RuntimeEvent;
import com.ibm.ws.sib.processor.exceptions.SIMPControllableNotFoundException;
import com.ibm.ws.sib.processor.exceptions.SIMPRuntimeOperationFailedException;
import com.ibm.ws.sib.processor.gd.Stream;
import com.ibm.ws.sib.processor.gd.StreamSet;
import com.ibm.ws.sib.processor.gd.TargetStream;
import com.ibm.ws.sib.processor.gd.TargetStreamManager;
import com.ibm.ws.sib.processor.impl.interfaces.HealthStateListener;
import com.ibm.ws.sib.processor.runtime.DeliveryStreamType;
import com.ibm.ws.sib.processor.runtime.SIMPDeliveryStreamReceiverControllable;
import com.ibm.ws.sib.processor.runtime.SIMPInboundReceiverControllable;
import com.ibm.ws.sib.processor.runtime.SIMPIterator;
import com.ibm.ws.sib.processor.runtime.impl.AbstractControlAdapter;
import com.ibm.ws.sib.processor.runtime.impl.BasicSIMPIterator;
import com.ibm.ws.sib.processor.runtime.impl.HealthStateTree;
import com.ibm.ws.sib.processor.runtime.impl.TargetStreamControl;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.Iterator;

public class TargetStreamSetControl
extends AbstractControlAdapter
implements SIMPInboundReceiverControllable {
    protected TargetStreamManager tsm;
    private StreamSet streamSet;
    private SIBUuid12 streamID;
    private HealthStateTree _healthState;
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceComponent tc = SibTr.register(TargetStreamSetControl.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");

    public TargetStreamSetControl(StreamSet streamSet) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"TargetStreamSetControl", (Object)new Object[]{streamSet});
        }
        this.streamSet = streamSet;
        this.streamID = streamSet.getStreamID();
        this._healthState = new HealthStateTree();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"TargetStreamSetControl", (Object)this);
        }
    }

    public void requestFlushAtSource(boolean indoubtDiscard) throws SIMPRuntimeOperationFailedException, SIMPControllableNotFoundException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"requestFlushAtSource", (Object)new Boolean(indoubtDiscard));
        }
        this.assertValidControllable();
        SIBUuid8 source = this.streamSet.getRemoteMEUuid();
        SIBUuid12 destID = this.streamSet.getDestUuid();
        SIBUuid8 busID = this.streamSet.getBusUuid();
        try {
            this.tsm.requestFlushAtSource(source, destID, busID, this.streamID, indoubtDiscard);
        }
        catch (SIException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.runtime.TargetStreamSetControl.requestFlushAtSource", (String)"1:152:1.16", (Object)this);
            SIMPRuntimeOperationFailedException finalE = new SIMPRuntimeOperationFailedException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0003", new Object[]{"TargetStreamSetControl.requestFlushAtSource", "1:160:1.16", e, this.streamID}, null), (Throwable)e);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)finalE));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"requestFlushAtSource", (Object)((Object)finalE));
            }
            throw finalE;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"requestFlushAtSource");
        }
    }

    public long getLastTickReceived() throws SIMPControllableNotFoundException, SIMPRuntimeOperationFailedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getLastTickReceived");
        }
        this.assertValidControllable();
        long tick = 0L;
        Iterator<Stream> itr = null;
        try {
            itr = this.streamSet.iterator();
        }
        catch (SIResourceException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.runtime.TargetStreamSetControl.getLastTickReceived", (String)"1:194:1.16", (Object)this);
            SIMPRuntimeOperationFailedException finalE = new SIMPRuntimeOperationFailedException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"TargetStreamSetControl.getLastTickReceived", "1:202:1.16", e}, null), (Throwable)e);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)finalE));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getLastTickReceived", (Object)((Object)finalE));
            }
            throw finalE;
        }
        while (itr.hasNext()) {
            TargetStream stream = (TargetStream)itr.next();
            long newTick = stream.getLastKnownTick();
            tick = newTick > tick ? newTick : tick;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getLastTickReceived", (Object)new Long(tick));
        }
        return tick;
    }

    public void forceFlushAtTarget() throws SIMPRuntimeOperationFailedException, SIMPControllableNotFoundException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"forceFlushAtTarget");
        }
        this.assertValidControllable();
        try {
            this.tsm.forceFlush(this.streamID);
        }
        catch (SIException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.runtime.TargetStreamSetControl.forceFlushAtTarget", (String)"1:256:1.16", (Object)this);
            SIMPRuntimeOperationFailedException finalE = new SIMPRuntimeOperationFailedException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0003", new Object[]{"TargetStreamSetControl.forceFlushAtTarget", "1:264:1.16", e, this.streamID}, null), (Throwable)e);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)finalE));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"forceFlushAtTarget", (Object)((Object)finalE));
            }
            throw finalE;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"forceFlushAtTarget");
        }
    }

    public DeliveryStreamType getType() {
        return null;
    }

    public String getName() {
        return null;
    }

    public String getId() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getId");
        }
        String returnString = this.streamID.toString();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getId", (Object)returnString);
        }
        return returnString;
    }

    @Override
    public void assertValidControllable() throws SIMPControllableNotFoundException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"assertValidControllable");
        }
        if (this.streamSet == null || this.tsm == null) {
            SIMPControllableNotFoundException finalE = new SIMPControllableNotFoundException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"TargetStreamSetControl.assertValidControllable", "1:325:1.16", this.streamID}, null));
            SibTr.exception((TraceComponent)tc, (Exception)((Object)finalE));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"assertValidControllable", (Object)((Object)finalE));
            }
            throw finalE;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"assertValidControllable");
        }
    }

    @Override
    public void dereferenceControllable() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"dereferenceControllable", (Object)this.tsm);
        }
        this.streamSet = null;
        this.tsm = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"dereferenceControllable");
        }
    }

    @Override
    public void runtimeEventOccurred(RuntimeEvent event) {
    }

    public void setTargetStreamManager(TargetStreamManager tsm) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setTargetStreamManager", (Object)tsm);
        }
        this.tsm = tsm;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setTargetStreamManager");
        }
    }

    public long getNumberOfMessagesReceived() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getNumberOfMessagesReceived");
        }
        Iterator<Stream> streams = null;
        try {
            streams = this.streamSet.iterator();
        }
        catch (SIResourceException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.runtime.TargetStreamSetControl.getNumberOfMessagesReceived", (String)"1:388:1.16", (Object)this);
            SIMPRuntimeOperationFailedException finalE = new SIMPRuntimeOperationFailedException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"TargetStreamSetControl.getNumberOfMessagesReceived", "1:396:1.16", e}, null), (Throwable)e);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)finalE));
        }
        long numMsgsReceived = 0L;
        while (streams.hasNext()) {
            TargetStream streamControl = (TargetStream)streams.next();
            numMsgsReceived += streamControl.getNumberOfMessagesReceived();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getNumberOfMessagesReceived", (Object)new Long(numMsgsReceived));
        }
        return numMsgsReceived;
    }

    public long getDepth() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDepth");
        }
        Iterator<Stream> streams = null;
        try {
            streams = this.streamSet.iterator();
        }
        catch (SIResourceException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.runtime.TargetStreamSetControl.getDepth", (String)"1:432:1.16", (Object)this);
            SIMPRuntimeOperationFailedException finalE = new SIMPRuntimeOperationFailedException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"TargetStreamSetControl.getDepth", "1:440:1.16", e}, null), (Throwable)e);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)finalE));
        }
        long depth = 0L;
        while (streams.hasNext()) {
            TargetStream streamControl = (TargetStream)streams.next();
            depth += (long)streamControl.getAllMessagesOnStream().size();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDepth", (Object)new Long(depth));
        }
        return depth;
    }

    public SIMPIterator getStreams() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getStreams");
        }
        Iterator<Stream> it = null;
        try {
            it = this.streamSet.iterator();
        }
        catch (SIResourceException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.runtime.TargetStreamSetControl.getStreams", (String)"1:476:1.16", (Object)this);
            SIMPRuntimeOperationFailedException finalE = new SIMPRuntimeOperationFailedException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"TargetStreamSetControl.getStreams", "1:484:1.16", e}, null), (Throwable)e);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)finalE));
        }
        TargetStreamControllableIterator targetStreamIterator = new TargetStreamControllableIterator(it, this.tsm);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getStreams", (Object)targetStreamIterator);
        }
        return targetStreamIterator;
    }

    @Override
    public String getRemoteEngineUuid() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRemoteEngineUuid");
        }
        String uuid = this.streamSet.getRemoteMEUuid().toString();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getRemoteEngineUuid", (Object)uuid);
        }
        return uuid;
    }

    public HealthStateListener getHealthState() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getHealthState");
        }
        SIMPIterator it = this.getStreams();
        while (it.hasNext()) {
            SIMPDeliveryStreamReceiverControllable control = (SIMPDeliveryStreamReceiverControllable)it.next();
            this._healthState.addHealthStateNode(control.getHealthState());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getHealthState", (Object)this._healthState);
        }
        return this._healthState;
    }

    private class TargetStreamControllableIterator
    extends BasicSIMPIterator {
        TargetStreamManager tsm;

        public TargetStreamControllableIterator(Iterator targetStreamSet, TargetStreamManager tsm) {
            super(targetStreamSet);
            this.tsm = null;
            this.tsm = tsm;
        }

        @Override
        public Object next() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"next");
            }
            TargetStream targetStream = (TargetStream)super.next();
            TargetStreamControl targetStreamControl = targetStream.getControlAdapter();
            targetStreamControl.setTSM(this.tsm);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"next", (Object)targetStreamControl);
            }
            return targetStreamControl;
        }
    }
}

