/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.MessageDecodeFailedException;
import com.ibm.ws.sib.mfp.MfpConstants;
import com.ibm.ws.sib.mfp.PersistenceType;
import com.ibm.ws.sib.mfp.ProducerType;
import com.ibm.ws.sib.mfp.impl.JsMessageImpl;
import com.ibm.ws.sib.mfp.impl.JsMsgObject;
import com.ibm.ws.sib.mfp.schema.JsApiAccess;
import com.ibm.ws.sib.utils.HexString;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.nio.charset.StandardCharsets;
import java.util.List;

abstract class JsApiHdrsImpl
extends JsMessageImpl {
    private static TraceComponent tc = SibTr.register(JsApiHdrsImpl.class, (String)"SIBMfp", (String)"com.ibm.ws.sib.mfp.CWSIFMessages");
    private static TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.mfp.CWSIFMessages");
    private static final long serialVersionUID = 1L;
    private static final String ID_STRING = "ID:";
    private static final int FLUFFED_API_HDRS_SIZE = FLUFFED_JMF_MESSAGE_SIZE + FLUFFED_JSMSGPART_SIZE + FLUFFED_REF_SIZE * 45 + FLUFFED_OBJECT_OVERHEAD * 2 + FLUFFED_STRING_OVERHEAD * 2 + 60;

    JsApiHdrsImpl() {
    }

    JsApiHdrsImpl(int flag) throws MessageDecodeFailedException {
        super(flag);
        this.setProducerType(ProducerType.API);
        if (flag != 2 && flag != 3) {
            this.jmo.setPart(9, JsApiAccess.schema);
            this.setApiMessageIdAsBytes(null);
            this.getApi().setChoiceField(45, 0);
            this.setUserid(null);
            this.getApi().setChoiceField(46, 0);
            this.getApi().setChoiceField(47, 0);
            this.getApi().setChoiceField(48, 0);
            this.getApi().setChoiceField(49, 0);
            this.getApi().setChoiceField(50, 0);
            this.getApi().setChoiceField(51, 0);
            this.getApi().setChoiceField(52, 0);
            this.getApi().setChoiceField(53, 0);
            this.getApi().setChoiceField(54, 0);
            this.getApi().setChoiceField(55, 0);
            this.getApi().setChoiceField(56, 0);
            this.getApi().setChoiceField(57, 0);
            this.getApi().setChoiceField(60, 0);
            this.getApi().setChoiceField(58, 0);
            this.getApi().setChoiceField(59, 0);
            this.getApi().setField(36, null);
            this.getApi().setField(37, null);
            this.getApi().setField(38, null);
            this.getApi().setField(39, null);
            this.getApi().setField(40, null);
            this.getApi().setField(41, null);
            this.getApi().setField(42, null);
            this.getApi().setField(43, null);
        }
    }

    JsApiHdrsImpl(JsMsgObject inJmo) {
        super(inJmo);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"<init>, inbound jmo ");
        }
    }

    @Override
    int guessApproxLength() {
        int total = super.guessApproxLength();
        return total += 120;
    }

    @Override
    int guessFluffedSize() {
        int total = super.guessFluffedSize() + FLUFFED_API_HDRS_SIZE;
        return total;
    }

    private boolean isValidDiscriminator(String s) {
        if (s.indexOf(58) != -1 || s.indexOf(42) != -1) {
            return false;
        }
        int last = s.length();
        if (last > 0 && (s.charAt(0) == '/' || s.charAt(0) == '.')) {
            return false;
        }
        int i = s.indexOf(47);
        while (i++ != -1) {
            if (i == last || s.charAt(i) == '/' || s.charAt(i) == '.') {
                return false;
            }
            i = s.indexOf(47, i);
        }
        return true;
    }

    @Override
    public final void setForwardRoutingPath(List<SIDestinationAddress> value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setForwardRoutingPath", value);
        }
        if (value != null) {
            for (int i = 0; i < value.size(); ++i) {
                if (value.get(i) == null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((Object)this, (TraceComponent)tc, (String)"setForwardRoutingPath", (Object)"NullPointerException");
                    }
                    throw new NullPointerException();
                }
                if (value.get(i) instanceof SIDestinationAddress) continue;
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"setForwardRoutingPath", (Object)"IllegalArgumentException");
                }
                throw new IllegalArgumentException(value.toString());
            }
        }
        this.setFRP(value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setForwardRoutingPath");
        }
    }

    @Override
    public final void setReverseRoutingPath(List<SIDestinationAddress> value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setReverseRoutingPath", value);
        }
        if (value != null) {
            for (int i = 0; i < value.size(); ++i) {
                if (value.get(i) == null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((Object)this, (TraceComponent)tc, (String)"setReverseRoutingPath", (Object)"NullPointerException");
                    }
                    throw new NullPointerException();
                }
                if (value.get(i) instanceof SIDestinationAddress) continue;
                IllegalArgumentException e = new IllegalArgumentException(value.toString());
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"setReverseRoutingPath", (Object)e);
                }
                throw e;
            }
        }
        this.setRRP(value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setReverseRoutingPath");
        }
    }

    @Override
    public final void setDiscriminator(String value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setDiscriminator", (Object)value);
        }
        if (value != null && !this.isValidDiscriminator(value)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"setDiscriminator", (Object)"IllegalArgumentException");
            }
            throw new IllegalArgumentException(value);
        }
        super.setDiscriminator(value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setDiscriminator");
        }
    }

    @Override
    public final void setPriority(int value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setPriority", (Object)value);
        }
        if (value < 0 || value > 9) {
            IllegalArgumentException e = new IllegalArgumentException(Integer.toString(value));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"setPriority", (Object)e);
            }
            throw e;
        }
        super.setPriority(value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setPriority");
        }
    }

    @Override
    public final void setReliability(Reliability value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setReliability", (Object)value);
        }
        if (value == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"setReliability", (Object)"NullPointerException");
            }
            throw new NullPointerException();
        }
        super.setReliability(value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setReliability");
        }
    }

    @Override
    public final void setTimeToLive(long value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setTimeToLive", (Object)value);
        }
        if (value < 0L || value > 9191815209357175807L) {
            IllegalArgumentException e = new IllegalArgumentException(Long.toString(value));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"setTimeToLive", (Object)e);
            }
            throw e;
        }
        super.setTimeToLive(value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setTimeToLive");
        }
    }

    @Override
    public final void setDeliveryDelay(long value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setDeliveryDelay", (Object)value);
        }
        if (value < 0L || value > 9191815209357175807L) {
            IllegalArgumentException e = new IllegalArgumentException(Long.toString(value));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"setDeliveryDelay", (Object)e);
            }
            throw e;
        }
        super.setDeliveryDelay(value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setDeliveryDelay");
        }
    }

    @Override
    public final String getReplyDiscriminator() {
        return (String)this.getApi().getField(5);
    }

    @Override
    public final Integer getReplyPriority() {
        return (Integer)this.getApi().getField(6);
    }

    @Override
    public final Reliability getReplyReliability() {
        Byte rType = (Byte)this.getApi().getField(7);
        return rType == null ? null : Reliability.getReliability(rType);
    }

    @Override
    public final Long getReplyTimeToLive() {
        return (Long)this.getApi().getField(8);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final void setReplyDiscriminator(String value) {
        block6: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"setReplyDiscriminator", (Object)value);
            }
            if (value != null) {
                if (this.isValidDiscriminator(value)) {
                    this.getApi().setField(5, value);
                    break block6;
                } else {
                    IllegalArgumentException e = new IllegalArgumentException(value);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((Object)this, (TraceComponent)tc, (String)"setReplyDiscriminator", (Object)e);
                    }
                    throw e;
                }
            }
            this.getApi().setChoiceField(47, 0);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setReplyDiscriminator");
        }
    }

    @Override
    public final void setReplyPriority(int value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setReplyPriority", (Object)value);
        }
        if (value < 0 || value > 9) {
            IllegalArgumentException e = new IllegalArgumentException(Integer.toString(value));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"setReplyPriority", (Object)e);
            }
            throw e;
        }
        this.getApi().setIntField(6, value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setReplyPriority");
        }
    }

    @Override
    public final void setReplyReliability(Reliability value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setReplyReliability", (Object)value);
        }
        if (value == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"setReplyReliability", (Object)"NullPointerException");
            }
            throw new NullPointerException();
        }
        this.getApi().setField(7, value.toByte());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setReplyReliability");
        }
    }

    @Override
    public final void setReplyTimeToLive(long value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setReplyTimeToLive", (Object)value);
        }
        if (value < 0L || value > 9191815209357175807L) {
            IllegalArgumentException e = new IllegalArgumentException(Long.toString(value));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"setReplyTimeToLive", (Object)e);
            }
            throw e;
        }
        this.getApi().setLongField(8, value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setReplyTimeToLive");
        }
    }

    @Override
    public final void clearReplyFields() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"clearReplyFields");
        }
        this.getApi().setChoiceField(47, 0);
        this.getApi().setChoiceField(48, 0);
        this.getApi().setChoiceField(49, 0);
        this.getApi().setChoiceField(50, 0);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"clearReplyFields");
        }
    }

    public final String getApiMessageId() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getApiMessageId");
        }
        String value = null;
        byte[] binValue = (byte[])this.getApi().getField(0);
        if (binValue != null) {
            StringBuffer sbuf = new StringBuffer(binValue.length * 2 + 3);
            sbuf.append(ID_STRING);
            HexString.binToHex((byte[])binValue, (int)0, (int)binValue.length, (StringBuffer)sbuf);
            value = sbuf.toString();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getApiMessageId", value);
        }
        return value;
    }

    @Override
    public final byte[] getApiMessageIdAsBytes() {
        byte[] value;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getApiMessageIdAsBytes");
        }
        if ((value = (byte[])this.getApi().getField(0)) != null) {
            byte[] copy = new byte[value.length];
            System.arraycopy(value, 0, copy, 0, value.length);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"getApiMessageIdAsBytes", (Object)copy);
            }
            return copy;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getApiMessageIdAsBytes", null);
        }
        return null;
    }

    public final String getCorrelationId() {
        byte[] binValue;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getCorrelationId");
        }
        String value = null;
        int choice = this.getApi().getChoiceField(45);
        if (choice == 2) {
            value = (String)this.getApi().getField(2);
        } else if (choice == 1 && (binValue = (byte[])this.getApi().getField(1)) != null) {
            StringBuffer sbuf = new StringBuffer(binValue.length * 2 + 3);
            sbuf.append(ID_STRING);
            HexString.binToHex((byte[])binValue, (int)0, (int)binValue.length, (StringBuffer)sbuf);
            value = sbuf.toString();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getCorrelationId", (Object)value);
        }
        return value;
    }

    @Override
    public final byte[] getCorrelationIdAsBytes() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getCorrelationIdAsBytes");
        }
        byte[] value = null;
        int choice = this.getApi().getChoiceField(45);
        if (choice == 1) {
            byte[] temp = (byte[])this.getApi().getField(1);
            value = new byte[temp.length];
            System.arraycopy(temp, 0, value, 0, temp.length);
        } else if (choice == 2) {
            String strValue = (String)this.getApi().getField(2);
            value = strValue.startsWith(ID_STRING) ? HexString.hexToBin((String)strValue, (int)3) : strValue.getBytes(StandardCharsets.UTF_8);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getCorrelationIdAsBytes", (Object)value);
        }
        return value;
    }

    public final String getUserid() {
        return (String)this.getApi().getField(3);
    }

    @Override
    public final String getApiUserId() {
        return this.getUserid();
    }

    public final String getFormat() {
        return (String)this.jmo.getPayloadPart().getField(0);
    }

    public final void setApiMessageId(String value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setApiMessageId", (Object)value);
        }
        if (value == null) {
            this.getApi().setField(0, null);
        } else if (value.startsWith(ID_STRING)) {
            byte[] binValue = HexString.hexToBin((String)value, (int)3);
            this.getApi().setField(0, binValue);
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"setApiMessageId", (Object)"IllegalArgumentException");
            }
            throw new IllegalArgumentException();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setApiMessageId");
        }
    }

    @Override
    public final void setApiMessageIdAsBytes(byte[] value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setApiMessageIdAsBytes", (Object)value);
        }
        if (value != null) {
            byte[] copy = new byte[value.length];
            System.arraycopy(value, 0, copy, 0, value.length);
            this.getApi().setField(0, copy);
        } else {
            this.getApi().setField(0, null);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setApiMessageIdAsBytes");
        }
    }

    public final void setCorrelationId(String value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setCorrelationId", (Object)value);
        }
        if (value != null && value.startsWith(ID_STRING)) {
            boolean needsConvert = false;
            int length = value.length();
            if (length % 2 == 0) {
                String nlsMsg = nls.getFormattedMessage("BAD_HEX_STRING_CWSIF0191", new Object[]{value}, "The hexadecimal string " + value + " is incorrectly formatted for a Correlation Id");
                IllegalArgumentException e = new IllegalArgumentException(nlsMsg);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"setCorrelationId", (Object)e);
                }
                throw e;
            }
            for (int i = 3; i < length; ++i) {
                char ch = value.charAt(i);
                if (Character.digit(ch, 16) < 0) {
                    String nlsMsg = nls.getFormattedMessage("BAD_HEX_STRING_CWSIF0191", new Object[]{value}, "The hexadecimal string " + value + " is incorrectly formatted for a Correlation Id");
                    IllegalArgumentException e = new IllegalArgumentException(nlsMsg);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((Object)this, (TraceComponent)tc, (String)"setCorrelationId", (Object)e);
                    }
                    throw e;
                }
                if (!Character.isUpperCase(ch)) continue;
                needsConvert = true;
            }
            if (needsConvert) {
                value = ID_STRING + value.substring(3).toLowerCase();
            }
        }
        if (value != null) {
            this.getApi().setField(2, value);
        } else {
            this.getApi().setChoiceField(45, 0);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setCorrelationId");
        }
    }

    @Override
    public final void setCorrelationIdAsBytes(byte[] value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setCorrelationIdAsBytes", (Object)value);
        }
        if (value != null) {
            byte[] copy = new byte[value.length];
            System.arraycopy(value, 0, copy, 0, value.length);
            this.getApi().setField(1, copy);
        } else {
            this.getApi().setChoiceField(45, 0);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setCorrelationIdAsBytes");
        }
    }

    public final void setUserid(String value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setUserid", (Object)value);
        }
        this.getApi().setField(3, value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setUserid");
        }
    }

    @Override
    public final void setApiUserId(String value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setApiUserId", (Object)value);
        }
        this.setUserid(value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setApiUserId");
        }
    }

    public final void setFormat(String value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setFormat", (Object)value);
        }
        this.jmo.getPayloadPart().setField(0, value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setFormat");
        }
    }

    @Override
    public SIBUuid12 getConnectionUuid() {
        byte[] b = (byte[])this.getApi().getField(4);
        if (b != null) {
            return new SIBUuid12(b);
        }
        return null;
    }

    @Override
    public void setConnectionUuid(SIBUuid12 value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setConnectionUuid", (Object)value);
        }
        if (value != null) {
            this.getApi().setField(4, value.toByteArray());
        } else {
            this.getApi().setField(4, null);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setConnectionUuid");
        }
    }

    @Override
    public final Byte getReportException() {
        return (Byte)this.getApi().getField(9);
    }

    @Override
    public final Boolean getReportPAN() {
        Boolean value = (Boolean)this.getApi().getField(10);
        return value == null ? Boolean.FALSE : value;
    }

    @Override
    public final Boolean getReportNAN() {
        Boolean value = (Boolean)this.getApi().getField(11);
        return value == null ? Boolean.FALSE : value;
    }

    @Override
    public final Boolean getReportPassMsgId() {
        Boolean value = (Boolean)this.getApi().getField(12);
        return value == null ? Boolean.FALSE : value;
    }

    @Override
    public final Boolean getReportPassCorrelId() {
        Boolean value = (Boolean)this.getApi().getField(13);
        return value == null ? Boolean.FALSE : value;
    }

    @Override
    public final Boolean getReportDiscardMsg() {
        Boolean value = (Boolean)this.getApi().getField(14);
        return value == null ? Boolean.FALSE : value;
    }

    @Override
    public final Integer getReportFeedback() {
        Integer result = (Integer)this.getApi().getField(44);
        if (result == null) {
            Byte temp = (Byte)this.getApi().getField(15);
            result = temp == null ? null : Integer.valueOf(temp.intValue());
        }
        return result;
    }

    @Override
    public final void setReportException(Byte value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setReportException", (Object)value);
        }
        if (value != null) {
            this.getApi().setField(9, value);
        } else {
            this.getApi().setChoiceField(51, 0);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setReportException");
        }
    }

    @Override
    public final void setReportPAN(Boolean value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setReportPAN", (Object)value);
        }
        if (value != null) {
            this.getApi().setField(10, value);
        } else {
            this.getApi().setChoiceField(52, 0);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setReportPAN");
        }
    }

    @Override
    public final void setReportNAN(Boolean value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setReportNAN", (Object)value);
        }
        if (value != null) {
            this.getApi().setField(11, value);
        } else {
            this.getApi().setChoiceField(53, 0);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setReportNAN");
        }
    }

    @Override
    public final void setReportPassMsgId(Boolean value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setReportPassMsgId", (Object)value);
        }
        if (value != null) {
            this.getApi().setField(12, value);
        } else {
            this.getApi().setChoiceField(54, 0);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setReportPassMsgId");
        }
    }

    @Override
    public final void setReportPassCorrelId(Boolean value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setReportPassCorrelId", (Object)value);
        }
        if (value != null) {
            this.getApi().setField(13, value);
        } else {
            this.getApi().setChoiceField(55, 0);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setReportPassCorrelId");
        }
    }

    @Override
    public final void setReportDiscardMsg(Boolean value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setReportDiscardMsg", (Object)value);
        }
        if (value != null) {
            this.getApi().setField(14, value);
        } else {
            this.getApi().setChoiceField(56, 0);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setReportDiscardMsg");
        }
    }

    @Override
    public final void setReportFeedback(Integer value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setReportFeedback", (Object)value);
        }
        if (value != null) {
            if (value >= -128 && value <= 127) {
                this.getApi().setField(15, value.byteValue());
            }
            this.getApi().setField(44, value);
        } else {
            this.getApi().setChoiceField(57, 0);
            this.getApi().setChoiceField(60, 0);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setReportFeedback");
        }
    }

    @Override
    public abstract void clearMessagePayload();

    public final PersistenceType getJmsDeliveryMode() {
        if (this.getHdr2().getChoiceField(81) == 0) {
            return this.getDerivedJmsDeliveryMode();
        }
        Byte pType = (Byte)this.getHdr2().getField(52);
        return PersistenceType.getPersistenceType(pType);
    }

    public final Long getJmsExpiration() {
        if (this.getHdr2().getChoiceField(82) == 0) {
            return this.getDerivedJmsExpiration();
        }
        return (Long)this.getHdr2().getField(53);
    }

    public final Long getJmsDeliveryTime() {
        if (this.getHdr2().getChoiceField(93) == 0) {
            return this.getDerivedJmsDeliveryTime();
        }
        return (Long)this.getHdr2().getField(65);
    }

    public final byte[] getJmsDestination() {
        return (byte[])this.getHdr2().getField(54);
    }

    public final byte[] getJmsReplyTo() {
        return (byte[])this.getHdr2().getField(55);
    }

    public final String getJmsType() {
        if (this.getHdr2().getChoiceField(85) == 0) {
            return this.getDerivedJmsType();
        }
        return (String)this.getHdr2().getField(56);
    }

    public final Boolean getJmsRedelivered() {
        if (this.getRedeliveredCount() > 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public final int getJmsxDeliveryCount() {
        if (this.isSent()) {
            return this.getRedeliveredCount() + 1;
        }
        return 0;
    }

    public final String getJmsxAppId() {
        int choice = this.getHdr2().getChoiceField(66);
        if (choice == 0) {
            return null;
        }
        if (choice == 1) {
            try {
                return MfpConstants.JMSXAPPIDS[((Byte)this.getHdr2().getField(17)).intValue()];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.mfp.impl.JsApiHdrsImpl.getJmsxAppId", (String)"1059");
                return null;
            }
        }
        return (String)this.getHdr2().getField(18);
    }

    public final void setJmsType(String value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setJmsType", (Object)value);
        }
        this.getHdr2().setField(56, value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setJmsType");
        }
    }

    public final void setJmsxAppId(String value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setJmsxAppId", (Object)value);
        }
        this.getHdr2().setField(18, value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setJmsxAppId");
        }
    }

    final PersistenceType getDerivedJmsDeliveryMode() {
        return PersistenceType.getPersistenceType(this.getReliability().getPersistence());
    }

    final long getDerivedJmsExpiration() {
        long ts = this.getTimestamp();
        long ttl = this.getTimeToLive();
        if (ts <= 0L || ttl <= 0L) {
            return 0L;
        }
        return ts + ttl;
    }

    final long getDerivedJmsDeliveryTime() {
        long ts = this.getTimestamp();
        long dd = this.getDeliveryDelay();
        if (ts <= 0L || dd <= 0L) {
            return 0L;
        }
        return ts + dd;
    }

    final String getDerivedJmsType() {
        return this.getFormat();
    }

    final Integer getCcsid() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getCcsid");
        }
        Integer value = (Integer)this.jmo.getPayloadPart().getField(2);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getCcsid", (Object)value);
        }
        return value;
    }

    final Integer getEncoding() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getEncoding");
        }
        Integer value = (Integer)this.jmo.getPayloadPart().getField(3);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getEncoding", (Object)value);
        }
        return value;
    }

    final void setCcsid(Object value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setCcsid", (Object)value);
        }
        if (value == null) {
            this.jmo.getPayloadPart().setField(5, 0);
        } else if (value instanceof Integer) {
            this.jmo.getPayloadPart().setField(2, value);
        } else {
            this.jmo.getPayloadPart().setField(5, 0);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setCcsid");
        }
    }

    final void setEncoding(Object value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setEncoding", (Object)value);
        }
        if (value == null || !(value instanceof Integer)) {
            this.jmo.getPayloadPart().setField(6, 0);
        } else {
            this.jmo.getPayloadPart().setField(3, value);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setEncoding");
        }
    }

    public String getMessageControlClassification() {
        return (String)this.getHdr2().getField(59);
    }

    public void setMessageControlClassification(String value) {
        if (value != null) {
            this.getHdr2().setField(59, value);
        } else {
            this.getHdr2().setChoiceField(88, 0);
        }
    }
}

