/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.transport.iiop.security;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authentication.UnauthenticatedSubjectService;
import com.ibm.ws.security.context.SubjectManager;
import com.ibm.ws.security.csiv2.config.CompatibleMechanisms;
import com.ibm.ws.security.csiv2.util.LocationUtils;
import com.ibm.ws.security.csiv2.util.SecurityServices;
import com.ibm.ws.transport.iiop.security.ClientPolicy;
import com.ibm.ws.transport.iiop.security.config.css.CSSCompoundSecMechConfig;
import com.ibm.ws.transport.iiop.security.config.css.CSSConfig;
import com.ibm.ws.transport.iiop.security.config.tss.TSSCompoundSecMechConfig;
import com.ibm.ws.transport.iiop.security.config.tss.TSSCompoundSecMechListConfig;
import com.ibm.ws.transport.iiop.security.util.Util;
import java.util.Iterator;
import java.util.LinkedList;
import javax.security.auth.Subject;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.IOP.Codec;
import org.omg.IOP.ServiceContext;
import org.omg.IOP.TaggedComponent;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ClientRequestInterceptor;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
final class ClientSecurityInterceptor
extends LocalObject
implements ClientRequestInterceptor {
    private static final TraceComponent tc = Tr.register(ClientSecurityInterceptor.class, (String)"CSIv2", (String)"com.ibm.ws.security.csiv2.internal.resources.CSIv2CommonMessages");
    private static final long serialVersionUID = 1L;
    private final Codec codec;

    public ClientSecurityInterceptor(Codec codec) {
        this.codec = codec;
    }

    public void receive_exception(ClientRequestInfo ri) {
    }

    public void receive_other(ClientRequestInfo ri) {
    }

    public void receive_reply(ClientRequestInfo ri) {
    }

    public void send_poll(ClientRequestInfo ri) {
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={BAD_PARAM.class})
    public void send_request(ClientRequestInfo ri) {
        block17: {
            int requestId = ri.request_id();
            boolean isDebug = TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled();
            try {
                TSSCompoundSecMechConfig targetMechConfig;
                LinkedList<CompatibleMechanisms> compatibleMechanismsList;
                if (isDebug) {
                    Tr.debug((TraceComponent)tc, (String)("Checking if target " + ri.operation() + " has a security policy for request id: " + requestId + "."), (Object[])new Object[0]);
                }
                TaggedComponent taggedComponent = ri.get_effective_component(33);
                TSSCompoundSecMechListConfig tcsml = TSSCompoundSecMechListConfig.decodeIOR(this.codec, taggedComponent);
                if (isDebug) {
                    Tr.debug((TraceComponent)tc, (String)("Target has a security policy  for request id: " + requestId + "."), (Object[])new Object[0]);
                }
                this.setUnauthenticatedSubjectIfNeeded();
                ClientPolicy clientPolicy = (ClientPolicy)ri.get_request_policy(1095976449);
                if (clientPolicy == null) {
                    this.buildPolicyErrorMessage("CSIv2_CLIENT_POLICY_NULL_ERROR", "CWWKS9538E: The client security policy is null for request id: {0}.", requestId);
                    return;
                }
                CSSConfig config = clientPolicy.getConfig();
                if (config == null) {
                    if (isDebug) {
                        Tr.debug((TraceComponent)tc, (String)("There is no client configuration found in the client security policy for request id: " + requestId + "."), (Object[])new Object[0]);
                    }
                    return;
                }
                if (isDebug) {
                    Tr.debug((TraceComponent)tc, (String)("Client has a security policy for request id: " + requestId + "."), (Object[])new Object[0]);
                }
                if ((compatibleMechanismsList = config.findCompatibleList(tcsml)).isEmpty()) {
                    if (isDebug) {
                        Tr.debug((TraceComponent)tc, (String)("Ensure that there is a client security policy specified in the configuration file that satisfies the server security policy request id: " + requestId + "."), (Object[])new Object[0]);
                    }
                    return;
                }
                Iterator compatiblePoliciesIterator = compatibleMechanismsList.iterator();
                CompatibleMechanisms compatibleMechanisms = (CompatibleMechanisms)compatiblePoliciesIterator.next();
                CSSCompoundSecMechConfig clientMechConfig = compatibleMechanisms.getCSSCompoundSecMechConfig();
                ServiceContext context = clientMechConfig.generateServiceContext(this.codec, targetMechConfig = compatibleMechanisms.getTSSCompoundSecMechConfig(), ri);
                if (context != null) {
                    if (isDebug) {
                        Tr.debug((TraceComponent)tc, (String)("Msg context id: " + context.context_id + " for request id: " + requestId + "."), (Object[])new Object[0]);
                        Tr.debug((TraceComponent)tc, (String)("Encoded msg: 0x" + Util.byteToString(context.context_data) + " for request id: " + requestId + "."), (Object[])new Object[0]);
                    }
                    ri.add_request_service_context(context, true);
                } else if (isDebug) {
                    Tr.debug((TraceComponent)tc, (String)("No security service context found for request id " + requestId + "."), (Object[])new Object[0]);
                }
            }
            catch (BAD_PARAM bp) {
                if (isDebug) {
                    Tr.debug((TraceComponent)tc, (String)("No security service context found for request id: " + requestId + "."), (Object[])new Object[0]);
                }
            }
            catch (Exception bp) {
                void ue;
                FFDCFilter.processException((Throwable)bp, (String)"com.ibm.ws.transport.iiop.security.ClientSecurityInterceptor", (String)"174", (Object)((Object)this), (Object[])new Object[]{ri});
                this.buildPolicyErrorMessage("CSIv2_CLIENT_UNEXPECTED_EXCEPTION_ERROR", "CWWKS9542E: There was an unexpected exception while attempting to send an outbound CSIv2 request for request id {0}. The exception message is {1}", requestId, ue.getMessage());
                if (isDebug) {
                    Tr.debug((TraceComponent)tc, (String)"There was an unexpected exception while attempting to send an outbound CSIv2 request", (Object[])new Object[]{ue});
                }
                if (!(ue instanceof NO_PERMISSION)) break block17;
                throw (NO_PERMISSION)ue;
            }
        }
    }

    private void setUnauthenticatedSubjectIfNeeded() {
        UnauthenticatedSubjectService unAuthenticationService;
        Subject callerSubject;
        SubjectManager sm;
        Subject invokedSubject;
        if (LocationUtils.isServer() && (invokedSubject = (sm = new SubjectManager()).getInvocationSubject()) == null && (callerSubject = sm.getCallerSubject()) == null && (unAuthenticationService = SecurityServices.getUnauthenticatedSubjectService()) != null) {
            sm.setInvocationSubject(unAuthenticationService.getUnauthenticatedSubject());
        }
    }

    private void buildPolicyErrorMessage(String msgKey, String defaultMessage, Object ... arg1) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isWarningEnabled()) {
            String messageFromBundle = Tr.formatMessage((TraceComponent)tc, (String)msgKey, (Object[])arg1);
            Tr.error((TraceComponent)tc, (String)messageFromBundle, (Object[])new Object[0]);
        }
    }

    public void destroy() {
    }

    public String name() {
        return "org.apache.geronimo.corba.security.ClientSecurityInterceptor";
    }
}

