/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.api.jms.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.api.jms.ApiJmsConstants;
import com.ibm.websphere.sib.api.jms.JmsConnectionFactory;
import com.ibm.websphere.sib.api.jms.JmsFactoryFactory;
import com.ibm.websphere.sib.api.jms.JmsQueue;
import com.ibm.websphere.sib.api.jms.JmsQueueConnectionFactory;
import com.ibm.websphere.sib.api.jms.JmsTopic;
import com.ibm.websphere.sib.api.jms.JmsTopicConnectionFactory;
import com.ibm.ws.sib.api.jms.JmsRAFactoryFactory;
import com.ibm.ws.sib.api.jms.impl.JmsConnectionFactoryImpl;
import com.ibm.ws.sib.api.jms.impl.JmsErrorUtils;
import com.ibm.ws.sib.api.jms.impl.JmsManagedConnectionFactoryImpl;
import com.ibm.ws.sib.api.jms.impl.JmsManagedQueueConnectionFactoryImpl;
import com.ibm.ws.sib.api.jms.impl.JmsManagedTopicConnectionFactoryImpl;
import com.ibm.ws.sib.api.jms.impl.JmsMetaDataImpl;
import com.ibm.ws.sib.api.jms.impl.JmsQueueConnectionFactoryImpl;
import com.ibm.ws.sib.api.jms.impl.JmsQueueImpl;
import com.ibm.ws.sib.api.jms.impl.JmsTopicConnectionFactoryImpl;
import com.ibm.ws.sib.api.jms.impl.JmsTopicImpl;
import com.ibm.ws.sib.api.jms.impl.URIDestinationCreator;
import com.ibm.ws.sib.api.jmsra.JmsJcaConnectionFactory;
import com.ibm.ws.sib.api.jmsra.JmsJcaFactory;
import com.ibm.ws.sib.api.jmsra.JmsJcaManagedConnectionFactory;
import com.ibm.ws.sib.api.jmsra.JmsJcaManagedQueueConnectionFactory;
import com.ibm.ws.sib.api.jmsra.JmsJcaManagedTopicConnectionFactory;
import com.ibm.ws.sib.utils.ras.SibTr;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.ConnectionMetaData;
import jakarta.jms.InvalidDestinationException;
import jakarta.jms.JMSException;
import jakarta.jms.QueueConnectionFactory;
import jakarta.jms.TopicConnectionFactory;
import jakarta.resource.ResourceException;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

public class JmsFactoryFactoryImpl
extends JmsFactoryFactory
implements ApiJmsConstants,
ObjectFactory,
JmsRAFactoryFactory {
    private static TraceComponent tc = SibTr.register(JmsFactoryFactoryImpl.class, (String)"SIBJms_Internal", (String)"com.ibm.websphere.sib.api.jms.CWSIAJMSMessages");
    private static URIDestinationCreator destCreator = new URIDestinationCreator();
    private static ConcurrentHashMap<String, Integer> clientIdTable = new ConcurrentHashMap();

    @Override
    public JmsConnectionFactory createConnectionFactory() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createConnectionFactory");
        }
        JmsConnectionFactory jmscf = null;
        JmsJcaFactory jcaFact = JmsJcaFactory.getInstance();
        if (jcaFact == null) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "UNABLE_TO_CREATE_FACTORY_CWSIA0008", new Object[]{"JmsJcaFactoryImpl", "sib.api.jmsraOutboundImpl.jar"}, tc);
        }
        JmsJcaManagedConnectionFactory jcamcf = jcaFact.createManagedConnectionFactory();
        try {
            jmscf = (JmsConnectionFactory)jcamcf.createConnectionFactory();
        }
        catch (ResourceException re) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0007", new Object[]{re, "JmsFactoryFactoryImpl.createConnectionFactory (#2)"}, re, "JmsFactoryFactoryImpl.createConnectionFactory#2", this, tc);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createConnectionFactory", (Object)jmscf);
        }
        return jmscf;
    }

    @Override
    public JmsQueueConnectionFactory createQueueConnectionFactory() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createQueueConnectionFactory");
        }
        JmsQueueConnectionFactory jmsqcf = null;
        JmsJcaManagedQueueConnectionFactory jcamqcf = JmsJcaFactory.getInstance().createManagedQueueConnectionFactory();
        try {
            jmsqcf = (JmsQueueConnectionFactory)jcamqcf.createConnectionFactory();
        }
        catch (ResourceException re) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0007", new Object[]{re, "JmsFactoryFactoryImpl.createQueueConnectionFactory (#1)"}, re, "JmsFactoryFactoryImpl.createQueueConnectionFactory#1", this, tc);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createQueueConnectionFactory", (Object)jmsqcf);
        }
        return jmsqcf;
    }

    @Override
    public JmsTopicConnectionFactory createTopicConnectionFactory() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createTopicConnectionFactory");
        }
        JmsTopicConnectionFactory jmstcf = null;
        JmsJcaManagedTopicConnectionFactory jcamtcf = JmsJcaFactory.getInstance().createManagedTopicConnectionFactory();
        try {
            jmstcf = (JmsTopicConnectionFactory)jcamtcf.createConnectionFactory();
        }
        catch (ResourceException re) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0007", new Object[]{re, "JmsFactoryFactoryImpl.createTopicConnectionFactory (#1)"}, re, "JmsFactoryFactoryImpl.createTopicConnectionFactory#1", this, tc);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createTopicConnectionFactory", (Object)jmstcf);
        }
        return jmstcf;
    }

    @Override
    public ConnectionFactory createConnectionFactory(JmsJcaConnectionFactory jcaConnectionFactory) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createConnectionFactory", (Object)jcaConnectionFactory);
        }
        JmsManagedConnectionFactoryImpl cf = new JmsManagedConnectionFactoryImpl(jcaConnectionFactory);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createConnectionFactory", (Object)cf);
        }
        return cf;
    }

    @Override
    public ConnectionFactory createConnectionFactory(JmsJcaConnectionFactory jcaConnectionFactory, JmsJcaManagedConnectionFactory jcaManagedConnectionFactory) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createConnectionFactory", (Object)new Object[]{jcaConnectionFactory, jcaManagedConnectionFactory});
        }
        JmsConnectionFactoryImpl cf = new JmsConnectionFactoryImpl(jcaConnectionFactory, jcaManagedConnectionFactory);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createConnectionFactory", (Object)cf);
        }
        return cf;
    }

    @Override
    public QueueConnectionFactory createQueueConnectionFactory(JmsJcaConnectionFactory jcaConnectionFactory) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createQueueConnectionFactory", (Object)jcaConnectionFactory);
        }
        JmsManagedQueueConnectionFactoryImpl qcf = new JmsManagedQueueConnectionFactoryImpl(jcaConnectionFactory);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createQueueConnectionFactory", (Object)qcf);
        }
        return qcf;
    }

    @Override
    public QueueConnectionFactory createQueueConnectionFactory(JmsJcaConnectionFactory jcaConnectionFactory, JmsJcaManagedQueueConnectionFactory jcaManagedQueueConnectionFactory) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createQueueConnectionFactory", (Object)new Object[]{jcaConnectionFactory, jcaManagedQueueConnectionFactory});
        }
        JmsQueueConnectionFactoryImpl qcf = new JmsQueueConnectionFactoryImpl(jcaConnectionFactory, jcaManagedQueueConnectionFactory);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createQueueConnectionFactory", (Object)qcf);
        }
        return qcf;
    }

    @Override
    public TopicConnectionFactory createTopicConnectionFactory(JmsJcaConnectionFactory jcaConnectionFactory) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createTopicConnectionFactory", (Object)jcaConnectionFactory);
        }
        JmsManagedTopicConnectionFactoryImpl tcf = new JmsManagedTopicConnectionFactoryImpl(jcaConnectionFactory);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createTopicConnectionFactory", (Object)tcf);
        }
        return tcf;
    }

    @Override
    public TopicConnectionFactory createTopicConnectionFactory(JmsJcaConnectionFactory jcaConnectionFactory, JmsJcaManagedTopicConnectionFactory jcaManagedTopicConnectionFactory) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createTopicConnectionFactory", (Object)new Object[]{jcaConnectionFactory, jcaManagedTopicConnectionFactory});
        }
        JmsTopicConnectionFactoryImpl tcf = new JmsTopicConnectionFactoryImpl(jcaConnectionFactory, jcaManagedTopicConnectionFactory);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createTopicConnectionFactory", (Object)tcf);
        }
        return tcf;
    }

    @Override
    public JmsQueue createQueue(String name) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createQueue", (Object)name);
        }
        JmsQueue queue = null;
        if (name == null || "".equals(name) || "queue://".equals(name)) {
            throw (InvalidDestinationException)JmsErrorUtils.newThrowable(InvalidDestinationException.class, "INVALID_VALUE_CWSIA0003", new Object[]{"Queue name", name}, tc);
        }
        if (name.startsWith("topic://")) {
            throw (InvalidDestinationException)JmsErrorUtils.newThrowable(InvalidDestinationException.class, "MALFORMED_DESCRIPTOR_CWSIA0047", new Object[]{"Queue", name}, tc);
        }
        name = name.trim();
        queue = (JmsQueue)destCreator.createDestinationFromString(name, URIDestinationCreator.DestType.QUEUE);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createQueue", (Object)queue);
        }
        return queue;
    }

    @Override
    public JmsTopic createTopic(String name) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createTopic", (Object)name);
        }
        JmsTopic topic = null;
        if (name == null) {
            throw (InvalidDestinationException)JmsErrorUtils.newThrowable(InvalidDestinationException.class, "INVALID_VALUE_CWSIA0003", new Object[]{"Topic name", null}, tc);
        }
        if (name != null && name.startsWith("queue://")) {
            throw (InvalidDestinationException)JmsErrorUtils.newThrowable(InvalidDestinationException.class, "MALFORMED_DESCRIPTOR_CWSIA0047", new Object[]{"Topic", name}, tc);
        }
        name = name.trim();
        topic = (JmsTopic)destCreator.createDestinationFromString(name, URIDestinationCreator.DestType.TOPIC);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createTopic", (Object)topic);
        }
        return topic;
    }

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getObjectInstance", (Object)new Object[]{obj, name, nameCtx, environment});
        }
        Serializable ret = null;
        if (obj instanceof Reference) {
            Reference ref = (Reference)obj;
            String clsName = ref.getClassName();
            if (clsName.equals(ConnectionFactory.class.getName())) {
                ret = this.createConnectionFactory();
                ret.setReference(ref);
            } else if (clsName.equals(QueueConnectionFactory.class.getName())) {
                ret = this.createQueueConnectionFactory();
                ((JmsQueueConnectionFactory)ret).setReference(ref);
            } else if (clsName.equals(TopicConnectionFactory.class.getName())) {
                ret = this.createTopicConnectionFactory();
                ((JmsTopicConnectionFactory)ret).setReference(ref);
            } else if (clsName.equals(JmsQueueImpl.class.getName())) {
                ret = new JmsQueueImpl(ref);
            } else if (clsName.equals(JmsTopicImpl.class.getName())) {
                ret = new JmsTopicImpl(ref);
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("class name is " + clsName));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getObjectInstance", ret);
        }
        return ret;
    }

    @Override
    public ConnectionMetaData getMetaData() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getMetaData");
        }
        JmsMetaDataImpl connectionMetaData = new JmsMetaDataImpl();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getMetaData", (Object)connectionMetaData);
        }
        return connectionMetaData;
    }

    protected static ConcurrentHashMap<String, Integer> getClientIdTable() {
        return clientIdTable;
    }
}

