/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.token.ltpa.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.ws.crypto.ltpakeyutil.LTPAKeyFileUtilityImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.registry.UserRegistryService;
import com.ibm.ws.security.token.ltpa.internal.LTPAKeyFileCreator;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.location.WsResource;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.FileUtils;
import com.ibm.wsspi.security.registry.RegistryHelper;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class LTPAKeyFileCreatorImpl
extends LTPAKeyFileUtilityImpl
implements LTPAKeyFileCreator {
    private static final TraceComponent tc = Tr.register(LTPAKeyFileCreatorImpl.class, (String)"Token", (String)"com.ibm.ws.security.token.ltpa.internal.resources.LTPAMessages");
    private volatile ComponentContext cc = null;
    static final String KEY_USER_REGISTRY_SERVICE = "userRegistryService";
    private final AtomicServiceReference<UserRegistryService> userRegistryServiceRef = new AtomicServiceReference("userRegistryService");
    static final long serialVersionUID = -5627651743838382234L;

    protected void setUserRegistryService(ServiceReference<UserRegistryService> ref) {
        this.userRegistryServiceRef.setReference(ref);
    }

    protected void unsetUserRegistryService(ServiceReference<UserRegistryService> ref) {
        this.userRegistryServiceRef.unsetReference(ref);
    }

    protected void activate(ComponentContext context) {
        this.cc = context;
        this.userRegistryServiceRef.activate(context);
    }

    protected void deactivate(ComponentContext context) {
        this.userRegistryServiceRef.deactivate(context);
    }

    /*
     * WARNING - void declaration
     */
    private String getRealmName() {
        String realm;
        block3: {
            realm = "defaultRealm";
            try {
                String r;
                UserRegistry ur = RegistryHelper.getUserRegistry(null);
                if (ur != null && (r = ur.getRealm()) != null) {
                    realm = r;
                }
            }
            catch (Exception ur) {
                void ex;
                FFDCFilter.processException((Throwable)ur, (String)"com.ibm.ws.security.token.ltpa.internal.LTPAKeyFileCreatorImpl", (String)"81", (Object)this, (Object[])new Object[0]);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                Tr.debug((TraceComponent)tc, (String)"Cannot get the UR service since it may not be available so use the default value for the realm.", (Object[])new Object[]{ex});
            }
        }
        return realm;
    }

    @Override
    public Properties createLTPAKeysFile(WsLocationAdmin locService, String keyFile, @Sensitive byte[] keyPasswordBytes) throws Exception {
        String realmName = this.isUserRegistryAvailable() ? this.getRealmName() : "defaultRealm";
        Properties ltpaProps = this.generateLTPAKeys(keyPasswordBytes, realmName);
        this.addLTPAKeysToFile(this.getOutputStream(locService, keyFile), ltpaProps);
        return ltpaProps;
    }

    private OutputStream getOutputStream(WsLocationAdmin locService, String keyImportFile) throws IOException {
        WsResource ltpaFile = locService.resolveResource(keyImportFile);
        ltpaFile.create();
        if (ltpaFile.isType(WsResource.Type.FILE)) {
            FileUtils.setUserReadWriteOnly((File)ltpaFile.asFile());
        }
        return ltpaFile.putStream();
    }

    private boolean isUserRegistryAvailable() {
        UserRegistryService userRegistryService;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Checking if UserRegistry is available", (Object[])new Object[0]);
        }
        if ((userRegistryService = (UserRegistryService)this.userRegistryServiceRef.getService()) == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"UserRegistryService is not available, defaultRealm will be used for LTPA configuration", (Object[])new Object[0]);
            }
            return false;
        }
        return true;
    }
}

