/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.opentracing.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.opentracing.internal.ActiveSpan;
import io.openliberty.opentracing.internal.OpentracingFilterHelper;
import io.openliberty.opentracing.internal.OpentracingFilterHelperProvider;
import io.openliberty.opentracing.internal.OpentracingService;
import io.openliberty.opentracing.internal.OpentracingTracerManager;
import io.openliberty.opentracing.internal.OpentracingUtils;
import io.openliberty.opentracing.internal.filters.SpanFilterType;
import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMap;
import io.opentracing.tag.Tags;
import java.io.IOException;
import java.net.URI;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;

@Provider
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OpentracingContainerFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private static final TraceComponent tc = Tr.register(OpentracingContainerFilter.class, (String)"OPENTRACING", (String)"io.openliberty.opentracing.internal.resources.Opentracing");
    public static final String SERVER_SPAN_PROP_ID = OpentracingContainerFilter.class.getName() + ".Span";
    public static final String SERVER_SPAN_SKIPPED_ID = OpentracingContainerFilter.class.getName() + ".Skipped";
    public static final String EXCEPTION_KEY = OpentracingContainerFilter.class.getName() + ".Exception";
    private static final String TAG_COMPONENT_JAXRS = "jaxrs";
    @Context
    protected ResourceInfo resourceInfo;
    private OpentracingFilterHelper helper;
    private boolean spanErrorLogged = false;
    static final long serialVersionUID = 3252266038836142212L;

    void setFilterHelper(OpentracingFilterHelper helper) {
        this.helper = helper;
    }

    /*
     * WARNING - void declaration
     */
    public void filter(ContainerRequestContext incomingRequestContext) throws IOException {
        boolean process;
        block15: {
            String methodName = "filter(incoming)";
            this.helper = OpentracingFilterHelperProvider.getInstance().getOpentracingFilterHelper();
            Tracer tracer = OpentracingTracerManager.getTracer();
            if (tracer == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(methodName + " no tracer"), (Object[])new Object[0]);
                }
                return;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)methodName, (Object[])new Object[]{OpentracingUtils.getTracerText(tracer)});
            }
            String buildSpanName = null;
            if (this.helper != null && (buildSpanName = this.helper.getBuildSpanName(incomingRequestContext, this.resourceInfo)) == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(methodName + " skipping not traced method"), (Object[])new Object[0]);
                }
                incomingRequestContext.setProperty(SERVER_SPAN_SKIPPED_ID, (Object)true);
                return;
            }
            URI incomingUri = incomingRequestContext.getUriInfo().getRequestUri();
            String incomingPath = incomingRequestContext.getUriInfo().getPath();
            if (!incomingPath.startsWith("/")) {
                incomingPath = "/" + incomingPath;
            }
            String incomingURL = null;
            SpanContext priorOutgoingContext = null;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                incomingURL = incomingUri.toURL().toString();
                Tr.debug((TraceComponent)tc, (String)(methodName + " incomingURL"), (Object[])new Object[]{incomingURL});
                priorOutgoingContext = tracer.extract(Format.Builtin.HTTP_HEADERS, (Object)new MultivaluedMapToTextMap((MultivaluedMap<String, String>)incomingRequestContext.getHeaders()));
                Tr.debug((TraceComponent)tc, (String)(methodName + " priorContext"), (Object[])new Object[]{priorOutgoingContext});
            }
            if (process = OpentracingService.process(incomingUri, incomingPath, SpanFilterType.INCOMING)) {
                if (incomingURL == null) {
                    incomingURL = incomingUri.toURL().toString();
                }
                if (buildSpanName == null) {
                    buildSpanName = incomingURL;
                }
                if (priorOutgoingContext == null) {
                    priorOutgoingContext = tracer.extract(Format.Builtin.HTTP_HEADERS, (Object)new MultivaluedMapToTextMap((MultivaluedMap<String, String>)incomingRequestContext.getHeaders()));
                }
                Tracer.SpanBuilder spanBuilder = tracer.buildSpan(buildSpanName);
                spanBuilder.withTag(Tags.SPAN_KIND.getKey(), "server");
                spanBuilder.withTag(Tags.HTTP_URL.getKey(), incomingURL);
                spanBuilder.withTag(Tags.HTTP_METHOD.getKey(), incomingRequestContext.getMethod());
                spanBuilder.withTag(Tags.COMPONENT.getKey(), TAG_COMPONENT_JAXRS);
                if (priorOutgoingContext != null) {
                    spanBuilder.asChildOf(priorOutgoingContext);
                }
                try {
                    Span span = spanBuilder.start();
                    Scope scope = tracer.scopeManager().activate(span);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)(methodName + " span"), (Object[])new Object[]{span});
                    }
                    incomingRequestContext.setProperty(SERVER_SPAN_PROP_ID, (Object)new ActiveSpan(span, scope));
                }
                catch (NoSuchMethodError span) {
                    void e;
                    FFDCFilter.processException((Throwable)span, (String)"io.openliberty.opentracing.internal.OpentracingContainerFilter", (String)"154", (Object)this, (Object[])new Object[]{incomingRequestContext});
                    if (this.spanErrorLogged) break block15;
                    Tr.error((TraceComponent)tc, (String)"OPENTRACING_COULD_NOT_START_SPAN", (Object[])new Object[]{e});
                    this.spanErrorLogged = true;
                }
            }
        }
        incomingRequestContext.setProperty(SERVER_SPAN_SKIPPED_ID, (Object)(!process ? 1 : 0));
    }

    public void filter(ContainerRequestContext incomingRequestContext, ContainerResponseContext outgoingResponseContext) throws IOException {
        String methodName = "filter(outgoing)";
        this.helper = OpentracingFilterHelperProvider.getInstance().getOpentracingFilterHelper();
        Boolean skipped = (Boolean)incomingRequestContext.getProperty(SERVER_SPAN_SKIPPED_ID);
        if (skipped != null) {
            incomingRequestContext.removeProperty(SERVER_SPAN_SKIPPED_ID);
        }
        if (skipped != null && skipped.booleanValue()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(methodName + " skipped"), (Object[])new Object[0]);
            }
            return;
        }
        ActiveSpan activeSpan = (ActiveSpan)incomingRequestContext.getProperty(SERVER_SPAN_PROP_ID);
        if (activeSpan == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(methodName + " no ActiveSpan"), (Object[])new Object[0]);
            }
            return;
        }
        incomingRequestContext.removeProperty(SERVER_SPAN_PROP_ID);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(methodName + " ActiveSpan"), (Object[])new Object[]{activeSpan});
        }
        Integer httpStatus = outgoingResponseContext.getStatus();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(methodName + " httpStatus"), (Object[])new Object[]{httpStatus});
        }
        Span span = activeSpan.getSpan();
        span.setTag(Tags.HTTP_STATUS.getKey(), (Number)httpStatus);
        if (outgoingResponseContext.getStatus() >= 400) {
            MultivaluedMap headers = outgoingResponseContext.getHeaders();
            Throwable exception = (Throwable)headers.getFirst((Object)EXCEPTION_KEY);
            if (exception != null) {
                headers.remove((Object)EXCEPTION_KEY);
            }
            OpentracingService.addSpanErrorInfo(span, exception);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(methodName + " finish span"), (Object[])new Object[]{span});
        }
        activeSpan.getScope().close();
        span.finish();
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class MultivaluedMapToTextMap
    implements TextMap {
        private final MultivaluedMap<String, String> mvMap;
        static final long serialVersionUID = -8828269829059110976L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Trivial
        public MultivaluedMapToTextMap(MultivaluedMap<String, String> mvMap) {
            this.mvMap = mvMap;
        }

        @Trivial
        public Iterator<Map.Entry<String, String>> iterator() {
            return new MultivaluedMapFlatIterator<String, String>(this.mvMap.entrySet());
        }

        @Trivial
        public void put(String key, String value) {
            throw new UnsupportedOperationException();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.opentracing.internal.OpentracingContainerFilter$MultivaluedMapToTextMap", MultivaluedMapToTextMap.class, (String)"OPENTRACING", (String)"io.openliberty.opentracing.internal.resources.Opentracing");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class MultivaluedMapFlatIterator<K, V>
    implements Iterator<Map.Entry<K, V>> {
        private final Iterator<Map.Entry<K, List<V>>> mapIterator;
        private Map.Entry<K, List<V>> mapEntry;
        private Iterator<V> mapEntryIterator;
        static final long serialVersionUID = -5922066363815083626L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Trivial
        public MultivaluedMapFlatIterator(Set<Map.Entry<K, List<V>>> multiValuesEntrySet) {
            this.mapIterator = multiValuesEntrySet.iterator();
            this.mapEntry = null;
            this.mapEntryIterator = null;
        }

        @Override
        @Trivial
        public boolean hasNext() {
            return this.mapEntryIterator != null && this.mapEntryIterator.hasNext() || this.mapIterator.hasNext();
        }

        @Override
        @Trivial
        public Map.Entry<K, V> next() {
            if (this.mapEntry == null || !this.mapEntryIterator.hasNext() && this.mapIterator.hasNext()) {
                this.mapEntry = this.mapIterator.next();
                this.mapEntryIterator = this.mapEntry.getValue().iterator();
            }
            if (this.mapEntryIterator.hasNext()) {
                return new AbstractMap.SimpleImmutableEntry<K, V>(this.mapEntry.getKey(), this.mapEntryIterator.next());
            }
            return new AbstractMap.SimpleImmutableEntry<K, Object>(this.mapEntry.getKey(), null);
        }

        @Override
        @Trivial
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.opentracing.internal.OpentracingContainerFilter$MultivaluedMapFlatIterator", MultivaluedMapFlatIterator.class, (String)"OPENTRACING", (String)"io.openliberty.opentracing.internal.resources.Opentracing");
        }
    }
}

