/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.configuration.jsse;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.jsse.TLSParameterBase;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
public class TLSClientParameters
extends TLSParameterBase {
    private boolean disableCNCheck;
    private SSLSocketFactory sslSocketFactory;
    private int sslCacheTimeout;
    private boolean useHttpsURLConnectionDefaultSslSocketFactory;
    private boolean useHttpsURLConnectionDefaultHostnameVerifier;
    private HostnameVerifier hostnameVerifier;
    private SSLContext sslContext;
    private boolean jaxrsClient;
    private static final Logger LOG = LogUtils.getL7dLogger(TLSClientParameters.class);
    static final long serialVersionUID = -7375883324900110947L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public TLSClientParameters() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.configuration.jsse.TLSClientParameters", "<init>", new Object[0]);
        }
        this.sslCacheTimeout = 86400;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.configuration.jsse.TLSClientParameters", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setHostnameVerifier(HostnameVerifier verifier) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.configuration.jsse.TLSClientParameters", "setHostnameVerifier", new Object[]{verifier});
        }
        this.hostnameVerifier = verifier;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.configuration.jsse.TLSClientParameters", "setHostnameVerifier");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public HostnameVerifier getHostnameVerifier() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.configuration.jsse.TLSClientParameters", "getHostnameVerifier", new Object[0]);
        }
        HostnameVerifier hostnameVerifier = this.hostnameVerifier;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            hostnameVerifier = hostnameVerifier;
            LOG.exiting("org.apache.cxf.configuration.jsse.TLSClientParameters", "getHostnameVerifier", hostnameVerifier);
        }
        return hostnameVerifier;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setDisableCNCheck(boolean disableCNCheck) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.configuration.jsse.TLSClientParameters", "setDisableCNCheck", new Object[]{disableCNCheck});
        }
        this.disableCNCheck = disableCNCheck;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.configuration.jsse.TLSClientParameters", "setDisableCNCheck");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isDisableCNCheck() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.configuration.jsse.TLSClientParameters", "isDisableCNCheck", new Object[0]);
        }
        boolean bl = this.disableCNCheck;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.configuration.jsse.TLSClientParameters", "isDisableCNCheck", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public final void setSSLSocketFactory(SSLSocketFactory factory) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.configuration.jsse.TLSClientParameters", "setSSLSocketFactory", new Object[]{factory});
        }
        this.sslSocketFactory = factory;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.configuration.jsse.TLSClientParameters", "setSSLSocketFactory");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public final SSLSocketFactory getSSLSocketFactory() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.configuration.jsse.TLSClientParameters", "getSSLSocketFactory", new Object[0]);
        }
        SSLSocketFactory sSLSocketFactory = this.sslSocketFactory;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            sSLSocketFactory = sSLSocketFactory;
            LOG.exiting("org.apache.cxf.configuration.jsse.TLSClientParameters", "getSSLSocketFactory", sSLSocketFactory);
        }
        return sSLSocketFactory;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public int getSslCacheTimeout() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.configuration.jsse.TLSClientParameters", "getSslCacheTimeout", new Object[0]);
        }
        int n = this.sslCacheTimeout;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            n = n;
            LOG.exiting("org.apache.cxf.configuration.jsse.TLSClientParameters", "getSslCacheTimeout", n);
        }
        return n;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setSslCacheTimeout(int sslCacheTimeout) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.configuration.jsse.TLSClientParameters", "setSslCacheTimeout", new Object[]{sslCacheTimeout});
        }
        this.sslCacheTimeout = sslCacheTimeout;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.configuration.jsse.TLSClientParameters", "setSslCacheTimeout");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isUseHttpsURLConnectionDefaultSslSocketFactory() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.configuration.jsse.TLSClientParameters", "isUseHttpsURLConnectionDefaultSslSocketFactory", new Object[0]);
        }
        boolean bl = this.useHttpsURLConnectionDefaultSslSocketFactory;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.configuration.jsse.TLSClientParameters", "isUseHttpsURLConnectionDefaultSslSocketFactory", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setUseHttpsURLConnectionDefaultSslSocketFactory(boolean useHttpsURLConnectionDefaultSslSocketFactory) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.configuration.jsse.TLSClientParameters", "setUseHttpsURLConnectionDefaultSslSocketFactory", new Object[]{useHttpsURLConnectionDefaultSslSocketFactory});
        }
        this.useHttpsURLConnectionDefaultSslSocketFactory = useHttpsURLConnectionDefaultSslSocketFactory;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.configuration.jsse.TLSClientParameters", "setUseHttpsURLConnectionDefaultSslSocketFactory");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isUseHttpsURLConnectionDefaultHostnameVerifier() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.configuration.jsse.TLSClientParameters", "isUseHttpsURLConnectionDefaultHostnameVerifier", new Object[0]);
        }
        boolean bl = this.useHttpsURLConnectionDefaultHostnameVerifier;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.configuration.jsse.TLSClientParameters", "isUseHttpsURLConnectionDefaultHostnameVerifier", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setUseHttpsURLConnectionDefaultHostnameVerifier(boolean useHttpsURLConnectionDefaultHostnameVerifier) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.configuration.jsse.TLSClientParameters", "setUseHttpsURLConnectionDefaultHostnameVerifier", new Object[]{useHttpsURLConnectionDefaultHostnameVerifier});
        }
        this.useHttpsURLConnectionDefaultHostnameVerifier = useHttpsURLConnectionDefaultHostnameVerifier;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.configuration.jsse.TLSClientParameters", "setUseHttpsURLConnectionDefaultHostnameVerifier");
        }
    }

    public int hashCode() {
        int hash;
        int n = hash = this.disableCNCheck ? 37 : 17;
        if (this.sslSocketFactory != null) {
            hash = hash * 41 + System.identityHashCode(this.sslSocketFactory);
        }
        if (this.sslContext != null) {
            hash = hash * 41 + System.identityHashCode(this.sslContext);
        }
        hash = this.hash(hash, this.useHttpsURLConnectionDefaultSslSocketFactory);
        hash = this.hash(hash, this.useHttpsURLConnectionDefaultHostnameVerifier);
        hash = this.hash(hash, this.sslCacheTimeout);
        hash = this.hash(hash, this.secureRandom);
        hash = this.hash(hash, this.protocol);
        hash = this.hash(hash, this.certAlias);
        hash = this.hash(hash, this.provider);
        for (String cs : this.ciphersuites) {
            hash = this.hash(hash, cs);
        }
        hash = this.hash(hash, this.keyManagers);
        hash = this.hash(hash, this.trustManagers);
        if (this.cipherSuiteFilters != null) {
            hash = this.hash(hash, this.cipherSuiteFilters.getInclude());
            hash = this.hash(hash, this.cipherSuiteFilters.getExclude());
        }
        if (this.certConstraints != null) {
            hash = this.hash(hash, this.certConstraints.getIssuerDNConstraints());
            hash = this.hash(hash, this.certConstraints.getSubjectDNConstraints());
        }
        return hash;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private int hash(int i, Object o) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.configuration.jsse.TLSClientParameters", "hash", new Object[]{i, o});
        }
        if (o != null) {
            int n = i * 37 + o.hashCode();
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                n = n;
                LOG.exiting("org.apache.cxf.configuration.jsse.TLSClientParameters", "hash", n);
            }
            return n;
        }
        int n = i;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            n = n;
            LOG.exiting("org.apache.cxf.configuration.jsse.TLSClientParameters", "hash", n);
        }
        return n;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private int hash(int i, Object[] os) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.configuration.jsse.TLSClientParameters", "hash", new Object[]{i, os});
        }
        if (os == null) {
            int n = i;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                n = n;
                LOG.exiting("org.apache.cxf.configuration.jsse.TLSClientParameters", "hash", n);
            }
            return n;
        }
        for (Object o : os) {
            i = this.hash(i, o);
        }
        int n = i;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            n = n;
            LOG.exiting("org.apache.cxf.configuration.jsse.TLSClientParameters", "hash", n);
        }
        return n;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean equals(Object o) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.configuration.jsse.TLSClientParameters", "equals", new Object[]{o});
        }
        if (o == this) {
            boolean bl = true;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.configuration.jsse.TLSClientParameters", "equals", bl);
            }
            return bl;
        }
        if (o instanceof TLSClientParameters) {
            TLSClientParameters that = (TLSClientParameters)o;
            boolean eq = this.disableCNCheck == that.disableCNCheck;
            eq &= this.sslSocketFactory == that.sslSocketFactory;
            eq &= this.sslContext == that.sslContext;
            eq &= this.useHttpsURLConnectionDefaultSslSocketFactory == that.useHttpsURLConnectionDefaultSslSocketFactory;
            eq &= this.useHttpsURLConnectionDefaultHostnameVerifier == that.useHttpsURLConnectionDefaultHostnameVerifier;
            eq &= this.sslCacheTimeout == that.sslCacheTimeout;
            eq &= this.secureRandom == that.secureRandom;
            eq &= Objects.equals(this.certAlias, that.certAlias);
            eq &= Objects.equals(this.protocol, that.protocol);
            eq &= Objects.equals(this.provider, that.provider);
            eq &= TLSClientParameters.equals(this.ciphersuites, that.ciphersuites);
            eq &= Objects.deepEquals(this.keyManagers, that.keyManagers);
            eq &= Objects.deepEquals(this.trustManagers, that.trustManagers);
            if (this.cipherSuiteFilters != null) {
                if (that.cipherSuiteFilters != null) {
                    eq &= TLSClientParameters.equals(this.cipherSuiteFilters.getExclude(), that.cipherSuiteFilters.getExclude());
                    eq &= TLSClientParameters.equals(this.cipherSuiteFilters.getInclude(), that.cipherSuiteFilters.getInclude());
                } else {
                    eq = false;
                }
            } else {
                eq &= that.cipherSuiteFilters == null;
            }
            if (this.certConstraints != null) {
                if (that.certConstraints != null) {
                    eq &= Objects.equals(this.certConstraints.getIssuerDNConstraints(), that.certConstraints.getIssuerDNConstraints());
                    eq &= Objects.equals(this.certConstraints.getSubjectDNConstraints(), that.certConstraints.getSubjectDNConstraints());
                } else {
                    eq = false;
                }
            } else {
                eq &= that.certConstraints == null;
            }
            boolean bl = eq;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.configuration.jsse.TLSClientParameters", "equals", bl);
            }
            return bl;
        }
        boolean bl = false;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.configuration.jsse.TLSClientParameters", "equals", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static boolean equals(List<?> obj1, List<?> obj2) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.configuration.jsse.TLSClientParameters", "equals", new Object[]{obj1, obj2});
        }
        boolean bl = obj1.equals(obj2);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.configuration.jsse.TLSClientParameters", "equals", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public SSLContext getSslContext() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.configuration.jsse.TLSClientParameters", "getSslContext", new Object[0]);
        }
        SSLContext sSLContext = this.sslContext;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            sSLContext = sSLContext;
            LOG.exiting("org.apache.cxf.configuration.jsse.TLSClientParameters", "getSslContext", sSLContext);
        }
        return sSLContext;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setSslContext(SSLContext sslContext) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.configuration.jsse.TLSClientParameters", "setSslContext", new Object[]{sslContext});
        }
        this.sslContext = sslContext;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.configuration.jsse.TLSClientParameters", "setSslContext");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setJaxRsClient(boolean jaxrsClient) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.configuration.jsse.TLSClientParameters", "setJaxRsClient", new Object[]{jaxrsClient});
        }
        this.jaxrsClient = jaxrsClient;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.configuration.jsse.TLSClientParameters", "setJaxRsClient");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isJaxrsClient() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.configuration.jsse.TLSClientParameters", "isJaxrsClient", new Object[0]);
        }
        boolean bl = this.jaxrsClient;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.configuration.jsse.TLSClientParameters", "isJaxrsClient", bl);
        }
        return bl;
    }
}

