/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.mfp.IntAble;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public enum JmsBodyType implements IntAble
{
    NULL(0, "JMS:"),
    BYTES(1, "JMS:bytes"),
    MAP(2, "JMS:map"),
    OBJECT(3, "JMS:object"),
    STREAM(4, "JMS:stream"),
    TEXT(5, "JMS:text");

    private static final TraceComponent tc;
    public static final int NULL_INT = 0;
    public static final int BYTES_INT = 1;
    public static final int MAP_INT = 2;
    public static final int OBJECT_INT = 3;
    public static final int STREAM_INT = 4;
    public static final int TEXT_INT = 5;
    private static final Map<Integer, JmsBodyType> types;
    private static final Map<String, JmsBodyType> typesByFormat;
    private final String format;
    private final Byte value;
    private final int intValue;

    private JmsBodyType(int aValue, String sdoFormat) {
        this.format = sdoFormat;
        this.value = (byte)aValue;
        this.intValue = aValue;
    }

    public static JmsBodyType getBodyType(String format) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getBodyType");
        }
        JmsBodyType result = typesByFormat.get(format);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getBodyType", (Object)result);
        }
        return result;
    }

    public static final JmsBodyType getJmsBodyType(Byte aValue) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Value = " + aValue));
        }
        return types.get(aValue.intValue());
    }

    public static final JmsBodyType getJmsBodyType(int aValue) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Value = " + aValue));
        }
        return types.get(aValue);
    }

    public final Byte toByte() {
        return this.value;
    }

    @Override
    public final int toInt() {
        return this.intValue;
    }

    static {
        tc = SibTr.register(JmsBodyType.class, (String)"SIBMfp", (String)"com.ibm.ws.sib.mfp.CWSIFMessages");
        HashMap<Integer, JmsBodyType> map = new HashMap<Integer, JmsBodyType>();
        HashMap<String, JmsBodyType> formatMap = new HashMap<String, JmsBodyType>();
        for (JmsBodyType type : JmsBodyType.values()) {
            map.put(type.toInt(), type);
            formatMap.put(type.format, type);
        }
        types = Collections.unmodifiableMap(map);
        typesByFormat = Collections.unmodifiableMap(formatMap);
    }
}

