/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.ws.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class StringUtils {
    public static final String EbcdicCharsetName = "IBM-1047";
    static final long serialVersionUID = -691404484861910413L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    /*
     * WARNING - void declaration
     */
    public static byte[] getEbcdicBytes(String s) {
        try {
            return s != null ? s.getBytes(EbcdicCharsetName) : new byte[]{};
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            void uee;
            FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.jbatch.container.ws.impl.StringUtils", (String)"39", null, (Object[])new Object[]{s});
            throw new RuntimeException((Throwable)uee);
        }
    }

    public static boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static String exceptionToString(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public static String enquote(String str) {
        return "\"" + str + "\"";
    }

    public static String trimQuotes(String str) {
        return StringUtils.trimSuffix(StringUtils.trimPrefix(str, "\""), "\"");
    }

    public static String trimPrefix(String str, String prefix) {
        return str.startsWith(prefix) ? str.substring(prefix.length()) : str;
    }

    public static String trimSuffixes(String str, String ... suffixes) {
        String retMe = str;
        for (String suffix : StringUtils.nullSafeIterable(suffixes)) {
            retMe = StringUtils.trimSuffix(retMe, suffix);
        }
        return retMe;
    }

    public static String trimSuffix(String str, String suffix) {
        return str.endsWith(suffix) ? str.substring(0, str.length() - suffix.length()) : str;
    }

    public static String join(Collection<String> strs, String delim) {
        StringBuilder sb = new StringBuilder();
        String d = "";
        for (String str : StringUtils.nullSafeIterable(strs)) {
            sb.append(d).append(str);
            d = delim;
        }
        return sb.toString();
    }

    public static String platformPath(String ... path) {
        return StringUtils.join(Arrays.asList(path), File.separator);
    }

    public static String normalizePath(String path) {
        return path != null ? path.replaceAll("\\\\", "/") : path;
    }

    public static <T> Iterable<T> nullSafeIterable(Iterable<T> iterable) {
        return iterable != null ? iterable : Collections.EMPTY_LIST;
    }

    public static <T> Iterable<T> nullSafeIterable(T[] iterable) {
        return iterable != null ? Arrays.asList(iterable) : Collections.EMPTY_LIST;
    }

    public static <T> T firstNonNull(T ... vals) {
        for (T val : vals) {
            if (val == null) continue;
            return val;
        }
        return null;
    }

    public static String firstNonEmpty(String ... vals) {
        for (String val : vals) {
            if (StringUtils.isEmpty(val)) continue;
            return val;
        }
        return null;
    }

    public static boolean areEqual(String s1, String s2) {
        return s1 == null ? s2 == null : s1.equals(s2);
    }

    public static boolean areEqual(List<String> strs) {
        if (strs == null || strs.isEmpty()) {
            return true;
        }
        String compareStr = strs.get(0);
        for (String str : strs) {
            if (StringUtils.areEqual(compareStr, str)) continue;
            return false;
        }
        return true;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.ws.impl.StringUtils", StringUtils.class, null, null);
    }
}

