/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.artifact.file.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.artifact.file.ContainerFactoryHolder;
import com.ibm.ws.artifact.file.internal.FileContainer;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.artifact.ArtifactContainer;
import com.ibm.wsspi.artifact.ArtifactEntry;
import com.ibm.wsspi.kernel.service.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class FileEntry
implements ArtifactEntry {
    private final ContainerFactoryHolder containerFactoryHolder;
    private final ArtifactContainer enclosingContainer;
    private final File file;
    private final FileContainer root;
    private final String fileName;
    static final long serialVersionUID = -4511425145123353606L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    FileEntry(ArtifactContainer e, File f, FileContainer r, ContainerFactoryHolder c) {
        this.file = f;
        this.fileName = this.file.getName();
        this.enclosingContainer = e;
        if (this.enclosingContainer == null) {
            throw new IllegalArgumentException("Null enclosing container");
        }
        this.containerFactoryHolder = c;
        this.root = r;
    }

    public ArtifactContainer getEnclosingContainer() {
        return this.enclosingContainer;
    }

    public String getPath() {
        String path = this.enclosingContainer.getPath();
        int pathLength = path.length();
        StringBuilder pathBuilder = new StringBuilder(pathLength + this.fileName.length() + 1);
        pathBuilder.append(path);
        if (pathLength != 1 || !path.equals("/")) {
            pathBuilder.append('/');
        }
        pathBuilder.append(this.fileName);
        return pathBuilder.toString();
    }

    public String getName() {
        return this.fileName;
    }

    public ArtifactContainer convertToContainer() {
        return this.convertToContainer(false);
    }

    public ArtifactContainer convertToContainer(boolean localOnly) {
        ArtifactContainer rv = null;
        if (FileUtils.fileIsDirectory((File)this.file)) {
            File newCacheDir = null;
            String relativeLocation = this.enclosingContainer.getPath();
            newCacheDir = relativeLocation.equals("/") ? this.root.getCacheDir() : new File(this.root.getCacheDir(), relativeLocation.substring(1));
            rv = new FileContainer(newCacheDir, this.enclosingContainer, this, this.file, this.containerFactoryHolder, false, this.root);
        } else if (!localOnly) {
            rv = this.containerFactoryHolder.getContainerFactory().getContainer(new File(this.root.getCacheDir(), this.enclosingContainer.getPath()), this.enclosingContainer, (ArtifactEntry)this, (Object)this.file);
        }
        return rv;
    }

    public InputStream getInputStream() throws IOException {
        if (FileUtils.fileIsFile((File)this.file)) {
            return FileUtils.getInputStream((File)this.file);
        }
        return null;
    }

    public long getSize() {
        if (FileUtils.fileIsFile((File)this.file) && FileUtils.fileExists((File)this.file)) {
            return FileUtils.fileLength((File)this.file);
        }
        return 0L;
    }

    public ArtifactContainer getRoot() {
        return this.root;
    }

    public long getLastModified() {
        return AccessController.doPrivileged(new PrivilegedAction<Long>(){
            static final long serialVersionUID = 7525047461408357674L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Long run() {
                return FileEntry.this.file.lastModified();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.artifact.file.internal.FileEntry$1", 1.class, (String)"archive.artifact.file", null);
            }
        });
    }

    @FFDCIgnore(value={PrivilegedActionException.class})
    public URL getResource() {
        try {
            URL url = (URL)AccessController.doPrivileged(new PrivilegedExceptionAction(){
                static final long serialVersionUID = -3968669842503285214L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                public URL run() throws MalformedURLException {
                    return FileEntry.this.file.toURI().toURL();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.artifact.file.internal.FileEntry$2", 2.class, (String)"archive.artifact.file", null);
                }
            });
            return url;
        }
        catch (PrivilegedActionException e) {
            return null;
        }
    }

    public String getPhysicalPath() {
        return this.file.getAbsolutePath();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.artifact.file.internal.FileEntry", FileEntry.class, (String)"archive.artifact.file", null);
    }
}

