/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.translator.visitor.tagfilescan;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.jsp.JspCoreException;
import com.ibm.ws.jsp.configuration.JspConfiguration;
import com.ibm.ws.jsp.taglib.TagFileTagInfo;
import com.ibm.ws.jsp.taglib.TagLibraryInfoImpl;
import com.ibm.ws.jsp.translator.JspTranslationException;
import com.ibm.ws.jsp.translator.utils.JspId;
import com.ibm.ws.jsp.translator.utils.JspTranslatorUtil;
import com.ibm.ws.jsp.translator.utils.NameMangler;
import com.ibm.ws.jsp.translator.visitor.JspVisitor;
import com.ibm.ws.jsp.translator.visitor.JspVisitorInputMap;
import com.ibm.ws.jsp.translator.visitor.JspVisitorResult;
import com.ibm.ws.jsp.translator.visitor.configuration.JspVisitorUsage;
import com.ibm.ws.jsp.translator.visitor.tagfilescan.TagFileScanResult;
import com.ibm.wsspi.jsp.context.JspCoreContext;
import jakarta.el.MethodExpression;
import jakarta.el.ValueExpression;
import jakarta.servlet.jsp.tagext.TagAttributeInfo;
import jakarta.servlet.jsp.tagext.TagExtraInfo;
import jakarta.servlet.jsp.tagext.TagVariableInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Element;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
public class TagFileScanVisitor
extends JspVisitor {
    private static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.translator.visitor.tagfilescan.TagFileScanVisitor";
    private TagLibraryInfoImpl tli;
    private String tagFilePath;
    private String name;
    private String tagclass;
    private TagExtraInfo tei;
    private String bodycontent;
    private String description;
    private String displayName;
    private String smallIcon;
    private String largeIcon;
    private String dynamicAttributes;
    private boolean bodyContentIsDefault;
    private ArrayList attributes;
    private ArrayList variables;
    private HashMap tagFileUniqueNameGivenVariableNames;
    private HashMap tagFileUniqueNameFromAttributeVariableNames;
    static final long serialVersionUID = -4845370690996941758L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public TagFileScanVisitor(JspVisitorUsage visitorUsage, JspConfiguration jspConfiguration, JspCoreContext context, HashMap resultMap, JspVisitorInputMap inputMap) throws JspCoreException {
        super(visitorUsage, jspConfiguration, context, resultMap, inputMap);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "<init>", new Object[]{visitorUsage, jspConfiguration, context, resultMap, inputMap});
        }
        this.tli = null;
        this.tagFilePath = null;
        this.name = null;
        this.tagclass = null;
        this.tei = null;
        this.bodycontent = "scriptless";
        this.description = null;
        this.displayName = null;
        this.smallIcon = null;
        this.largeIcon = null;
        this.dynamicAttributes = null;
        this.bodyContentIsDefault = true;
        this.attributes = new ArrayList();
        this.variables = new ArrayList();
        this.tagFileUniqueNameGivenVariableNames = new HashMap(19);
        this.tagFileUniqueNameFromAttributeVariableNames = new HashMap(19);
        this.displayName = this.name = (String)inputMap.get("TagFileName");
        this.tli = (TagLibraryInfoImpl)((Object)inputMap.get("TagLibraryInfo"));
        this.tagFilePath = (String)inputMap.get("TagFilePath");
        String className = this.tagFilePath.substring(this.tagFilePath.lastIndexOf(47) + 1);
        className = className.substring(0, className.indexOf(".tag"));
        className = NameMangler.mangleClassName(className);
        String dirName = this.tagFilePath.substring(0, this.tagFilePath.lastIndexOf(47));
        if (dirName.startsWith("/WEB-INF/tags")) {
            dirName = dirName.substring(dirName.indexOf("/WEB-INF/tags") + 13);
        } else if (dirName.startsWith("/META-INF/tags")) {
            dirName = dirName.substring(dirName.indexOf("/META-INF/tags") + 14);
        }
        if (dirName.indexOf("-") > -1 && !(dirName = NameMangler.handlePackageName(dirName)).startsWith(".")) {
            dirName = "." + dirName;
        }
        dirName = dirName.replace('/', '.');
        this.tagclass = "com.ibm.ws.jsp.tagfile." + this.tli.getOriginatorId() + dirName + "." + className;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "<init>", this);
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JspVisitorResult getResult() throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getResult", new Object[0]);
        }
        for (String nameFrom : this.tagFileUniqueNameFromAttributeVariableNames.keySet()) {
            Element nameEntry = (Element)this.tagFileUniqueNameGivenVariableNames.get(nameFrom);
            Element nameFromEntry = (Element)this.tagFileUniqueNameFromAttributeVariableNames.get(nameFrom);
            if (nameEntry == null) {
                throw new JspTranslationException(nameFromEntry, "jsp.error.tagfile.nameFrom.noAttribute", new Object[]{nameFrom});
            }
            Attr typeAttr = nameEntry.getAttributeNode("type");
            String type = "java.lang.String";
            if (typeAttr != null) {
                type = typeAttr.getValue();
            }
            Attr requiredAttr = nameEntry.getAttributeNode("required");
            boolean required = false;
            if (requiredAttr != null) {
                required = JspTranslatorUtil.booleanValue(requiredAttr.getValue());
            }
            Attr rtexprvalueAttr = nameEntry.getAttributeNode("rtexprvalue");
            boolean rtexprvalue = true;
            if (rtexprvalueAttr != null) {
                rtexprvalue = JspTranslatorUtil.booleanValue(rtexprvalueAttr.getValue());
            }
            if ("java.lang.String".equals(type) && required && !rtexprvalue) continue;
            String jspIdString = nameEntry.getAttributeNS("http://java.sun.com/JSP/Page", "id");
            JspId jspId = null;
            String lineNum = "unknown";
            if (!jspIdString.equals("")) {
                jspId = new JspId(jspIdString);
                lineNum = String.valueOf(jspId.getStartSourceLineNum());
            }
            throw new JspTranslationException(nameFromEntry, "jsp.error.tagfile.nameFrom.badAttribute", new Object[]{lineNum, nameFrom});
        }
        TagVariableInfo[] tagVariableInfos = new TagVariableInfo[this.variables.size()];
        tagVariableInfos = this.variables.toArray(tagVariableInfos);
        TagAttributeInfo[] tagAttributeInfo = new TagAttributeInfo[this.attributes.size()];
        tagAttributeInfo = this.attributes.toArray(tagAttributeInfo);
        TagFileTagInfo ti = new TagFileTagInfo(this.name, this.tagclass, this.bodycontent, this.description, this.tli, this.tei, tagAttributeInfo, this.displayName, this.smallIcon, this.largeIcon, tagVariableInfos, this.dynamicAttributes);
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, CLASS_NAME, "getResult", "About to call setTagInfo(ti), ti =[\n" + (Object)((Object)ti) + "]");
        }
        TagFileScanResult result = new TagFileScanResult(this.visitorUsage.getJspVisitorDefinition().getId());
        result.setTagInfo(ti);
        TagFileScanResult tagFileScanResult = result;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            tagFileScanResult = tagFileScanResult;
            logger.exiting(CLASS_NAME, "getResult", tagFileScanResult);
        }
        return tagFileScanResult;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitTagDirectiveStart(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitTagDirectiveStart", new Object[]{jspElement});
        }
        if (this.bodyContentIsDefault) {
            String newbodycontent = this.checkConflict(jspElement, null, "body-content");
            if (newbodycontent != null) {
                this.bodycontent = newbodycontent;
                this.bodyContentIsDefault = false;
            }
        } else {
            this.bodycontent = this.checkConflict(jspElement, this.bodycontent, "body-content");
        }
        if (this.bodycontent != null && this.jspConfiguration.getServletVersion().equals("2.5") && !this.bodycontent.equalsIgnoreCase("empty") && !this.bodycontent.equalsIgnoreCase("tagdependent") && !this.bodycontent.equalsIgnoreCase("scriptless")) {
            throw new JspTranslationException(jspElement, "jsp.error.tagdirective.badbodycontent", new Object[]{this.bodycontent});
        }
        Attr displayNameAttr = jspElement.getAttributeNode("display-name");
        if (displayNameAttr != null) {
            this.displayName = displayNameAttr.getValue();
        }
        this.dynamicAttributes = this.checkConflict(jspElement, this.dynamicAttributes, "dynamic-attributes");
        this.smallIcon = this.checkConflict(jspElement, this.smallIcon, "small-icon");
        this.largeIcon = this.checkConflict(jspElement, this.largeIcon, "large-icon");
        this.description = this.checkConflict(jspElement, this.description, "description");
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitTagDirectiveStart");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private String checkConflict(Element elem, String oldAttrValue, String attr) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "checkConflict", new Object[]{elem, oldAttrValue, attr});
        }
        String result = oldAttrValue;
        String attrValue = null;
        if (elem.getAttributeNode(attr) != null) {
            attrValue = elem.getAttributeNode(attr).getValue();
        }
        if (attrValue != null) {
            if (oldAttrValue != null && !oldAttrValue.equals(attrValue)) {
                throw new JspTranslationException(elem, "jsp.error.tag.conflict.attr", new Object[]{attr, oldAttrValue, attrValue});
            }
            result = attrValue;
        }
        String string = result;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting(CLASS_NAME, "checkConflict", string);
        }
        return string;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitAttributeDirectiveStart(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitAttributeDirectiveStart", new Object[]{jspElement});
        }
        Attr nameAttr = jspElement.getAttributeNode("name");
        Attr requiredAttr = jspElement.getAttributeNode("required");
        Attr fragmentAttr = jspElement.getAttributeNode("fragment");
        Attr rtexprvalueAttr = jspElement.getAttributeNode("rtexprvalue");
        Attr typeAttr = jspElement.getAttributeNode("type");
        Attr deferredValueAttr = jspElement.getAttributeNode("deferredValue");
        Attr deferredValueTypeAttr = jspElement.getAttributeNode("deferredValueType");
        Attr deferredMethodAttr = jspElement.getAttributeNode("deferredMethod");
        Attr deferredMethodSignatureAttr = jspElement.getAttributeNode("deferredMethodSignature");
        String name = "";
        boolean required = false;
        boolean fragment = false;
        boolean rtexprvalue = true;
        String type = null;
        boolean deferredValue = false;
        boolean deferredValueSpecified = false;
        String deferredValueString = null;
        if (deferredValueAttr != null) {
            deferredValueString = deferredValueAttr.getValue();
        }
        if (deferredValueString != null) {
            deferredValueSpecified = true;
            deferredValue = JspTranslatorUtil.booleanValue(deferredValueString);
        }
        String deferredValueType = null;
        if (deferredValueTypeAttr != null) {
            deferredValueType = deferredValueTypeAttr.getValue();
        }
        if (deferredValueType != null) {
            if (deferredValueSpecified && !deferredValue) {
                throw new JspTranslationException(jspElement, "jsp.error.deferredvaluetypewithoutdeferredvalue");
            }
            deferredValue = true;
        } else {
            deferredValueType = deferredValue ? "java.lang.Object" : "java.lang.String";
        }
        boolean deferredMethod = false;
        boolean deferredMethodSpecified = false;
        String deferredMethodString = null;
        if (deferredMethodAttr != null) {
            deferredMethodString = deferredMethodAttr.getValue();
        }
        if (deferredMethodString != null) {
            deferredMethodSpecified = true;
            deferredMethod = JspTranslatorUtil.booleanValue(deferredMethodString);
        }
        String deferredMethodSignature = null;
        if (deferredMethodSignatureAttr != null) {
            deferredMethodSignature = deferredMethodSignatureAttr.getValue();
        }
        if (deferredMethodSignature != null) {
            if (deferredMethodSpecified && !deferredMethod) {
                throw new JspTranslationException(jspElement, "jsp.error.deferredmethodsignaturewithoutdeferredmethod");
            }
            deferredMethod = true;
        } else if (deferredMethod) {
            deferredMethodSignature = "void methodname()";
        }
        if (deferredMethod && deferredValue) {
            throw new JspTranslationException(jspElement, "jsp.error.deferredmethodandvalue");
        }
        if (nameAttr != null) {
            name = nameAttr.getValue();
        }
        if (requiredAttr != null) {
            required = JspTranslatorUtil.booleanValue(requiredAttr.getValue());
        }
        if (fragmentAttr != null) {
            fragment = JspTranslatorUtil.booleanValue(fragmentAttr.getValue());
        }
        if (typeAttr != null) {
            type = typeAttr.getValue();
        }
        if (rtexprvalueAttr != null) {
            rtexprvalue = JspTranslatorUtil.booleanValue(rtexprvalueAttr.getValue());
        }
        if (fragment) {
            if (type != null) {
                throw new JspTranslationException(jspElement, "jsp.error.illegal.fragment.and.type", new Object[]{typeAttr.getValue()});
            }
            rtexprvalue = true;
            if (rtexprvalueAttr != null) {
                throw new JspTranslationException(jspElement, "jsp.error.illegal.fragment.and.rtexprvalue", new Object[]{rtexprvalueAttr.getValue()});
            }
        } else {
            if (type == null) {
                type = "java.lang.String";
            } else {
                try {
                    if (this.isPrimitive(type)) {
                        throw new JspTranslationException(jspElement, "jsp.error.illegal.type.primitive", new Object[]{type});
                    }
                    Class clazz = JspTranslatorUtil.toClass(type, this.context.getJspClassloaderContext().getClassLoader());
                }
                catch (ClassNotFoundException cnfe) {
                    throw new JspTranslationException(jspElement, "jsp.error.tagfile.cannot.locate.class.to.validate.primitive", new Object[]{type}, cnfe);
                }
            }
            if (deferredValue) {
                type = ValueExpression.class.getName();
            } else if (deferredMethod) {
                type = MethodExpression.class.getName();
            }
        }
        if (("2.0".equals(this.tli.getRequiredVersion()) || "1.2".equals(this.tli.getRequiredVersion())) && (deferredMethodSpecified || deferredMethod || deferredValueSpecified || deferredValue)) {
            throw new JspTranslationException(jspElement, "jsp.error.invalid.version", new Object[]{this.tagFilePath});
        }
        TagAttributeInfo tai = new TagAttributeInfo(name, required, type, rtexprvalue, fragment, null, deferredValue, deferredMethod, deferredValueType, deferredMethodSignature);
        this.attributes.add(tai);
        this.checkValidTagName(jspElement, this.tagFileUniqueNameGivenVariableNames, name);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitAttributeDirectiveStart");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean isPrimitive(String classType) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "isPrimitive", new Object[]{classType});
        }
        classType = classType.trim();
        boolean primitive = false;
        String[] primitiveList = new String[]{"boolean", "byte", "char", "short", "int", "long", "float", "double"};
        for (int i = 0; i < primitiveList.length; ++i) {
            if (!classType.equals(primitiveList[i])) continue;
            boolean bl = true;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting(CLASS_NAME, "isPrimitive", bl);
            }
            return bl;
        }
        boolean bl = primitive;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting(CLASS_NAME, "isPrimitive", bl);
        }
        return bl;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitVariableDirectiveStart(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitVariableDirectiveStart", new Object[]{jspElement});
        }
        Attr nameGivenAttr = jspElement.getAttributeNode("name-given");
        Attr nameFromAttributeAttr = jspElement.getAttributeNode("name-from-attribute");
        Attr aliasAttr = jspElement.getAttributeNode("alias");
        Attr variableClassAttr = jspElement.getAttributeNode("variable-class");
        Attr declareAttr = jspElement.getAttributeNode("declare");
        Attr scopeAttr = jspElement.getAttributeNode("scope");
        String nameGiven = null;
        String nameFromAttribute = null;
        String variableClass = "java.lang.String";
        boolean declare = true;
        int scope = 0;
        if (nameGivenAttr != null) {
            nameGiven = nameGivenAttr.getValue();
        }
        if (nameFromAttributeAttr != null) {
            nameFromAttribute = nameFromAttributeAttr.getValue();
        }
        if (nameGivenAttr != null && nameFromAttributeAttr != null) {
            throw new JspTranslationException(jspElement, "variable.attribute.nameGiven.nameFromAttribute.not.both", new Object[]{jspElement.getTagName(), nameGiven, nameFromAttribute});
        }
        if (nameGivenAttr == null && nameFromAttributeAttr == null) {
            throw new JspTranslationException(jspElement, "missing.required.variable.attribute.nameGiven.nameFromAttribute", new Object[]{jspElement.getTagName()});
        }
        if (nameFromAttributeAttr != null && aliasAttr == null) {
            throw new JspTranslationException(jspElement, "required.attribute.alias.required.if.nameFromAttribute.specified", new Object[]{jspElement.getTagName(), nameFromAttribute});
        }
        if (nameGivenAttr != null && aliasAttr != null) {
            throw new JspTranslationException(jspElement, "attribute.alias.not.permitted.if.namegiven.specified", new Object[]{jspElement.getTagName(), nameGiven, aliasAttr.getValue()});
        }
        if (variableClassAttr != null) {
            variableClass = variableClassAttr.getValue();
        }
        if (declareAttr != null) {
            declare = JspTranslatorUtil.booleanValue(declareAttr.getValue());
        }
        if (scopeAttr != null) {
            scope = this.convertScopeToInt(jspElement, scopeAttr.getValue());
        }
        if (aliasAttr != null) {
            nameGiven = aliasAttr.getValue();
        }
        TagVariableInfo tvi = new TagVariableInfo(nameGiven, nameFromAttribute, variableClass, declare, scope);
        this.variables.add(tvi);
        if (nameGivenAttr != null) {
            this.checkValidTagName(jspElement, this.tagFileUniqueNameGivenVariableNames, nameGiven);
        } else {
            this.checkValidTagName(jspElement, this.tagFileUniqueNameFromAttributeVariableNames, nameFromAttribute);
            this.checkValidTagName(jspElement, this.tagFileUniqueNameGivenVariableNames, aliasAttr.getValue());
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitVariableDirectiveStart");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void checkValidTagName(Element jspElement, HashMap map, String name) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "checkValidTagName", new Object[]{jspElement, map, name});
        }
        Element priorElementObj = map.put(name, jspElement);
        if (priorElementObj != null) {
            Element priorElement = priorElementObj;
            throw new JspTranslationException(jspElement, "multiple.occurences.attribute.tagfile.name", new Object[]{jspElement.getTagName(), priorElement.getTagName(), name});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "checkValidTagName");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected int convertScopeToInt(Element jspElement, String scope) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "convertScopeToInt", new Object[]{jspElement, scope});
        }
        if (scope.equals("AT_BEGIN")) {
            int n = 1;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                n = n;
                logger.exiting(CLASS_NAME, "convertScopeToInt", n);
            }
            return n;
        }
        if (scope.equals("NESTED")) {
            int n = 0;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                n = n;
                logger.exiting(CLASS_NAME, "convertScopeToInt", n);
            }
            return n;
        }
        if (scope.equals("AT_END")) {
            int n = 2;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                n = n;
                logger.exiting(CLASS_NAME, "convertScopeToInt", n);
            }
            return n;
        }
        throw new JspTranslationException(jspElement, "invalid.value.for.variable.directive.attribute.scope", new Object[]{jspElement.getTagName(), scope});
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitJspRootStart(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitJspRootStart", new Object[]{jspElement});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitJspRootStart");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitJspRootEnd(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitJspRootEnd", new Object[]{jspElement});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitJspRootEnd");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitJspTextStart(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitJspTextStart", new Object[]{jspElement});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitJspTextStart");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitJspTextEnd(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitJspTextEnd", new Object[]{jspElement});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitJspTextEnd");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitIncludeDirectiveStart(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitIncludeDirectiveStart", new Object[]{jspElement});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitIncludeDirectiveStart");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitIncludeDirectiveEnd(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitIncludeDirectiveEnd", new Object[]{jspElement});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitIncludeDirectiveEnd");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitPageDirectiveStart(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitPageDirectiveStart", new Object[]{jspElement});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitPageDirectiveStart");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitPageDirectiveEnd(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitPageDirectiveEnd", new Object[]{jspElement});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitPageDirectiveEnd");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitTagDirectiveEnd(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitTagDirectiveEnd", new Object[]{jspElement});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitTagDirectiveEnd");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitAttributeDirectiveEnd(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitAttributeDirectiveEnd", new Object[]{jspElement});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitAttributeDirectiveEnd");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitVariableDirectiveEnd(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitVariableDirectiveEnd", new Object[]{jspElement});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitVariableDirectiveEnd");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitJspDeclarationStart(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitJspDeclarationStart", new Object[]{jspElement});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitJspDeclarationStart");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitJspDeclarationEnd(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitJspDeclarationEnd", new Object[]{jspElement});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitJspDeclarationEnd");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitJspExpressionStart(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitJspExpressionStart", new Object[]{jspElement});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitJspExpressionStart");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitJspExpressionEnd(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitJspExpressionEnd", new Object[]{jspElement});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitJspExpressionEnd");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitJspScriptletStart(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitJspScriptletStart", new Object[]{jspElement});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitJspScriptletStart");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitJspScriptletEnd(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitJspScriptletEnd", new Object[]{jspElement});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitJspScriptletEnd");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitJspParamStart(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitJspParamStart", new Object[]{jspElement});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitJspParamStart");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitJspParamEnd(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitJspParamEnd", new Object[]{jspElement});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitJspParamEnd");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitJspParamsStart(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitJspParamsStart", new Object[]{jspElement});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitJspParamsStart");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitJspParamsEnd(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitJspParamsEnd", new Object[]{jspElement});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitJspParamsEnd");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitJspFallbackStart(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitJspFallbackStart", new Object[]{jspElement});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitJspFallbackStart");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitJspFallbackEnd(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitJspFallbackEnd", new Object[]{jspElement});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitJspFallbackEnd");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitJspIncludeStart(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitJspIncludeStart", new Object[]{jspElement});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitJspIncludeStart");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitJspIncludeEnd(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitJspIncludeEnd", new Object[]{jspElement});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitJspIncludeEnd");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitJspForwardStart(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitJspForwardStart", new Object[]{jspElement});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitJspForwardStart");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitJspForwardEnd(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitJspForwardEnd", new Object[]{jspElement});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitJspForwardEnd");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitJspUseBeanStart(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitJspUseBeanStart", new Object[]{jspElement});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitJspUseBeanStart");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitJspUseBeanEnd(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitJspUseBeanEnd", new Object[]{jspElement});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitJspUseBeanEnd");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitJspGetPropertyStart(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitJspGetPropertyStart", new Object[]{jspElement});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitJspGetPropertyStart");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitJspGetPropertyEnd(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitJspGetPropertyEnd", new Object[]{jspElement});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitJspGetPropertyEnd");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitJspSetPropertyStart(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitJspSetPropertyStart", new Object[]{jspElement});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitJspSetPropertyStart");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitJspSetPropertyEnd(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitJspSetPropertyEnd", new Object[]{jspElement});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitJspSetPropertyEnd");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitJspPluginStart(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitJspPluginStart", new Object[]{jspElement});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitJspPluginStart");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitJspPluginEnd(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitJspPluginEnd", new Object[]{jspElement});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitJspPluginEnd");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitCustomTagStart(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitCustomTagStart", new Object[]{jspElement});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitCustomTagStart");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitCustomTagEnd(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitCustomTagEnd", new Object[]{jspElement});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitCustomTagEnd");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitJspAttributeStart(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitJspAttributeStart", new Object[]{jspElement});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitJspAttributeStart");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitJspAttributeEnd(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitJspAttributeEnd", new Object[]{jspElement});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitJspAttributeEnd");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitJspElementStart(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitJspElementStart", new Object[]{jspElement});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitJspElementStart");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitJspElementEnd(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitJspElementEnd", new Object[]{jspElement});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitJspElementEnd");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitJspBodyStart(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitJspBodyStart", new Object[]{jspElement});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitJspBodyStart");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitJspBodyEnd(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitJspBodyEnd", new Object[]{jspElement});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitJspBodyEnd");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitJspInvokeStart(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitJspInvokeStart", new Object[]{jspElement});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitJspInvokeStart");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitJspInvokeEnd(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitJspInvokeEnd", new Object[]{jspElement});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitJspInvokeEnd");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitJspDoBodyStart(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitJspDoBodyStart", new Object[]{jspElement});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitJspDoBodyStart");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitJspDoBodyEnd(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitJspDoBodyEnd", new Object[]{jspElement});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitJspDoBodyEnd");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitJspOutputStart(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitJspOutputStart", new Object[]{jspElement});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitJspOutputStart");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitJspOutputEnd(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitJspOutputEnd", new Object[]{jspElement});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitJspOutputEnd");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitUninterpretedTagStart(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitUninterpretedTagStart", new Object[]{jspElement});
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, CLASS_NAME, "visitUninterpretedTagStart", "jspElement =[" + jspElement + "]");
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitUninterpretedTagStart");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitUninterpretedTagEnd(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitUninterpretedTagEnd", new Object[]{jspElement});
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, CLASS_NAME, "visitUninterpretedTagEnd", "jspElement =[" + jspElement + "]");
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitUninterpretedTagEnd");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitCDataTag(CDATASection cdata) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitCDataTag", new Object[]{cdata});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitCDataTag");
        }
    }
}

