/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxws.ejb;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ejbcontainer.EJBEndpoint;
import com.ibm.ws.ejbcontainer.EJBEndpoints;
import com.ibm.ws.jaxws.ejb.EJBJaxWsModuleInfoBuilderHelper;
import com.ibm.ws.jaxws.metadata.EndpointInfo;
import com.ibm.ws.jaxws.metadata.EndpointType;
import com.ibm.ws.jaxws.metadata.JaxWsModuleInfo;
import com.ibm.ws.jaxws.metadata.JaxWsModuleType;
import com.ibm.ws.jaxws.metadata.JaxWsServerMetaData;
import com.ibm.ws.jaxws.metadata.builder.AbstractJaxWsModuleInfoBuilderExtension;
import com.ibm.ws.jaxws.metadata.builder.EndpointInfoBuilder;
import com.ibm.ws.jaxws.metadata.builder.EndpointInfoBuilderContext;
import com.ibm.ws.jaxws.metadata.builder.JaxWsModuleInfoBuilderContext;
import com.ibm.ws.jaxws.support.JaxWsMetaDataManager;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class EJBInWarJaxWsModuleInfoBuilderExtension
extends AbstractJaxWsModuleInfoBuilderExtension {
    private static final TraceComponent tc = Tr.register(EJBInWarJaxWsModuleInfoBuilderExtension.class, (String)"JaxWsEJB", (String)"com.ibm.ws.jaxws.ejb.internal.resources.JaxWsEJBMessages");
    protected final AtomicServiceReference<EndpointInfoBuilder> endpointInfoBuilderSRRef = new AtomicServiceReference("endpointInfoBuilder");
    static final long serialVersionUID = -4736897605035471924L;

    public EJBInWarJaxWsModuleInfoBuilderExtension() {
        super(new JaxWsModuleType[]{JaxWsModuleType.WEB});
    }

    public void preBuild(JaxWsModuleInfoBuilderContext jaxWsModuleInfoBuilderContext, JaxWsModuleInfo jaxWsModuleInfo) throws UnableToAdaptException {
        EndpointInfoBuilder endpointInfoBuilder = (EndpointInfoBuilder)this.endpointInfoBuilderSRRef.getService();
        if (endpointInfoBuilder == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Unable to locate EndpointInfoBuilder, EJB JaxWsModuleInfo builder will be skipped", (Object[])new Object[0]);
            }
            return;
        }
        EJBEndpoints ejbEndpoints = (EJBEndpoints)jaxWsModuleInfoBuilderContext.getContainer().adapt(EJBEndpoints.class);
        if (ejbEndpoints == null || ejbEndpoints.getEJBEndpoints().size() == 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No EJB Web Services is found", (Object[])new Object[0]);
            }
            return;
        }
        JaxWsServerMetaData jaxWsServerMetaData = JaxWsMetaDataManager.getJaxWsServerMetaData((ModuleMetaData)jaxWsModuleInfoBuilderContext.getModuleMetaData());
        EndpointInfoBuilderContext endpointInfoBuilderContext = jaxWsModuleInfoBuilderContext.getEndpointInfoBuilderContext();
        Map servletNameClassPairs = (Map)jaxWsModuleInfoBuilderContext.getContextEnv("servletNameClassPairsForEJBsInWAR");
        HashMap<String, EJBEndpoint> ejbWSBeanInWebXML = new HashMap<String, EJBEndpoint>();
        ArrayList<EJBEndpoint> ejbEndpointList = new ArrayList<EJBEndpoint>();
        ejbEndpointList.addAll(ejbEndpoints.getEJBEndpoints());
        if (servletNameClassPairs != null && !servletNameClassPairs.isEmpty()) {
            Iterator it = ejbEndpointList.iterator();
            while (it.hasNext()) {
                EJBEndpoint ejbEndpoint = (EJBEndpoint)it.next();
                if (!servletNameClassPairs.containsValue(ejbEndpoint.getClassName())) continue;
                ejbWSBeanInWebXML.put(ejbEndpoint.getClassName(), ejbEndpoint);
                it.remove();
            }
        }
        EJBJaxWsModuleInfoBuilderHelper.buildEjbWebServiceEndpointInfos(endpointInfoBuilder, endpointInfoBuilderContext, jaxWsServerMetaData, ejbEndpointList, jaxWsModuleInfo);
        Set presentedServices = jaxWsModuleInfo.getEndpointImplBeanClassNames();
        if (servletNameClassPairs != null && !servletNameClassPairs.isEmpty()) {
            for (Map.Entry entry : servletNameClassPairs.entrySet()) {
                EJBEndpoint ejbEndpoint;
                String servletName = (String)entry.getKey();
                String servletClassName = (String)entry.getValue();
                if (presentedServices.contains(servletClassName) || !ejbWSBeanInWebXML.containsKey(servletClassName) || !(ejbEndpoint = (EJBEndpoint)ejbWSBeanInWebXML.get(servletClassName)).isWebService()) continue;
                String ejbName = ejbEndpoint.getJ2EEName().getComponent();
                endpointInfoBuilderContext.addContextEnv("endpointBeanNameInEnv", (Object)ejbName);
                endpointInfoBuilderContext.addContextEnv("endpointServletNameInEnv", (Object)servletName);
                EndpointInfo endpointInfo = endpointInfoBuilder.build(endpointInfoBuilderContext, servletClassName, EndpointType.EJB);
                if (endpointInfo == null) continue;
                jaxWsModuleInfo.addEndpointInfo(servletName, endpointInfo);
                jaxWsServerMetaData.putEndpointNameAndJ2EENameEntry(servletName, ejbEndpoint.getJ2EEName());
            }
        }
    }

    public void postBuild(JaxWsModuleInfoBuilderContext jaxWsModuleInfoBuilderContext, JaxWsModuleInfo jaxWsModuleInfo) throws UnableToAdaptException {
    }

    protected void setEndpointInfoBuilder(ServiceReference<EndpointInfoBuilder> ref) {
        this.endpointInfoBuilderSRRef.setReference(ref);
    }

    protected void unsetEndpointInfoBuilder(ServiceReference<EndpointInfoBuilder> ref) {
        this.endpointInfoBuilderSRRef.unsetReference(ref);
    }

    protected void activate(ComponentContext cc) {
        this.endpointInfoBuilderSRRef.activate(cc);
    }

    protected void deactivate(ComponentContext cc) {
        this.endpointInfoBuilderSRRef.deactivate(cc);
    }
}

