/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.messaging.decoder.servlet;

import jakarta.annotation.Nonnull;
import jakarta.servlet.http.HttpServletRequest;
import java.io.InputStream;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.opensaml.messaging.decoder.servlet.AbstractHttpServletRequestMessageDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class BaseHttpServletRequestXMLMessageDecoder
extends AbstractHttpServletRequestMessageDecoder {
    @Nonnull
    private Logger protocolMessageLog = LoggerFactory.getLogger((String)"PROTOCOL_MESSAGE");
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(BaseHttpServletRequestXMLMessageDecoder.class);
    @Nonnull
    private ParserPool parserPool = XMLObjectProviderRegistrySupport.getParserPool();

    @Override
    public void decode() throws MessageDecodingException {
        this.log.debug("Beginning to decode message from HttpServletRequest");
        this.log.debug("HttpServletRequest indicated Content-Type: {}", (Object)this.getHttpServletRequest().getContentType());
        this.validateHttpRequest(this.getHttpServletRequest());
        super.decode();
        this.logDecodedMessage();
        this.log.debug("Successfully decoded message from HttpServletRequest.");
    }

    @Nonnull
    public ParserPool getParserPool() {
        return this.parserPool;
    }

    public void setParserPool(@Nonnull ParserPool pool) {
        Constraint.isNotNull((Object)pool, (String)"ParserPool cannot be null");
        this.parserPool = pool;
    }

    @Override
    protected void doDestroy() {
        this.parserPool = null;
        super.doDestroy();
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.parserPool == null) {
            throw new ComponentInitializationException("Parser pool cannot be null");
        }
    }

    protected void logDecodedMessage() {
        if (this.protocolMessageLog.isDebugEnabled()) {
            Object message = this.getMessageToLog();
            if (message == null || !(message instanceof XMLObject)) {
                this.log.warn("Decoded message was null or unsupported, nothing to log");
                return;
            }
            try {
                Element dom = XMLObjectSupport.marshall((XMLObject)((XMLObject)message));
                this.protocolMessageLog.debug("\n" + SerializeSupport.prettyPrintXML((Node)dom));
            }
            catch (MarshallingException e) {
                this.log.error("Unable to marshall message for logging purposes", (Throwable)e);
            }
        }
    }

    protected Object getMessageToLog() {
        return this.getMessageContext().getMessage();
    }

    protected XMLObject unmarshallMessage(InputStream messageStream) throws MessageDecodingException {
        try {
            XMLObject message = XMLObjectSupport.unmarshallFromInputStream((ParserPool)this.getParserPool(), (InputStream)messageStream);
            return message;
        }
        catch (XMLParserException e) {
            this.log.error("Error unmarshalling message from input stream: {}", (Object)e.getMessage());
            throw new MessageDecodingException("Error unmarshalling message from input stream", (Exception)((Object)e));
        }
        catch (UnmarshallingException e) {
            this.log.error("Error unmarshalling message from input stream: {}", (Object)e.getMessage());
            throw new MessageDecodingException("Error unmarshalling message from input stream", (Exception)((Object)e));
        }
    }

    protected void validateHttpRequest(HttpServletRequest request) throws MessageDecodingException {
    }
}

