/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.security.wim.scim20;

import com.ibm.websphere.security.wim.scim20.exceptions.InvalidFilterException;
import com.ibm.websphere.security.wim.scim20.exceptions.InvalidValueException;
import com.ibm.websphere.security.wim.scim20.exceptions.MutabilityException;
import com.ibm.websphere.security.wim.scim20.exceptions.TooManyResultsException;
import com.ibm.websphere.security.wim.scim20.exceptions.UniquenessException;
import com.ibm.websphere.security.wim.scim20.model.ListResponse;
import com.ibm.websphere.security.wim.scim20.model.Resource;
import com.ibm.websphere.security.wim.scim20.model.SearchRequest;
import com.ibm.websphere.security.wim.scim20.model.groups.Group;
import com.ibm.websphere.security.wim.scim20.model.resourcetype.ResourceType;
import com.ibm.websphere.security.wim.scim20.model.schemas.Schema;
import com.ibm.websphere.security.wim.scim20.model.serviceprovider.ServiceProviderConfig;
import com.ibm.websphere.security.wim.scim20.model.users.User;
import java.util.Set;

public interface SCIMService {
    public Group createGroup(Group var1) throws UniquenessException, InvalidValueException;

    public User createUser(User var1) throws UniquenessException, InvalidValueException;

    public void deleteGroup(String var1);

    public void deleteUser(String var1);

    public Group getGroup(String var1, Set<String> var2) throws InvalidValueException;

    public ListResponse<Group> getGroups(String var1, Set<String> var2, Set<String> var3) throws InvalidFilterException, TooManyResultsException;

    public ListResponse<Resource> getResources(String var1, SearchRequest var2) throws InvalidFilterException, TooManyResultsException, InvalidValueException;

    public ResourceType getResourceType(String var1);

    public ListResponse<ResourceType> getResourceTypes();

    public ListResponse<Schema> getSchemas();

    public Schema getSchemas(String var1);

    public ServiceProviderConfig getServiceProviderConfig();

    public User getMe(Set<String> var1, Set<String> var2) throws InvalidValueException;

    public User getUser(String var1, Set<String> var2, Set<String> var3) throws InvalidValueException;

    public ListResponse<User> getUsers(String var1, Set<String> var2, Set<String> var3) throws InvalidFilterException, TooManyResultsException, InvalidValueException;

    public Group updateGroup(String var1, Group var2) throws MutabilityException, InvalidValueException;

    public User updateUser(String var1, User var2) throws MutabilityException, InvalidValueException;
}

