/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.grpc.internal.client.monitor;

import com.ibm.websphere.monitor.meters.Counter;
import com.ibm.websphere.monitor.meters.Meter;
import com.ibm.websphere.monitor.meters.StatisticsMeter;
import io.openliberty.grpc.internal.client.monitor.GrpcClientStatsMXBean;
import io.openliberty.grpc.internal.client.monitor.GrpcMethod;

public class GrpcClientStats
extends Meter
implements GrpcClientStatsMXBean {
    private final Counter rpcStarted;
    private final Counter rpcCompleted;
    private final Counter streamMessagesReceived;
    private final Counter streamMessagesSent;
    private final StatisticsMeter responseTime;
    private final GrpcMethod method;

    public GrpcClientStats(GrpcMethod method) {
        this.method = method;
        this.rpcStarted = new Counter();
        this.rpcStarted.setDescription("This shows total number of RPCs started on the client");
        this.rpcStarted.setUnit("ns");
        this.rpcCompleted = new Counter();
        this.rpcCompleted.setDescription("This shows total number of RPCs completed on the client");
        this.rpcCompleted.setUnit("ns");
        this.streamMessagesReceived = new Counter();
        this.streamMessagesReceived.setDescription("This shows total number of stream messages received from the server");
        this.streamMessagesReceived.setUnit("ns");
        this.streamMessagesSent = new Counter();
        this.streamMessagesSent.setDescription("This shows total number of stream messages sent by the client");
        this.streamMessagesSent.setUnit("ns");
        this.responseTime = new StatisticsMeter();
        this.responseTime.setDescription("Average RPC Response Time");
        this.responseTime.setUnit("ns");
    }

    @Override
    public long getRpcStartedCount() {
        return this.rpcStarted.getCurrentValue();
    }

    @Override
    public long getRpcCompletedCount() {
        return this.rpcCompleted.getCurrentValue();
    }

    @Override
    public long getReceivedMessagesCount() {
        return this.streamMessagesReceived.getCurrentValue();
    }

    @Override
    public long getSentMessagesCount() {
        return this.streamMessagesSent.getCurrentValue();
    }

    @Override
    public double getResponseTime() {
        return this.responseTime.getMean();
    }

    public StatisticsMeter getResponseTimeDetails() {
        return this.responseTime;
    }

    public void recordCallStarted() {
        this.rpcStarted.incrementBy(1L);
    }

    public void recordClientHandled() {
        this.rpcCompleted.incrementBy(1L);
    }

    public void incrementReceivedMsgCountBy(int i) {
        this.streamMessagesReceived.incrementBy((long)i);
    }

    public void incrementSentMsgCountBy(int i) {
        this.streamMessagesSent.incrementBy((long)i);
    }

    public void recordLatency(long latencyMs) {
        this.responseTime.addDataPoint(latencyMs);
    }
}

