/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.mcp.internal.schemas.blueprints;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.mcp.internal.schemas.SchemaAnnotation;
import io.openliberty.mcp.internal.schemas.SchemaCreationBlueprintGenerator;
import io.openliberty.mcp.internal.schemas.SchemaDirection;
import io.openliberty.mcp.internal.schemas.SchemaGenerator;
import io.openliberty.mcp.internal.schemas.blueprints.SchemaCreationBlueprint;
import jakarta.json.Json;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.util.List;
import java.util.Optional;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public record ClassSchemaCreationBlueprint(Class<?> baseType, List<SchemaCreationBlueprintGenerator.FieldInfo> inputFields, List<SchemaCreationBlueprintGenerator.FieldInfo> outputFields) implements SchemaCreationBlueprint
{
    static final long serialVersionUID = -8910937946920423210L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Override
    public Optional<String> getDefsName() {
        return Optional.of(this.baseType.getSimpleName());
    }

    @Override
    public JsonObjectBuilder toJsonSchemaObject(SchemaGenerator.SchemaGenerationContext ctx, String referenceDescription) {
        Optional<JsonObjectBuilder> annotationSchema = SchemaAnnotation.read(this.baseType).asJsonSchema();
        if (annotationSchema.isPresent()) {
            JsonObjectBuilder result = annotationSchema.get();
            if (referenceDescription != null) {
                result.add("description", referenceDescription);
            }
            return annotationSchema.get();
        }
        JsonObjectBuilder properties = Json.createObjectBuilder();
        JsonArrayBuilder required = Json.createArrayBuilder();
        List<SchemaCreationBlueprintGenerator.FieldInfo> fields = ctx.getDirection() == SchemaDirection.INPUT ? this.inputFields() : this.outputFields();
        for (SchemaCreationBlueprintGenerator.FieldInfo fi : fields) {
            SchemaAnnotation childSchemaAnn = SchemaAnnotation.read(fi.annotations());
            JsonObjectBuilder subSchemaObjectBuilder = SchemaGenerator.generateSubSchema(fi.type(), ctx, childSchemaAnn);
            properties.add(fi.name(), (JsonValue)subSchemaObjectBuilder.build());
            SchemaCreationBlueprint scb = ctx.getBlueprintRegistry().getSchemaCreationBlueprint(fi.type());
            if (!scb.isRequired()) continue;
            required.add(fi.name());
        }
        String schemaDescription = referenceDescription;
        if (schemaDescription == null) {
            SchemaAnnotation baseSchemaAnn = SchemaAnnotation.read(this.baseType().getAnnotations());
            schemaDescription = baseSchemaAnn.description().orElse(null);
        }
        JsonObjectBuilder schemaBuilder = Json.createObjectBuilder().add("type", "object").add("properties", (JsonValue)properties.build()).add("required", (JsonValue)required.build());
        if (schemaDescription != null) {
            schemaBuilder.add("description", schemaDescription);
        }
        return schemaBuilder;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.mcp.internal.schemas.blueprints.ClassSchemaCreationBlueprint", ClassSchemaCreationBlueprint.class, (String)"MCP", null);
    }
}

