/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.mcp.internal.schemas;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.mcp.internal.McpCdiExtension;
import io.openliberty.mcp.internal.schemas.SchemaCreationBlueprintRegistry;
import io.openliberty.mcp.internal.schemas.SchemaDirection;
import io.openliberty.mcp.internal.schemas.SchemaGenerator;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.json.JsonObject;
import java.lang.annotation.Annotation;
import java.util.HashMap;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class SchemaRegistry {
    private HashMap<SchemaKey, JsonObject> schemaCache = new HashMap();
    private SchemaCreationBlueprintRegistry blueprintRegistry = new SchemaCreationBlueprintRegistry();
    private static SchemaRegistry staticInstance;
    static final long serialVersionUID = -5106007635862153224L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static SchemaRegistry get() {
        if (staticInstance != null) {
            return staticInstance;
        }
        return ((McpCdiExtension)CDI.current().select(McpCdiExtension.class, new Annotation[0]).get()).getSchemaRegistry();
    }

    public static void set(SchemaRegistry staticInstance) {
        SchemaRegistry.staticInstance = staticInstance;
    }

    public JsonObject getSchema(Class<?> cls, SchemaDirection direction) {
        JsonObject schema;
        ClassKey ck = new ClassKey(cls, direction);
        if (!this.schemaCache.containsKey(ck)) {
            schema = SchemaGenerator.generateSchema(cls, direction, this.blueprintRegistry);
            this.schemaCache.put(ck, schema);
        } else {
            schema = this.schemaCache.get(ck);
        }
        return schema;
    }

    public JsonObject getToolInputSchema(AnnotatedMethod<?> toolMethod) {
        ToolKey key = new ToolKey(toolMethod, SchemaDirection.INPUT);
        return this.schemaCache.computeIfAbsent(key, k -> SchemaGenerator.generateToolInputSchema(toolMethod, this.blueprintRegistry));
    }

    public JsonObject getToolOutputSchema(AnnotatedMethod<?> toolMethod) {
        ToolKey key = new ToolKey(toolMethod, SchemaDirection.OUTPUT);
        return this.schemaCache.computeIfAbsent(key, k -> SchemaGenerator.generateToolOutputSchema(toolMethod, this.blueprintRegistry));
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.mcp.internal.schemas.SchemaRegistry", SchemaRegistry.class, (String)"MCP", null);
        staticInstance = null;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public record ClassKey(Class<?> cls, SchemaDirection direction) implements SchemaKey
    {
        static final long serialVersionUID = -21756537451110604L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.mcp.internal.schemas.SchemaRegistry$ClassKey", ClassKey.class, (String)"MCP", null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public record ToolKey(AnnotatedMethod<?> tool, SchemaDirection direction) implements SchemaKey
    {
        static final long serialVersionUID = -5477327442660160719L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.mcp.internal.schemas.SchemaRegistry$ToolKey", ToolKey.class, (String)"MCP", null);
        }
    }

    public static interface SchemaKey {
    }
}

