/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.mcp.internal.schemas;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.mcp.internal.schemas.JsonProperty;
import io.openliberty.mcp.internal.schemas.SchemaDirection;
import io.openliberty.mcp.internal.schemas.TypeUtility;
import io.openliberty.mcp.internal.schemas.blueprints.ClassSchemaCreationBlueprint;
import io.openliberty.mcp.internal.schemas.blueprints.EnumSchemaCreationBlueprint;
import io.openliberty.mcp.internal.schemas.blueprints.ListSchemaCreationBlueprint;
import io.openliberty.mcp.internal.schemas.blueprints.MapSchemaCreationBlueprint;
import io.openliberty.mcp.internal.schemas.blueprints.OptionalSchemaCreationBlueprint;
import io.openliberty.mcp.internal.schemas.blueprints.SchemaCreationBlueprint;
import io.openliberty.mcp.internal.schemas.blueprints.TypeVariableSchemaCreationBlueprint;
import io.openliberty.mcp.internal.schemas.blueprints.WildcardSchemaCreationBlueprint;
import jakarta.json.bind.annotation.JsonbProperty;
import jakarta.json.bind.annotation.JsonbTransient;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class SchemaCreationBlueprintGenerator {
    static final long serialVersionUID = 2636178430952170184L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static SchemaCreationBlueprint generateSchemaCreationBlueprint(Type type) {
        if (type instanceof Class) {
            Class cls = (Class)type;
            if (cls.isEnum()) {
                return SchemaCreationBlueprintGenerator.generateEnumSchemaCreationBlueprint(type);
            }
            if (cls.isArray()) {
                return SchemaCreationBlueprintGenerator.generateArraySchemaCreationBlueprint(cls);
            }
            if (Optional.class.isAssignableFrom(cls)) {
                return SchemaCreationBlueprintGenerator.generateRawOptionalSchemaCreationBlueprint(type);
            }
            if (Map.class.isAssignableFrom(cls)) {
                return SchemaCreationBlueprintGenerator.generateRawMapSchemaCreationBlueprint(type);
            }
            if (Collection.class.isAssignableFrom(cls)) {
                return SchemaCreationBlueprintGenerator.generateRawCollectionSchemaCreationBlueprint(type);
            }
            ClassSchemaCreationBlueprint schemaCreationContext = SchemaCreationBlueprintGenerator.generateClassSchemaCreationBlueprint(type);
            return schemaCreationContext;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            if (Optional.class.isAssignableFrom((Class)pt.getRawType())) {
                return SchemaCreationBlueprintGenerator.generateParameterizedOptionalSchemaCreationBlueprint(type);
            }
            if (Map.class.isAssignableFrom((Class)pt.getRawType())) {
                return SchemaCreationBlueprintGenerator.generateParameterizedMapSchemaCreationBlueprint(type);
            }
            if (Collection.class.isAssignableFrom((Class)pt.getRawType())) {
                return SchemaCreationBlueprintGenerator.generateParameterizedCollectionSchemaCreationBlueprint(type);
            }
            ClassSchemaCreationBlueprint schemaCreationContext = SchemaCreationBlueprintGenerator.generateParameterizedClassSchemaCreationBlueprint(pt);
            return schemaCreationContext;
        }
        if (type instanceof TypeVariable) {
            TypeVariableSchemaCreationBlueprint schemaCreationContext = SchemaCreationBlueprintGenerator.generateTypeVariableSchemaCreationBlueprint(type);
            return schemaCreationContext;
        }
        if (type instanceof WildcardType) {
            WildcardSchemaCreationBlueprint schemaCreationContext = SchemaCreationBlueprintGenerator.generateWildcardSchemaCreationBlueprint(type);
            return schemaCreationContext;
        }
        if (type instanceof GenericArrayType) {
            return SchemaCreationBlueprintGenerator.generateGenericArraySchemaCreationBlueprint(type);
        }
        throw new IllegalArgumentException("Cannot generate schema blueprint for " + String.valueOf(type));
    }

    public static ClassSchemaCreationBlueprint generateClassSchemaCreationBlueprint(Type type) {
        Class cls = (Class)type;
        List<JsonProperty> properties = JsonProperty.extract(cls);
        return new ClassSchemaCreationBlueprint(cls, SchemaCreationBlueprintGenerator.getInputFields(properties), SchemaCreationBlueprintGenerator.getOutputFields(properties));
    }

    public static ClassSchemaCreationBlueprint generateParameterizedClassSchemaCreationBlueprint(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            Class cls = (Class)pt.getRawType();
            HashMap genericMap = new HashMap();
            TypeVariable<Class<T>>[] typeVariables = cls.getTypeParameters();
            Type[] actualTypes = pt.getActualTypeArguments();
            for (int i = 0; i < typeVariables.length; ++i) {
                genericMap.put(typeVariables[i], actualTypes[i]);
            }
            List<JsonProperty> properties = JsonProperty.extract(cls);
            return new ClassSchemaCreationBlueprint((Class)pt.getRawType(), SchemaCreationBlueprintGenerator.getInputFields(properties, genericMap), SchemaCreationBlueprintGenerator.getOutputFields(properties, genericMap));
        }
        return null;
    }

    public static TypeVariableSchemaCreationBlueprint generateTypeVariableSchemaCreationBlueprint(Type type) {
        if (type instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)type;
            return new TypeVariableSchemaCreationBlueprint(type, tv);
        }
        return null;
    }

    public static WildcardSchemaCreationBlueprint generateWildcardSchemaCreationBlueprint(Type type) {
        if (type instanceof WildcardType) {
            WildcardType wt = (WildcardType)type;
            return new WildcardSchemaCreationBlueprint(type, wt, wt.getUpperBounds(), wt.getLowerBounds());
        }
        return null;
    }

    public static EnumSchemaCreationBlueprint generateEnumSchemaCreationBlueprint(Type type) {
        Class cls = (Class)type;
        List<String> enumValues = SchemaCreationBlueprintGenerator.getEnumConstants(cls);
        return new EnumSchemaCreationBlueprint(cls, enumValues);
    }

    public static ListSchemaCreationBlueprint generateRawCollectionSchemaCreationBlueprint(Type type) {
        return new ListSchemaCreationBlueprint(type, null);
    }

    public static ListSchemaCreationBlueprint generateArraySchemaCreationBlueprint(Type type) {
        Class<?> elementType = ((Class)type).getComponentType();
        return new ListSchemaCreationBlueprint(type, elementType);
    }

    public static ListSchemaCreationBlueprint generateGenericArraySchemaCreationBlueprint(Type type) {
        if (type instanceof GenericArrayType) {
            GenericArrayType gat = (GenericArrayType)type;
            Type elementType = gat.getGenericComponentType();
            return new ListSchemaCreationBlueprint(type, elementType);
        }
        return null;
    }

    public static MapSchemaCreationBlueprint generateRawMapSchemaCreationBlueprint(Type type) {
        return new MapSchemaCreationBlueprint(type, null, null);
    }

    public static OptionalSchemaCreationBlueprint generateRawOptionalSchemaCreationBlueprint(Type type) {
        return new OptionalSchemaCreationBlueprint(type, null);
    }

    public static ListSchemaCreationBlueprint generateParameterizedCollectionSchemaCreationBlueprint(Type type) {
        Type elementType = TypeUtility.getCollectionType(type);
        return new ListSchemaCreationBlueprint(type, elementType);
    }

    public static MapSchemaCreationBlueprint generateParameterizedMapSchemaCreationBlueprint(Type type) {
        TypeUtility.MapTypes mapTypes = TypeUtility.getMapTypes(type);
        Type keyType = mapTypes.key();
        Type valueType = mapTypes.value();
        if (keyType.equals(String.class) || SchemaCreationBlueprintGenerator.isEnum(keyType)) {
            return new MapSchemaCreationBlueprint(type, keyType, valueType);
        }
        throw new RuntimeException(String.valueOf(type) + " represents a map which does not have String or Enum keys");
    }

    private static boolean isEnum(Type type) {
        if (type instanceof Class) {
            Class cls = (Class)type;
            return cls.isEnum();
        }
        return false;
    }

    public static OptionalSchemaCreationBlueprint generateParameterizedOptionalSchemaCreationBlueprint(Type type) {
        Type elementType = TypeUtility.getOptionalType(type);
        return new OptionalSchemaCreationBlueprint(type, elementType);
    }

    private static List<String> getEnumConstants(Class<?> cls) {
        ArrayList<String> result = new ArrayList<String>();
        for (Field field : cls.getDeclaredFields()) {
            String name;
            if (!field.isEnumConstant()) continue;
            String string = name = field.getAnnotation(JsonbProperty.class) != null ? field.getAnnotation(JsonbProperty.class).value() : field.getName();
            if (field.getAnnotation(JsonbTransient.class) != null) continue;
            result.add(name);
        }
        return result;
    }

    private static List<FieldInfo> getInputFields(List<JsonProperty> properties) {
        return properties.stream().filter(p -> p.isInput()).map(p -> new FieldInfo(p.getInputName(), p.getInputType(), p.getInputAnnotations(), SchemaDirection.INPUT)).collect(Collectors.toList());
    }

    private static List<FieldInfo> getInputFields(List<JsonProperty> properties, Map<TypeVariable<?>, Type> genericMap) {
        return properties.stream().filter(p -> p.isInput()).map(p -> new FieldInfo(p.getInputName(), (Type)genericMap.get(p.getInputType()), p.getInputAnnotations(), SchemaDirection.INPUT)).collect(Collectors.toList());
    }

    private static List<FieldInfo> getOutputFields(List<JsonProperty> properties) {
        return properties.stream().filter(p -> p.isOutput()).map(p -> new FieldInfo(p.getOutputName(), p.getOutputType(), p.getOutputAnnotations(), SchemaDirection.OUTPUT)).collect(Collectors.toList());
    }

    private static List<FieldInfo> getOutputFields(List<JsonProperty> properties, Map<TypeVariable<?>, Type> genericMap) {
        return properties.stream().filter(p -> p.isOutput()).map(p -> new FieldInfo(p.getOutputName(), (Type)genericMap.get(p.getOutputType()), p.getOutputAnnotations(), SchemaDirection.OUTPUT)).collect(Collectors.toList());
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.mcp.internal.schemas.SchemaCreationBlueprintGenerator", SchemaCreationBlueprintGenerator.class, (String)"MCP", null);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public record FieldInfo(String name, Type type, Annotation[] annotations, SchemaDirection direction) {
        static final long serialVersionUID = -8854344324126598135L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.mcp.internal.schemas.SchemaCreationBlueprintGenerator$FieldInfo", FieldInfo.class, (String)"MCP", null);
        }
    }
}

