/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.mcp.internal.schemas;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.mcp.annotations.Schema;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.Optional;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public record SchemaAnnotation(Optional<Schema> annotation, Optional<String> schema, Optional<String> description) {
    public static final SchemaAnnotation EMPTY;
    static final long serialVersionUID = 6623319324690170076L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static SchemaAnnotation read(Annotation[] annotations) {
        return Arrays.stream(annotations).filter(a -> a.annotationType().equals(Schema.class)).map(Schema.class::cast).findAny().map(s -> new SchemaAnnotation(Optional.of(s), SchemaAnnotation.getValue(s), SchemaAnnotation.getDescription(s))).orElse(EMPTY);
    }

    public static SchemaAnnotation read(AnnotatedElement element) {
        Schema annotation = element.getAnnotation(Schema.class);
        if (annotation != null) {
            return new SchemaAnnotation(Optional.of(annotation), SchemaAnnotation.getValue(annotation), SchemaAnnotation.getDescription(annotation));
        }
        return EMPTY;
    }

    private static Optional<String> getDescription(Schema anno) {
        String description = anno.description();
        return description.equals("<<unset>>") ? Optional.empty() : Optional.of(description);
    }

    private static Optional<String> getValue(Schema anno) {
        String value = anno.value();
        return value.equals("<<unset>>") ? Optional.empty() : Optional.of(value);
    }

    public static SchemaAnnotation ofDescription(String description) {
        return new SchemaAnnotation(Optional.empty(), Optional.empty(), Optional.ofNullable(description));
    }

    public Optional<JsonObjectBuilder> asJsonSchema() {
        return this.schema.map(s -> Json.createObjectBuilder((JsonObject)this.parse((String)s)));
    }

    private JsonObject parse(String json) {
        JsonObject jsonObject;
        block5: {
            JsonReader reader = Json.createReader((Reader)new StringReader(json));
            try {
                jsonObject = reader.readObject();
                if (reader == null) break block5;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"io.openliberty.mcp.internal.schemas.SchemaAnnotation", (String)"88", (Object)this, (Object[])new Object[]{json});
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        FFDCFilter.processException((Throwable)throwable2, (String)"io.openliberty.mcp.internal.schemas.SchemaAnnotation", (String)"88", (Object)this, (Object[])new Object[]{json});
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            reader.close();
        }
        return jsonObject;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.mcp.internal.schemas.SchemaAnnotation", SchemaAnnotation.class, (String)"MCP", null);
        EMPTY = new SchemaAnnotation(Optional.empty(), Optional.empty(), Optional.empty());
    }
}

