/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.mcp.internal.schemas;

import io.openliberty.mcp.internal.schemas.ClassProperty;
import io.openliberty.mcp.internal.schemas.RecordProperty;
import jakarta.json.bind.annotation.JsonbProperty;
import jakarta.json.bind.annotation.JsonbTransient;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import java.util.List;

public interface JsonProperty {
    public String getElementName();

    public boolean isInput();

    public boolean isOutput();

    public String getInputName();

    public String getOutputName();

    public Type getInputType();

    public Type getOutputType();

    public Annotation[] getInputAnnotations();

    public Annotation[] getOutputAnnotations();

    public static String getNameFromAnnotations(AnnotatedElement element) {
        if (element == null) {
            return null;
        }
        JsonbProperty ann = element.getAnnotation(JsonbProperty.class);
        if (ann == null || ann.value().isBlank()) {
            return null;
        }
        return ann.value();
    }

    public static List<JsonProperty> extract(Class<?> cls) {
        if (cls.isRecord()) {
            return RecordProperty.extractFromRecord(cls.asSubclass(Record.class));
        }
        return ClassProperty.extractFromClass(cls);
    }

    public static boolean isTransient(AnnotatedElement element) {
        return element.getAnnotation(JsonbTransient.class) != null;
    }
}

