/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.mcp.internal.responses;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.mcp.internal.exceptions.jsonrpc.JSONRPCException;
import io.openliberty.mcp.internal.requests.McpRequestId;
import io.openliberty.mcp.internal.responses.McpResponse;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class McpErrorResponse
extends McpResponse {
    private Error error;
    private static final TraceComponent tc = Tr.register(McpErrorResponse.class, (String)"MCP", (String)"io.openliberty.mcp.internal.resources.CWMCM");
    static final long serialVersionUID = -2363299347933513526L;

    public McpErrorResponse(McpRequestId id, JSONRPCException e) {
        super("2.0", id);
        String message = Tr.formatMessage((TraceComponent)tc, (String)e.getErrorCode().getMessage(), (Object[])new Object[0]);
        this.error = new Error(e.getErrorCode().getCode(), message, e.getData());
    }

    public McpErrorResponse(McpRequestId id, Error e) {
        super("2.0", id);
        String message = Tr.formatMessage((TraceComponent)tc, (String)e.message(), (Object[])new Object[0]);
        this.error = new Error(e.code(), message, e.data());
    }

    public Error getError() {
        return this.error;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public record Error(int code, String message, Object data) {
        static final long serialVersionUID = -6336519991149530989L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.mcp.internal.responses.McpErrorResponse$Error", Error.class, (String)"MCP", (String)"io.openliberty.mcp.internal.resources.CWMCM");
        }
    }
}

