/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.mcp.internal.requests;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.mcp.internal.exceptions.jsonrpc.JSONRPCErrorCode;
import io.openliberty.mcp.internal.exceptions.jsonrpc.JSONRPCException;
import io.openliberty.mcp.internal.requests.McpRequestId;
import jakarta.json.JsonNumber;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import jakarta.json.bind.serializer.DeserializationContext;
import jakarta.json.bind.serializer.JsonbDeserializer;
import jakarta.json.stream.JsonParser;
import java.lang.reflect.Type;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class McpRequestIdDeserializer
implements JsonbDeserializer<McpRequestId> {
    private static final TraceComponent tc = Tr.register(McpRequestIdDeserializer.class, (String)"MCP", (String)"io.openliberty.mcp.internal.resources.CWMCM");
    static final long serialVersionUID = 4182289474252444245L;

    public McpRequestId deserialize(JsonParser parser, DeserializationContext ctx, Type rtType) {
        JsonValue jsonVal = parser.getValue();
        switch (jsonVal.getValueType()) {
            case STRING: {
                String strVal = ((JsonString)jsonVal).getString();
                if (strVal.isBlank()) {
                    throw new JSONRPCException(JSONRPCErrorCode.PARSE_ERROR, Tr.formatMessage((TraceComponent)tc, (String)"CWMCM0019E.jsonrpc.validation.empty.string.id", (Object[])new Object[]{strVal}));
                }
                return new McpRequestId(strVal);
            }
            case NUMBER: {
                return new McpRequestId(((JsonNumber)jsonVal).bigDecimalValue());
            }
        }
        throw new JSONRPCException(JSONRPCErrorCode.PARSE_ERROR, Tr.formatMessage((TraceComponent)tc, (String)"CWMCM0021E.jsonrpc.validation.invalid.id.type", (Object[])new Object[0]));
    }
}

