/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.mcp.internal.requests;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.mcp.internal.RequestMethod;
import io.openliberty.mcp.internal.exceptions.jsonrpc.MCPRequestValidationException;
import io.openliberty.mcp.internal.requests.McpRequestId;
import jakarta.json.Json;
import jakarta.json.JsonException;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import jakarta.json.bind.Jsonb;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public record McpRequest(String jsonrpc, McpRequestId id, String method, JsonObject params) {
    private static final TraceComponent tc = Tr.register(McpRequest.class, (String)"MCP", (String)"io.openliberty.mcp.internal.resources.CWMCM");
    static final long serialVersionUID = 7132756910999315730L;

    public RequestMethod getRequestMethod() {
        return RequestMethod.getForMethodName(this.method);
    }

    public <T> T getParams(Class<T> type, Jsonb jsonb) {
        String json = jsonb.toJson((Object)this.params);
        return (T)jsonb.fromJson(json, type);
    }

    public static McpRequest createValidMCPRequest(Reader reader) throws JsonException, MCPRequestValidationException {
        JsonObject requestJson = Json.createReader((Reader)reader).readObject();
        ArrayList<String> errors = new ArrayList<String>();
        String jsonRpc = requestJson.getString("jsonrpc", null);
        JsonValue id = (JsonValue)requestJson.getOrDefault((Object)"id", null);
        String method = requestJson.getString("method", null);
        JsonObject params = requestJson.getJsonObject("params");
        McpRequest.validateJsonRpc(jsonRpc, errors);
        McpRequest.validateMethod(method, errors);
        if (id == null) {
            if (!errors.isEmpty()) {
                throw new MCPRequestValidationException(errors);
            }
            return McpRequest.createMCPNotificationRequest(jsonRpc, method, params);
        }
        McpRequestId idObj = McpRequest.parseAndValidateId(id, errors);
        if (!errors.isEmpty()) {
            throw new MCPRequestValidationException(errors);
        }
        return new McpRequest(jsonRpc, idObj, method, params);
    }

    private static McpRequest createMCPNotificationRequest(String jsonRpc, String method, JsonObject params) {
        return new McpRequest(jsonRpc, null, method, params);
    }

    private static void validateJsonRpc(String jsonRpc, List<String> errors) {
        if (!"2.0".equals(jsonRpc)) {
            errors.add(Tr.formatMessage((TraceComponent)tc, (String)"jsonrpc.exception.validation.invalid.version", (Object[])new Object[]{jsonRpc}));
        }
    }

    private static void validateMethod(String method, List<String> errors) {
        if (method == null || method.isBlank()) {
            errors.add(Tr.formatMessage((TraceComponent)tc, (String)"jsonrpc.validation.empty.method", (Object[])new Object[0]));
        }
    }

    private static McpRequestId parseAndValidateId(JsonValue id, List<String> errors) {
        return switch (id.getValueType()) {
            case JsonValue.ValueType.NUMBER -> new McpRequestId(((JsonNumber)id).bigDecimalValue());
            case JsonValue.ValueType.STRING -> {
                String idString = ((JsonString)id).getString();
                if (idString.isBlank()) {
                    errors.add(Tr.formatMessage((TraceComponent)tc, (String)"jsonrpc.exception.validation.empty.string.id", (Object[])new Object[]{idString}));
                    yield null;
                }
                yield new McpRequestId(idString);
            }
            default -> {
                errors.add(Tr.formatMessage((TraceComponent)tc, (String)"jsonrpc.exception.validation.invalid.id.type", (Object[])new Object[0]));
                yield null;
            }
        };
    }
}

