/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.mcp.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.mcp.annotations.Tool;
import io.openliberty.mcp.internal.SpecialArgumentType;
import io.openliberty.mcp.internal.ToolMetadata;
import io.openliberty.mcp.internal.ToolRegistry;
import io.openliberty.mcp.internal.schemas.SchemaRegistry;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AfterDeploymentValidation;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessManagedBean;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class McpCdiExtension
implements Extension {
    private static final TraceComponent tc = Tr.register(McpCdiExtension.class, (String)"MCP", (String)"io.openliberty.mcp.internal.resources.CWMCM");
    private ToolRegistry tools = new ToolRegistry();
    private ConcurrentHashMap<String, LinkedList<String>> duplicateToolsMap = new ConcurrentHashMap();
    private SchemaRegistry schemas = new SchemaRegistry();
    static final long serialVersionUID = -5810684224278979120L;

    void registerTools(@Observes ProcessManagedBean<?> pmb) {
        AnnotatedType type = pmb.getAnnotatedBeanClass();
        Class javaClass = type.getJavaClass();
        for (AnnotatedMethod m : type.getMethods()) {
            Tool toolAnnotation = (Tool)m.getAnnotation(Tool.class);
            if (toolAnnotation == null) continue;
            this.registerTool(toolAnnotation, pmb.getBean(), m);
        }
    }

    void afterDeploymentValidation(@Observes AfterDeploymentValidation afterDeploymentValidation, BeanManager manager) {
        boolean error = this.reportOnDuplicateTools(afterDeploymentValidation) | this.reportOnToolArgEdgeCases(afterDeploymentValidation) | this.reportOnDuplicateSpecialArguments(afterDeploymentValidation) | this.reportOnInvalidSpecialArguments(afterDeploymentValidation);
        if (error) {
            afterDeploymentValidation.addDeploymentProblem((Throwable)new Exception(Tr.formatMessage((TraceComponent)tc, (String)"CWMCM0005E.validation.error", (Object[])new Object[0])));
        }
    }

    private boolean reportOnToolArgEdgeCases(AfterDeploymentValidation afterDeploymentValidation) {
        boolean blankArgumentsFound = false;
        boolean duplicateArgumentsFound = false;
        boolean missingArgumentName = false;
        for (ToolMetadata tool : this.tools.getAllTools()) {
            Map<String, ToolMetadata.ArgumentMetadata> arguments = tool.arguments();
            for (String argName : arguments.keySet()) {
                if (argName.isBlank()) {
                    Tr.error((TraceComponent)tc, (String)"CWMCM0001E.blank.arguments", (Object[])new Object[]{tool.getToolQualifiedName()});
                    blankArgumentsFound = true;
                    continue;
                }
                if (arguments.get(argName).isDuplicate()) {
                    Tr.error((TraceComponent)tc, (String)"CWMCM0002E.duplicate.arguments", (Object[])new Object[]{tool.getToolQualifiedName(), argName});
                    duplicateArgumentsFound = true;
                    continue;
                }
                if (!argName.equals("<<<MISSING TOOL_ARG NAME>>>")) continue;
                Tr.error((TraceComponent)tc, (String)"CWMCM0003E.missing.tool.argument.name", (Object[])new Object[]{tool.getToolQualifiedName()});
                missingArgumentName = true;
            }
        }
        return blankArgumentsFound || duplicateArgumentsFound || missingArgumentName;
    }

    private boolean reportOnDuplicateTools(AfterDeploymentValidation afterDeploymentValidation) {
        boolean error = false;
        this.duplicateToolsMap.entrySet().removeIf(e -> ((LinkedList)e.getValue()).size() == 1);
        for (String toolName : this.duplicateToolsMap.keySet()) {
            error = true;
            LinkedList<String> qualifiedNames = this.duplicateToolsMap.get(toolName);
            Tr.error((TraceComponent)tc, (String)"CWMCM0004E.duplicate.tools", (Object[])new Object[]{toolName, String.join((CharSequence)",", qualifiedNames)});
        }
        return error;
    }

    private boolean reportOnDuplicateSpecialArguments(AfterDeploymentValidation afterDeploymentValidation) {
        AtomicBoolean error = new AtomicBoolean(false);
        for (ToolMetadata tool : this.tools.getAllTools()) {
            HashMap<SpecialArgumentType.Resolution, Integer> resultCountMap = new HashMap<SpecialArgumentType.Resolution, Integer>();
            for (ToolMetadata.SpecialArgumentMetadata specialArgument : tool.specialArguments()) {
                SpecialArgumentType.Resolution specialArgumentTypeResolution = specialArgument.typeResolution();
                if (specialArgumentTypeResolution.specialArgsType() == SpecialArgumentType.UNSUPPORTED) continue;
                resultCountMap.merge(specialArgumentTypeResolution, 1, Integer::sum);
            }
            resultCountMap.forEach((k, v) -> {
                if (v > 1) {
                    error.set(true);
                    Tr.error((TraceComponent)tc, (String)"CWMCM0006E.duplicate.special.arguments", (Object[])new Object[]{tool.getToolQualifiedName(), k.actualClass().getSimpleName()});
                }
            });
        }
        return error.get();
    }

    private boolean reportOnInvalidSpecialArguments(AfterDeploymentValidation afterDeploymentValidation) {
        boolean error = false;
        for (ToolMetadata tool : this.tools.getAllTools()) {
            for (ToolMetadata.SpecialArgumentMetadata specialArgument : tool.specialArguments()) {
                if (specialArgument.typeResolution().specialArgsType() != SpecialArgumentType.UNSUPPORTED) continue;
                error = true;
                Tr.error((TraceComponent)tc, (String)"CWMCM0007E.invalid.arguments", (Object[])new Object[]{tool.getToolQualifiedName(), specialArgument.typeResolution()});
            }
        }
        return error;
    }

    private void registerTool(Tool tool, Bean<?> bean, AnnotatedMethod<?> method) {
        ToolMetadata toolmd = ToolMetadata.createFrom(tool, bean, method);
        this.duplicateToolsMap.computeIfAbsent(toolmd.name(), key -> new LinkedList()).add(toolmd.getToolQualifiedName());
        this.tools.addTool(toolmd);
        if (TraceComponent.isAnyTracingEnabled()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Registered tool: " + toolmd.name()), (Object[])new Object[]{toolmd});
            } else if (tc.isEventEnabled()) {
                Tr.event((Object)this, (TraceComponent)tc, (String)("Registered tool: " + toolmd.name()), (Object[])new Object[]{method});
            }
        }
    }

    public ToolRegistry getToolRegistry() {
        return this.tools;
    }

    public SchemaRegistry getSchemaRegistry() {
        return this.schemas;
    }
}

