/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.cxf.interceptor;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.auth.WSSubject;
import com.ibm.websphere.security.saml2.Saml20Token;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.SecurityService;
import com.ibm.ws.security.authentication.AuthenticationData;
import com.ibm.ws.security.authentication.AuthenticationException;
import com.ibm.ws.security.authentication.AuthenticationService;
import com.ibm.ws.security.authentication.WSAuthenticationData;
import com.ibm.ws.security.context.SubjectManager;
import com.ibm.ws.security.sso.common.SsoService;
import com.ibm.ws.webcontainer.security.AuthResult;
import com.ibm.ws.webcontainer.security.AuthenticationResult;
import com.ibm.ws.wssecurity.caller.SAMLAuthenticator;
import com.ibm.ws.wssecurity.cxf.validator.UsernameTokenValidator;
import com.ibm.ws.wssecurity.token.TokenUtils;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceMap;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.security.wss4j.PolicyBasedWSS4JInInterceptor;
import org.apache.cxf.ws.security.wss4j.WSS4JUtils;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.principal.WSUsernameTokenPrincipalImpl;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.apache.wss4j.dom.WSConstants;
import org.apache.wss4j.dom.WSDataRef;
import org.apache.wss4j.dom.engine.WSSecurityEngineResult;
import org.apache.wss4j.dom.handler.WSHandlerResult;
import org.apache.wss4j.dom.message.token.Timestamp;
import org.apache.wss4j.policy.SP12Constants;
import org.opensaml.saml.saml2.core.Assertion;
import org.w3c.dom.Element;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class WSSecurityLibertyCallerInterceptor
extends AbstractSoapInterceptor {
    private static final TraceComponent tc = Tr.register(WSSecurityLibertyCallerInterceptor.class, (String)"WSSecurity", (String)"com.ibm.ws.wssecurity.resources.WSSecurityMessages");
    protected static final String multiple_unt_exist_err = "More than one Username token is found in the message, cannot identify caller candidate.";
    protected static final String no_unt_exist_err = "There is no Username token in the message to process caller.";
    protected static final String multiple_saml_exist_err = "More than one Saml token is found in the message, cannot identify caller candidate.";
    protected static final String no_saml_exist_err = "There is no Saml token in the message to process caller.";
    protected static final String no_x509_token_exist_err = "There is no X509 token in the message to process caller.";
    protected static final String unknown_caller_token_name = "Caller token name specified is not valid.";
    protected static final String empty_results_list = "Empty results list";
    protected static final String error_authenticate = "Cannot authenticate caller token";
    protected static final String no_asymmetric_token = "There is no Asymmetric signature token exists in the message";
    protected static final String multiple_asymmetric_token_err = "Multiple Asymmetric signature tokens in the message, cannot identify caller";
    protected static final String internal_err = "Security service is not available.";
    public static final String KEY_SSO_SERVICE = "ssoService";
    protected static final ConcurrentServiceReferenceMap<String, SsoService> ssoServiceRefs = new ConcurrentServiceReferenceMap("ssoService");
    static final long serialVersionUID = 4881525334972234599L;

    public WSSecurityLibertyCallerInterceptor() {
        super("pre-protocol");
        this.addAfter(PolicyBasedWSS4JInInterceptor.class.getName());
    }

    public void handleMessage(@Sensitive SoapMessage message) throws Fault {
        if (message == null) {
            return;
        }
        boolean isReq = MessageUtils.isRequestor((Message)message);
        boolean isOut = MessageUtils.isOutbound((Message)message);
        if (isOut) {
            return;
        }
        if (isReq) {
            return;
        }
        Map callerConfigMap = (Map)message.getContextualProperty("callerConfig");
        String callerName = null;
        if (callerConfigMap != null && !callerConfigMap.isEmpty()) {
            callerName = (String)callerConfigMap.get("name");
        }
        if (callerName == null || callerName.isEmpty()) {
            return;
        }
        boolean isUNT = false;
        boolean isX509 = false;
        boolean isSaml = false;
        if ("UsernameToken".equalsIgnoreCase(callerName)) {
            isUNT = true;
        } else if ("X509Token".equalsIgnoreCase(callerName)) {
            isX509 = true;
        } else if ("SamlToken".equalsIgnoreCase(callerName)) {
            isSaml = true;
        } else {
            SoapFault fault = this.createSoapFault(message.getVersion(), new org.apache.wss4j.common.ext.WSSecurityException(WSSecurityException.ErrorCode.INVALID_SECURITY_TOKEN, "invalidTokenType", new Object[]{callerName}));
            throw fault;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)" caller config found = ", (Object[])new Object[]{callerName});
        }
        if (message.get((Object)"RECV_RESULTS") != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)" results found", (Object[])new Object[0]);
            }
            List wsResult = (List)message.get((Object)"RECV_RESULTS");
            WSHandlerResult handlerResult = (WSHandlerResult)wsResult.get(0);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(" ws result = " + handlerResult.getResults()), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)(" ws action result = " + handlerResult.getActionResults()), (Object[])new Object[0]);
            }
            if (isUNT) {
                this.handleUsernameToken(message, handlerResult);
            } else if (isX509) {
                this.handleX509Token(message, handlerResult);
            } else if (isSaml) {
                this.handleSamlToken(message, handlerResult, callerConfigMap);
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)" NO RESULTS!!!", (Object[])new Object[0]);
            }
            Tr.error((TraceComponent)tc, (String)"no_caller_exist_err", (Object[])new Object[]{callerName, callerName});
            SoapFault fault = this.createSoapFault(message.getVersion(), new org.apache.wss4j.common.ext.WSSecurityException(WSSecurityException.ErrorCode.FAILED_AUTHENTICATION, "unhandledToken", new Object[]{callerName}));
            throw fault;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void handleSamlToken(SoapMessage message, WSHandlerResult handlerResult, Map<String, Object> callerConfigMap) {
        block17: {
            SoapFault fault;
            List samlResults = new ArrayList();
            samlResults = (List)handlerResult.getActionResults().get(16);
            if (samlResults.isEmpty()) {
                samlResults = (List)handlerResult.getActionResults().get(8);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)" saml caller token results = ", (Object[])new Object[]{samlResults.size()});
            }
            Principal principal = null;
            int cnt = 0;
            SamlAssertionWrapper assertion = null;
            for (WSSecurityEngineResult result : samlResults) {
                assertion = (SamlAssertionWrapper)result.get((Object)"saml-assertion");
                if (assertion != null && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"assertion from the results =   ", (Object[])new Object[]{assertion.getId()});
                }
                if ((principal = (Principal)result.get((Object)"principal")) == null) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"principal =   ", (Object[])new Object[]{principal});
                    Tr.debug((TraceComponent)tc, (String)"principal name =   ", (Object[])new Object[]{principal.getName()});
                }
                ++cnt;
            }
            if (cnt > 1) {
                Tr.error((TraceComponent)tc, (String)"multiple_saml_exist_err", (Object[])new Object[0]);
                fault = this.createSoapFault(message.getVersion(), new org.apache.wss4j.common.ext.WSSecurityException(WSSecurityException.ErrorCode.FAILED_AUTHENTICATION, "duplicateError"));
                throw fault;
            }
            if (cnt == 0) {
                Tr.error((TraceComponent)tc, (String)"no_caller_exist_err", (Object[])new Object[]{"SamlToken", "SamlToken"});
                fault = this.createSoapFault(message.getVersion(), new org.apache.wss4j.common.ext.WSSecurityException(WSSecurityException.ErrorCode.FAILED_AUTHENTICATION, "unhandledToken", new Object[]{"SamlToken"}));
                throw fault;
            }
            Saml20Token samlToken = null;
            try {
                samlToken = this.handleSamlAssertion(assertion);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"token is created successfully =   ", (Object[])new Object[]{samlToken.getSamlID()});
                }
            }
            catch (Exception result) {
                void e;
                FFDCFilter.processException((Throwable)result, (String)"com.ibm.ws.wssecurity.cxf.interceptor.WSSecurityLibertyCallerInterceptor", (String)"260", (Object)((Object)this), (Object[])new Object[]{message, handlerResult, callerConfigMap});
                String msg = null;
                msg = e.getCause() != null ? e.getCause().getLocalizedMessage() : e.getLocalizedMessage();
                SoapFault fault2 = this.createSoapFault(message.getVersion(), new org.apache.wss4j.common.ext.WSSecurityException(WSSecurityException.ErrorCode.FAILED_AUTHENTICATION, "badSamlToken", new Object[]{msg}));
                throw fault2;
            }
            SAMLAuthenticator callerAuthenticator = new SAMLAuthenticator(callerConfigMap, samlToken);
            boolean isProcessed = false;
            try {
                AuthenticationResult result = callerAuthenticator.authenticate();
                if (result.getStatus() == AuthResult.SUCCESS) {
                    Subject authenticatedSubject = result.getSubject();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Authentication successful, authenticated subject = ", (Object[])new Object[]{authenticatedSubject});
                        Tr.debug((TraceComponent)tc, (String)"Authentication successful, runAsSubject before = ", (Object[])new Object[]{WSSubject.getRunAsSubject()});
                    }
                    WSSubject.setRunAsSubject((Subject)authenticatedSubject);
                    SubjectManager subjectManager = new SubjectManager();
                    subjectManager.setCallerSubject(authenticatedSubject);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Authentication successful, runAsSubject after = ", (Object[])new Object[]{WSSubject.getRunAsSubject()});
                        Tr.debug((TraceComponent)tc, (String)"Authentication successful, caller subject = ", (Object[])new Object[]{WSSubject.getCallerSubject()});
                    }
                    break block17;
                }
                org.apache.wss4j.common.ext.WSSecurityException ex = "User".equalsIgnoreCase((String)callerConfigMap.get("mapToUserRegistry")) ? new org.apache.wss4j.common.ext.WSSecurityException(WSSecurityException.ErrorCode.FAILED_AUTHENTICATION, "badSamlToken", new Object[]{"invalid user ID"}) : new org.apache.wss4j.common.ext.WSSecurityException(WSSecurityException.ErrorCode.FAILED_AUTHENTICATION, "badSamlToken", new Object[]{result.getReason()});
                isProcessed = true;
                throw ex;
            }
            catch (Exception result) {
                SoapFault fault3;
                void e1;
                FFDCFilter.processException((Throwable)result, (String)"com.ibm.ws.wssecurity.cxf.interceptor.WSSecurityLibertyCallerInterceptor", (String)"313", (Object)((Object)this), (Object[])new Object[]{message, handlerResult, callerConfigMap});
                if (isProcessed) {
                    fault3 = this.createSoapFault(message.getVersion(), (org.apache.wss4j.common.ext.WSSecurityException)e1);
                } else {
                    Tr.error((TraceComponent)tc, (String)"error_authenticate", (Object[])new Object[]{e1.getMessage()});
                    fault3 = this.createSoapFault(message.getVersion(), new org.apache.wss4j.common.ext.WSSecurityException(WSSecurityException.ErrorCode.FAILED_AUTHENTICATION, "badSamlToken", new Object[]{e1.getLocalizedMessage()}));
                }
                throw fault3;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private Saml20Token handleSamlAssertion(SamlAssertionWrapper assertionWrapper) throws Exception {
        Assertion assertion = assertionWrapper.getSaml2();
        Saml20Token token = null;
        try {
            token = TokenUtils.createSamlTokenFromAssertion(assertion);
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.wssecurity.cxf.interceptor.WSSecurityLibertyCallerInterceptor", (String)"339", (Object)((Object)this), (Object[])new Object[]{assertionWrapper});
            throw e;
        }
        return token;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleUsernameToken(@Sensitive SoapMessage message, WSHandlerResult handlerResult) throws SoapFault {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"results = ", (Object[])new Object[]{handlerResult});
        }
        List utResults = new ArrayList();
        if (handlerResult.getActionResults().containsKey(1)) {
            utResults = (List)handlerResult.getActionResults().get(1);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"UNT results = ", (Object[])new Object[]{utResults});
        }
        ArrayList arrayList = new ArrayList();
        List list = (List)handlerResult.getActionResults().get(8192);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"UNT_NP results = ", (Object[])new Object[]{list});
        }
        if (list != null) {
            utResults.addAll(list);
        }
        int ut_counter = 0;
        WSUsernameTokenPrincipalImpl principal = null;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)" Number of UNT results = ", (Object[])new Object[]{utResults.size()});
        }
        for (WSSecurityEngineResult result : utResults) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)" UNT result = ", (Object[])new Object[]{result});
            }
            if ((principal = (WSUsernameTokenPrincipalImpl)result.get((Object)"principal")) != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)" principal =   ", (Object[])new Object[]{principal});
                    Tr.debug((TraceComponent)tc, (String)" principal name =   ", (Object[])new Object[]{principal.getName()});
                }
                ++ut_counter;
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)" user name token principal is NULL!!! ", (Object[])new Object[0]);
        }
        if (ut_counter > 1) {
            Tr.error((TraceComponent)tc, (String)"multiple_unt_exist_err", (Object[])new Object[0]);
            throw WSS4JUtils.createSoapFault((SoapMessage)message, (SoapVersion)message.getVersion(), (org.apache.wss4j.common.ext.WSSecurityException)new org.apache.wss4j.common.ext.WSSecurityException(WSSecurityException.ErrorCode.FAILED_AUTHENTICATION, "duplicateError"));
        }
        if (ut_counter == 0) {
            Tr.error((TraceComponent)tc, (String)"no_caller_exist_err", (Object[])new Object[]{"UsernameToken", "UsernameToken"});
            throw WSS4JUtils.createSoapFault((SoapMessage)message, (SoapVersion)message.getVersion(), (org.apache.wss4j.common.ext.WSSecurityException)new org.apache.wss4j.common.ext.WSSecurityException(WSSecurityException.ErrorCode.FAILED_AUTHENTICATION, "missingUsernameToken"));
        }
        SecurityService securityService = UsernameTokenValidator.getSecurityService();
        if (securityService == null) throw WSS4JUtils.createSoapFault((SoapMessage)message, (SoapVersion)message.getVersion(), (org.apache.wss4j.common.ext.WSSecurityException)new org.apache.wss4j.common.ext.WSSecurityException(WSSecurityException.ErrorCode.FAILED_AUTHENTICATION, "badUsernameToken", new Object[]{"Missing Liberty Security Service"}));
        AuthenticationService authenticationService = securityService.getAuthenticationService();
        Subject tempSubject = new Subject();
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        if (!authenticationService.isAllowHashTableLoginWithIdOnly().booleanValue()) {
            hashtable.put("com.ibm.ws.authentication.internal.assertion", Boolean.TRUE);
        }
        hashtable.put("com.ibm.wsspi.security.cred.userId", principal.getName());
        tempSubject.getPublicCredentials().add(hashtable);
        try {
            Subject new_subject = authenticationService.authenticate("system.WEB_INBOUND", tempSubject);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Authentication successful, authenticated subject = ", (Object[])new Object[]{new_subject});
                Tr.debug((TraceComponent)tc, (String)"Authentication successful, runAsSubject before = ", (Object[])new Object[]{WSSubject.getRunAsSubject()});
            }
            WSSubject.setRunAsSubject((Subject)new_subject);
            SubjectManager subjectManager = new SubjectManager();
            subjectManager.setCallerSubject(new_subject);
            if (!tc.isDebugEnabled()) return;
            Tr.debug((TraceComponent)tc, (String)"Authentication successful, runAsSubject after = ", (Object[])new Object[]{WSSubject.getRunAsSubject()});
            Tr.debug((TraceComponent)tc, (String)"Authentication successful, caller subject = ", (Object[])new Object[]{WSSubject.getCallerSubject()});
            return;
        }
        catch (AuthenticationException new_subject) {
            void e;
            Object[] objectArray = new Object[2];
            objectArray[0] = "<sensitive org.apache.cxf.binding.soap.SoapMessage>";
            objectArray[1] = handlerResult;
            FFDCFilter.processException((Throwable)new_subject, (String)"com.ibm.ws.wssecurity.cxf.interceptor.WSSecurityLibertyCallerInterceptor", (String)"446", (Object)((Object)this), (Object[])objectArray);
            FFDCFilter.processException((Throwable)e, (String)((Object)((Object)this)).getClass().getName(), (String)"handleMessage", (Object[])new Object[]{principal.getName()});
            Tr.error((TraceComponent)tc, (String)"error_authenticate", (Object[])new Object[]{e.getMessage()});
            throw WSS4JUtils.createSoapFault((SoapMessage)message, (SoapVersion)message.getVersion(), (org.apache.wss4j.common.ext.WSSecurityException)new org.apache.wss4j.common.ext.WSSecurityException(WSSecurityException.ErrorCode.FAILED_AUTHENTICATION, "badUsernameToken", new Object[]{e.getLocalizedMessage()}));
        }
        catch (WSSecurityException e) {
            void wse;
            Object[] objectArray = new Object[2];
            objectArray[0] = "<sensitive org.apache.cxf.binding.soap.SoapMessage>";
            objectArray[1] = handlerResult;
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.wssecurity.cxf.interceptor.WSSecurityLibertyCallerInterceptor", (String)"460", (Object)((Object)this), (Object[])objectArray);
            FFDCFilter.processException((Throwable)wse, (String)((Object)((Object)this)).getClass().getName(), (String)"handleMessage", (Object[])new Object[]{principal.getName()});
            Tr.error((TraceComponent)tc, (String)"error_authenticate", (Object[])new Object[]{wse.getMessage()});
            throw WSS4JUtils.createSoapFault((SoapMessage)message, (SoapVersion)message.getVersion(), (org.apache.wss4j.common.ext.WSSecurityException)new org.apache.wss4j.common.ext.WSSecurityException(WSSecurityException.ErrorCode.FAILED_AUTHENTICATION, "badUsernameToken", new Object[]{wse.getLocalizedMessage()}));
        }
        catch (Exception wse) {
            Object[] objectArray = new Object[2];
            objectArray[0] = "<sensitive org.apache.cxf.binding.soap.SoapMessage>";
            objectArray[1] = handlerResult;
            FFDCFilter.processException((Throwable)wse, (String)"com.ibm.ws.wssecurity.cxf.interceptor.WSSecurityLibertyCallerInterceptor", (String)"472", (Object)((Object)this), (Object[])objectArray);
            FFDCFilter.processException((Throwable)e, (String)((Object)((Object)this)).getClass().getName(), (String)"handleMessage", (Object[])new Object[]{principal.getName()});
            Tr.error((TraceComponent)tc, (String)"error_authenticate", (Object[])new Object[]{e.getMessage()});
            throw WSS4JUtils.createSoapFault((SoapMessage)message, (SoapVersion)message.getVersion(), (org.apache.wss4j.common.ext.WSSecurityException)new org.apache.wss4j.common.ext.WSSecurityException(WSSecurityException.ErrorCode.FAILED_AUTHENTICATION, "badUsernameToken", new Object[]{e.getMessage()}));
        }
    }

    private void handleX509Token(@Sensitive SoapMessage message, WSHandlerResult handlerResult) throws SoapFault {
        AssertionInfoMap aim;
        Collection ais;
        List signedutResults;
        X509Certificate[] x509Certs = null;
        boolean isAsymmetricBinding = false;
        boolean isEndorsingSupportingTokenBinding = false;
        boolean isSignedEndorsingSupportingTokenBinding = false;
        boolean isEndorsingEncryptedSupportingTokenBinding = false;
        boolean isSignedEndorsingEncryptedSupportingTokenBinding = false;
        List<WSSecurityEngineResult> signedResults = new ArrayList();
        if (handlerResult.getActionResults().containsKey(2)) {
            signedResults = (List)handlerResult.getActionResults().get(2);
        }
        if ((signedutResults = (List)handlerResult.getActionResults().get(64)) != null) {
            signedResults.addAll(signedutResults);
        }
        if ((ais = (Collection)(aim = (AssertionInfoMap)message.get(AssertionInfoMap.class)).get((Object)SP12Constants.ASYMMETRIC_BINDING)) != null && !ais.isEmpty()) {
            isAsymmetricBinding = true;
        }
        if ((ais = (Collection)aim.get((Object)SP12Constants.ENDORSING_SUPPORTING_TOKENS)) != null && !ais.isEmpty()) {
            isEndorsingSupportingTokenBinding = true;
        }
        if ((ais = (Collection)aim.get((Object)SP12Constants.SIGNED_ENDORSING_SUPPORTING_TOKENS)) != null && !ais.isEmpty()) {
            isSignedEndorsingSupportingTokenBinding = true;
        }
        if ((ais = (Collection)aim.get((Object)SP12Constants.ENDORSING_ENCRYPTED_SUPPORTING_TOKENS)) != null && !ais.isEmpty()) {
            isEndorsingEncryptedSupportingTokenBinding = true;
        }
        if ((ais = (Collection)aim.get((Object)SP12Constants.SIGNED_ENDORSING_ENCRYPTED_SUPPORTING_TOKENS)) != null && !ais.isEmpty()) {
            isSignedEndorsingEncryptedSupportingTokenBinding = true;
        }
        if (isAsymmetricBinding) {
            x509Certs = this.getClientX509(message, handlerResult.getResults(), signedResults);
        } else if (isEndorsingSupportingTokenBinding || isSignedEndorsingSupportingTokenBinding || isEndorsingEncryptedSupportingTokenBinding || isSignedEndorsingEncryptedSupportingTokenBinding) {
            x509Certs = this.getEndorsingX509(message, handlerResult.getResults(), signedResults);
        }
        if (x509Certs == null) {
            Tr.error((TraceComponent)tc, (String)"no_caller_exist_err", (Object[])new Object[]{"X509Token", "X509Token"});
            throw WSS4JUtils.createSoapFault((SoapMessage)message, (SoapVersion)message.getVersion(), (org.apache.wss4j.common.ext.WSSecurityException)new org.apache.wss4j.common.ext.WSSecurityException(WSSecurityException.ErrorCode.FAILED_AUTHENTICATION, "invalidCertData", new Object[]{"0"}));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Caller DN: " + x509Certs[0].getSubjectDN().getName()), (Object[])new Object[0]);
        }
        this.bstCertAuthentication(x509Certs, message, message.getVersion());
    }

    private X509Certificate[] getClientX509(@Sensitive SoapMessage message, List<WSSecurityEngineResult> results, List<WSSecurityEngineResult> signedResults) throws SoapFault {
        String issuerInfo = null;
        X509Certificate[] x509Certs = null;
        for (WSSecurityEngineResult signedResult : signedResults) {
            X509Certificate cert = (X509Certificate)signedResult.get((Object)"x509-certificate");
            if (cert == null) continue;
            StringBuffer sb = new StringBuffer(cert.getSerialNumber().toString());
            sb.append(cert.getIssuerDN().getName());
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"issuer sn and dn = ", (Object[])new Object[]{sb.toString()});
            }
            if (issuerInfo == null || sb.toString().equals(issuerInfo)) {
                x509Certs = (X509Certificate[])signedResult.get((Object)"x509-certificates");
                issuerInfo = sb.toString();
                continue;
            }
            if (sb.toString().equals(issuerInfo)) continue;
            Tr.error((TraceComponent)tc, (String)"multiple_asymmetric_token_err", (Object[])new Object[0]);
            throw WSS4JUtils.createSoapFault((SoapMessage)message, (SoapVersion)message.getVersion(), (org.apache.wss4j.common.ext.WSSecurityException)new org.apache.wss4j.common.ext.WSSecurityException(WSSecurityException.ErrorCode.FAILED_AUTHENTICATION, "invalidCertData", new Object[]{"2"}));
        }
        return x509Certs;
    }

    private X509Certificate[] getEndorsingX509(@Sensitive SoapMessage message, List<WSSecurityEngineResult> results, List<WSSecurityEngineResult> signedResults) {
        X509Certificate[] x509Certs = null;
        if (this.isTransportBinding(message)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"looking x509Token which endorse TS", (Object[])new Object[0]);
            }
            WSSecurityEngineResult tsResult = WSSecurityLibertyCallerInterceptor.fetchActionResult(results, 32);
            Element timestamp = null;
            if (tsResult != null) {
                Timestamp ts = (Timestamp)tsResult.get((Object)"timestamp");
                timestamp = ts.getElement();
                x509Certs = this.getEndorsingX509(timestamp, signedResults);
            }
        } else {
            x509Certs = this.getEndorsingX509(signedResults);
        }
        return x509Certs;
    }

    public static WSSecurityEngineResult fetchActionResult(List<WSSecurityEngineResult> resultList, int action) {
        WSSecurityEngineResult returnResult = null;
        for (WSSecurityEngineResult result : resultList) {
            int resultAction = (Integer)result.get((Object)"action");
            if (resultAction != action) continue;
            returnResult = result;
        }
        return returnResult;
    }

    private X509Certificate[] getEndorsingX509(List<WSSecurityEngineResult> signedResults) {
        for (WSSecurityEngineResult signedResult : signedResults) {
            List sl;
            X509Certificate[] x509Cert = (X509Certificate[])signedResult.get((Object)"x509-certificates");
            if (x509Cert == null || (sl = CastUtils.cast((List)((List)signedResult.get((Object)"data-ref-uris")))) == null || sl.size() != 1) continue;
            for (WSDataRef dataRef : sl) {
                QName signedQName = dataRef.getName();
                if (!WSConstants.SIGNATURE.equals(signedQName)) continue;
                return x509Cert;
            }
        }
        return null;
    }

    private X509Certificate[] getEndorsingX509(Element timestamp, List<WSSecurityEngineResult> signedResults) {
        for (WSSecurityEngineResult signedResult : signedResults) {
            List sl;
            X509Certificate[] x509Certs = (X509Certificate[])signedResult.get((Object)"x509-certificates");
            if (x509Certs == null || (sl = CastUtils.cast((List)((List)signedResult.get((Object)"data-ref-uris")))) == null) continue;
            for (WSDataRef dataRef : sl) {
                if (timestamp != dataRef.getProtectedElement()) continue;
                return x509Certs;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void bstCertAuthentication(X509Certificate[] x509Certs, @Sensitive SoapMessage message, SoapVersion version) throws Fault {
        SecurityService securityService = UsernameTokenValidator.getSecurityService();
        if (securityService == null) throw WSS4JUtils.createSoapFault((SoapMessage)message, (SoapVersion)version, (org.apache.wss4j.common.ext.WSSecurityException)new org.apache.wss4j.common.ext.WSSecurityException(WSSecurityException.ErrorCode.FAILED_AUTHENTICATION, "invalidData", new Object[]{"Missing Liberty Security Service"}));
        AuthenticationService authenticationService = securityService.getAuthenticationService();
        try {
            String thisAuthMech = "system.WEB_INBOUND";
            WSAuthenticationData authenticationData = new WSAuthenticationData();
            authenticationData.set("CERTCHAIN", (Object)x509Certs);
            Subject authenticatedSubject = authenticationService.authenticate(thisAuthMech, (AuthenticationData)authenticationData, null);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Authentication successful, authenticated subject = ", (Object[])new Object[]{authenticatedSubject});
                Tr.debug((TraceComponent)tc, (String)"Authentication successful, runAsSubject before = ", (Object[])new Object[]{WSSubject.getRunAsSubject()});
            }
            WSSubject.setRunAsSubject((Subject)authenticatedSubject);
            SubjectManager subjectManager = new SubjectManager();
            subjectManager.setCallerSubject(authenticatedSubject);
            if (!tc.isDebugEnabled()) return;
            Tr.debug((TraceComponent)tc, (String)"Authentication successful, runAsSubject after = ", (Object[])new Object[]{WSSubject.getRunAsSubject()});
            Tr.debug((TraceComponent)tc, (String)"Authentication successful, caller subject = ", (Object[])new Object[]{WSSubject.getCallerSubject()});
            return;
        }
        catch (AuthenticationException thisAuthMech) {
            void e;
            Object[] objectArray = new Object[3];
            objectArray[0] = x509Certs;
            objectArray[1] = "<sensitive org.apache.cxf.binding.soap.SoapMessage>";
            objectArray[2] = version;
            FFDCFilter.processException((Throwable)thisAuthMech, (String)"com.ibm.ws.wssecurity.cxf.interceptor.WSSecurityLibertyCallerInterceptor", (String)"718", (Object)((Object)this), (Object[])objectArray);
            FFDCFilter.processException((Throwable)e, (String)((Object)((Object)this)).getClass().getName(), (String)"bstCertAuthentication", (Object[])new Object[]{x509Certs[0].getSubjectX500Principal().getName()});
            Tr.error((TraceComponent)tc, (String)"error_authenticate", (Object[])new Object[]{e.getMessage()});
            throw WSS4JUtils.createSoapFault((SoapMessage)message, (SoapVersion)version, (org.apache.wss4j.common.ext.WSSecurityException)new org.apache.wss4j.common.ext.WSSecurityException(WSSecurityException.ErrorCode.FAILED_AUTHENTICATION, "invalidData", new Object[]{e.getLocalizedMessage()}));
        }
        catch (Exception e) {
            Object[] objectArray = new Object[3];
            objectArray[0] = x509Certs;
            objectArray[1] = "<sensitive org.apache.cxf.binding.soap.SoapMessage>";
            objectArray[2] = version;
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.wssecurity.cxf.interceptor.WSSecurityLibertyCallerInterceptor", (String)"731", (Object)((Object)this), (Object[])objectArray);
            FFDCFilter.processException((Throwable)e, (String)((Object)((Object)this)).getClass().getName(), (String)"handleMessage", (Object[])new Object[]{x509Certs[0].getSubjectX500Principal().getName()});
            Tr.error((TraceComponent)tc, (String)"error_authenticate", (Object[])new Object[]{e.getMessage()});
            throw WSS4JUtils.createSoapFault((SoapMessage)message, (SoapVersion)version, (org.apache.wss4j.common.ext.WSSecurityException)new org.apache.wss4j.common.ext.WSSecurityException(WSSecurityException.ErrorCode.FAILED_AUTHENTICATION, "invalidData", new Object[]{e.getMessage()}));
        }
    }

    private boolean isTransportBinding(@Sensitive SoapMessage message) {
        AssertionInfoMap aim = (AssertionInfoMap)message.get(AssertionInfoMap.class);
        boolean isTransportBinding = false;
        Collection ais = (Collection)aim.get((Object)SP12Constants.TRANSPORT_BINDING);
        if (ais != null && !ais.isEmpty()) {
            isTransportBinding = true;
        }
        return isTransportBinding;
    }

    private SoapFault createSoapFault(SoapVersion version, org.apache.wss4j.common.ext.WSSecurityException e) {
        SoapFault fault;
        QName faultCode = e.getFaultCode();
        if (version.getVersion() == 1.1 && faultCode != null) {
            fault = new SoapFault(e.getMessage(), (Throwable)e, faultCode);
        } else {
            fault = new SoapFault(e.getMessage(), (Throwable)e, version.getSender());
            if (version.getVersion() != 1.1 && faultCode != null) {
                fault.setSubCode(faultCode);
            }
        }
        return fault;
    }
}

