/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jbatch.utility.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class StringUtils {
    public static boolean isEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    public static String join(Collection<String> strs, String delim) {
        StringBuilder sb = new StringBuilder();
        String d = "";
        for (String str : StringUtils.nullSafeIterable(strs)) {
            sb.append(d).append(str);
            d = delim;
        }
        return sb.toString();
    }

    public static List<String> filterPrefix(Collection<String> strs, String prefix) {
        ArrayList<String> retMe = new ArrayList<String>();
        for (String str : StringUtils.nullSafeIterable(strs)) {
            if (!str.startsWith(prefix)) continue;
            retMe.add(str);
        }
        return retMe;
    }

    public static List<String> trimPrefix(Collection<String> strs, String prefix) {
        ArrayList<String> retMe = new ArrayList<String>();
        for (String str : StringUtils.nullSafeIterable(strs)) {
            retMe.add(StringUtils.trimPrefix(str, prefix));
        }
        return retMe;
    }

    public static String trimPrefix(String str, String prefix) {
        return str.startsWith(prefix) ? str.substring(prefix.length()) : str;
    }

    public static String trimSuffix(String str, String suffix) {
        return str.endsWith(suffix) ? str.substring(0, str.length() - suffix.length()) : str;
    }

    public static <T> Iterable<T> nullSafeIterable(Iterable<T> iterable) {
        return iterable != null ? iterable : Collections.EMPTY_LIST;
    }

    public static <T> Iterable<T> nullSafeIterable(T[] iterable) {
        return iterable != null ? Arrays.asList(iterable) : Collections.EMPTY_LIST;
    }

    public static String dequote(String str) {
        return StringUtils.trimPrefix(StringUtils.trimSuffix(str, "\""), "\"");
    }

    public static List<String> split(String str, String delim) {
        return str == null ? new ArrayList() : Arrays.asList(str.split(delim));
    }

    public static <T> T firstNonNull(T ... vals) {
        for (T val : vals) {
            if (val == null) continue;
            return val;
        }
        return null;
    }
}

