/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.execution.datafetcher;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import graphql.GraphQLContext;
import graphql.execution.DataFetcherResult;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import io.smallrye.graphql.bootstrap.Config;
import io.smallrye.graphql.execution.context.SmallRyeContext;
import io.smallrye.graphql.execution.datafetcher.helper.ArgumentHelper;
import io.smallrye.graphql.execution.datafetcher.helper.BatchLoaderHelper;
import io.smallrye.graphql.execution.datafetcher.helper.FieldHelper;
import io.smallrye.graphql.execution.datafetcher.helper.PartialResultHelper;
import io.smallrye.graphql.execution.datafetcher.helper.ReflectionHelper;
import io.smallrye.graphql.execution.event.EventEmitter;
import io.smallrye.graphql.schema.model.Operation;
import io.smallrye.graphql.transformation.AbstractDataFetcherException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletionException;
import org.dataloader.BatchLoaderWithContext;
import org.eclipse.microprofile.graphql.GraphQLException;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public abstract class AbstractDataFetcher<K, T>
implements DataFetcher<T>,
BatchLoaderWithContext<K, T> {
    protected Operation operation;
    protected FieldHelper fieldHelper;
    protected ReflectionHelper reflectionHelper;
    protected PartialResultHelper partialResultHelper;
    protected ArgumentHelper argumentHelper;
    protected EventEmitter eventEmitter;
    protected BatchLoaderHelper batchLoaderHelper;
    protected List<String> unwrapExceptions = new ArrayList<String>();
    private static final List<String> DEFAULT_EXCEPTION_UNWRAP;
    static final long serialVersionUID = 2935737254492250592L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public AbstractDataFetcher(Operation operation, Config config) {
        this.operation = operation;
        this.eventEmitter = EventEmitter.getInstance(config);
        this.fieldHelper = new FieldHelper(operation);
        this.reflectionHelper = new ReflectionHelper(operation, this.eventEmitter);
        this.argumentHelper = new ArgumentHelper(operation.getArguments());
        this.partialResultHelper = new PartialResultHelper();
        this.batchLoaderHelper = new BatchLoaderHelper();
        if (config != null && config.getUnwrapExceptions().isPresent()) {
            this.unwrapExceptions.addAll((Collection<String>)config.getUnwrapExceptions().get());
        }
        this.unwrapExceptions.addAll(DEFAULT_EXCEPTION_UNWRAP);
    }

    @FFDCIgnore(value={AbstractDataFetcherException.class, GraphQLException.class, IllegalArgumentException.class})
    public T get(DataFetchingEnvironment dfe) throws Exception {
        GraphQLContext graphQLContext = (GraphQLContext)dfe.getContext();
        SmallRyeContext context = ((SmallRyeContext)graphQLContext.get((Object)"context")).withDataFromFetcher(dfe, this.operation);
        graphQLContext.put((Object)"context", (Object)context);
        DataFetcherResult.Builder resultBuilder = DataFetcherResult.newResult().localContext((Object)graphQLContext);
        this.eventEmitter.fireBeforeDataFetch(context);
        try {
            Object[] transformedArguments = this.argumentHelper.getArguments(dfe);
            T t = this.invokeAndTransform(dfe, (DataFetcherResult.Builder<Object>)resultBuilder, transformedArguments);
            return t;
        }
        catch (AbstractDataFetcherException abstractDataFetcherException) {
            abstractDataFetcherException.appendDataFetcherResult((DataFetcherResult.Builder<Object>)resultBuilder, dfe);
            this.eventEmitter.fireOnDataFetchError(dfe.getExecutionId().toString(), abstractDataFetcherException);
        }
        catch (GraphQLException graphQLException) {
            this.partialResultHelper.appendPartialResult((DataFetcherResult.Builder<Object>)resultBuilder, dfe, graphQLException);
            this.eventEmitter.fireOnDataFetchError(dfe.getExecutionId().toString(), graphQLException);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException ex) {
            this.eventEmitter.fireOnDataFetchError(dfe.getExecutionId().toString(), ex);
            throw ex;
        }
        finally {
            this.eventEmitter.fireAfterDataFetch(context);
        }
        return this.invokeFailure((DataFetcherResult.Builder<Object>)resultBuilder);
    }

    protected abstract <T> T invokeAndTransform(DataFetchingEnvironment var1, DataFetcherResult.Builder<Object> var2, Object[] var3) throws AbstractDataFetcherException, Exception;

    protected abstract <T> T invokeFailure(DataFetcherResult.Builder<Object> var1);

    protected Throwable unwrapThrowable(Throwable t) {
        if (this.shouldUnwrapThrowable(t)) {
            t = t.getCause();
            return this.unwrapThrowable(t);
        }
        return t;
    }

    private boolean shouldUnwrapThrowable(Throwable t) {
        return this.unwrapExceptions.contains(t.getClass().getName()) && t.getCause() != null;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.smallrye.graphql.execution.datafetcher.AbstractDataFetcher", AbstractDataFetcher.class, null, null);
        DEFAULT_EXCEPTION_UNWRAP = new ArrayList<String>();
        DEFAULT_EXCEPTION_UNWRAP.add(CompletionException.class.getName());
        DEFAULT_EXCEPTION_UNWRAP.add("jakarta.ejb.EJBException");
        DEFAULT_EXCEPTION_UNWRAP.add("jakarta.ejb.EJBException");
    }
}

