/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.encryption.support;

import jakarta.annotation.Nullable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.xmlsec.EncryptionParameters;
import org.opensaml.xmlsec.encryption.support.DataEncryptionParameters;
import org.opensaml.xmlsec.encryption.support.RSAOAEPParameters;

public class KeyEncryptionParameters
extends DataEncryptionParameters {
    private String recipient;
    private RSAOAEPParameters rsaOAEPParameters;

    public KeyEncryptionParameters() {
        this.setAlgorithm(null);
    }

    public KeyEncryptionParameters(EncryptionParameters params, String recipientId) {
        this();
        Constraint.isNotNull((Object)params, (String)"EncryptionParameters instance was null");
        this.setEncryptionCredential(params.getKeyTransportEncryptionCredential());
        this.setAlgorithm(params.getKeyTransportEncryptionAlgorithm());
        this.setKeyInfoGenerator(params.getKeyTransportKeyInfoGenerator());
        this.setRecipient(recipientId);
        this.setRSAOAEPParameters(params.getRSAOAEPParameters());
    }

    @Nullable
    public String getRecipient() {
        return this.recipient;
    }

    public void setRecipient(@Nullable String newRecipient) {
        this.recipient = newRecipient;
    }

    @Nullable
    public RSAOAEPParameters getRSAOAEPParameters() {
        return this.rsaOAEPParameters;
    }

    public void setRSAOAEPParameters(@Nullable RSAOAEPParameters params) {
        this.rsaOAEPParameters = params;
    }
}

