/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.assertion.impl;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Set;
import org.opensaml.saml.common.assertion.ValidationContext;
import org.opensaml.saml.common.assertion.ValidationResult;
import org.opensaml.saml.saml2.core.Assertion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AssertionValidationSupport {
    private static final Logger LOG = LoggerFactory.getLogger(AssertionValidationSupport.class);

    private AssertionValidationSupport() {
    }

    @Nonnull
    public static ValidationResult checkAddress(@Nonnull ValidationContext context, @Nullable String address, @Nonnull String validAddressesParam, @Nonnull Assertion assertion, @Nonnull String description) {
        Set validAddresses;
        InetAddress[] confirmingAddresses;
        if (address == null) {
            return ValidationResult.VALID;
        }
        LOG.debug("Evaluating {} value of: {}", (Object)description, (Object)address);
        try {
            confirmingAddresses = InetAddress.getAllByName(address);
        }
        catch (UnknownHostException e) {
            LOG.warn("The {} value '{}' in assertion '{}' can not be resolved to a valid set of IP address(s)", new Object[]{description, address, assertion.getID()});
            context.setValidationFailureMessage(String.format("%s '%s' is not resolvable to hostname or IP address", description, address));
            return ValidationResult.INDETERMINATE;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} was resolved to addresses: {}", (Object)description, Arrays.asList(confirmingAddresses));
        }
        try {
            validAddresses = (Set)context.getStaticParameters().get(validAddressesParam);
        }
        catch (ClassCastException e) {
            LOG.warn("The value of the static validation parameter '{}' was not a java.util.Set<InetAddress>", (Object)validAddressesParam);
            context.setValidationFailureMessage(String.format("Unable to determine list of valid values for %s", description));
            return ValidationResult.INDETERMINATE;
        }
        if (validAddresses == null || validAddresses.isEmpty()) {
            LOG.warn("Set of valid addresses was not available from the validation context, unable to evaluate {}", (Object)description);
            context.setValidationFailureMessage(String.format("Unable to determine list of valid values for %s", description));
            return ValidationResult.INDETERMINATE;
        }
        for (InetAddress confirmingAddress : confirmingAddresses) {
            if (!validAddresses.contains(confirmingAddress)) continue;
            LOG.debug("Matched {} '{}' to valid address", (Object)description, (Object)confirmingAddress.getHostAddress());
            return ValidationResult.VALID;
        }
        LOG.debug("Failed to match {} to any supplied valid addresses: {}", (Object)description, (Object)validAddresses);
        context.setValidationFailureMessage(String.format("%s for assertion '%s' did not match any valid addresses", description, assertion.getID()));
        return ValidationResult.INVALID;
    }
}

