/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.ra.inbound.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.ra.SibRaEngineComponent;
import com.ibm.ws.sib.ra.impl.SibRaUtils;
import com.ibm.ws.sib.ra.inbound.SibRaEndpointConfiguration;
import com.ibm.ws.sib.ra.inbound.SibRaEndpointInvoker;
import com.ibm.ws.sib.ra.inbound.impl.SibRaCommonEndpointActivation;
import com.ibm.ws.sib.ra.inbound.impl.SibRaResourceAdapterImpl;
import com.ibm.ws.sib.utils.ras.SibTr;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.endpoint.MessageEndpointFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class SibRaColocatingEndpointActivation
extends SibRaCommonEndpointActivation {
    private static final TraceComponent TRACE = SibRaUtils.getTraceComponent(SibRaColocatingEndpointActivation.class);
    private static final String CLASS_NAME = SibRaColocatingEndpointActivation.class.getName();
    private static final String FFDC_PROBE_1 = "1";

    public SibRaColocatingEndpointActivation(SibRaResourceAdapterImpl resourceAdapter, MessageEndpointFactory messageEndpointFactory, SibRaEndpointConfiguration endpointConfiguration, SibRaEndpointInvoker endpointInvoker) throws ResourceException {
        super(resourceAdapter, messageEndpointFactory, endpointConfiguration, endpointInvoker);
        String methodName = "SibRaColocatingEndpointActivation";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"SibRaColocatingEndpointActivation");
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"SibRaColocatingEndpointActivation");
        }
    }

    @Override
    public boolean onlyConnectToDSH() {
        return false;
    }

    @Override
    JsMessagingEngine[] getMEsToCheck() {
        String methodName = "getMEsToCheck";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"getMEsToCheck");
        }
        JsMessagingEngine[] retVal = SibRaEngineComponent.getMessagingEngines((String)this._endpointConfiguration.getBusName());
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"getMEsToCheck", (Object)retVal);
        }
        return retVal;
    }

    JsMessagingEngine[] removeStoppedMEs(JsMessagingEngine[] MEList) {
        String methodName = "removeStoppedMEs";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"removeStoppedMEs", (Object)MEList);
        }
        JsMessagingEngine[] startedMEs = SibRaEngineComponent.getActiveMessagingEngines((String)this._endpointConfiguration.getBusName());
        List<JsMessagingEngine> runningMEs = Arrays.asList(startedMEs);
        ArrayList<JsMessagingEngine> newList = new ArrayList<JsMessagingEngine>();
        for (int i = 0; i < MEList.length; ++i) {
            JsMessagingEngine nextME = MEList[i];
            if (!runningMEs.contains(nextME)) continue;
            newList.add(nextME);
        }
        JsMessagingEngine[] retVal = new JsMessagingEngine[newList.size()];
        retVal = newList.toArray(retVal);
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"removeStoppedMEs", (Object)retVal);
        }
        return retVal;
    }

    @Override
    public void messagingEngineDestroyed(JsMessagingEngine messagingEngine) {
        JsMessagingEngine[] localMessagingEngines;
        String methodName = "messagingEngineDestroyed";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"messagingEngineDestroyed", (Object)messagingEngine);
        }
        if (0 == (localMessagingEngines = SibRaEngineComponent.getMessagingEngines((String)this._endpointConfiguration.getBusName())).length) {
            SibTr.info((TraceComponent)TRACE, (String)"ME_DESTROYED_CWSIV0779", (Object)new Object[]{messagingEngine.getName(), this._endpointConfiguration.getBusName()});
            try {
                this.clearTimer();
                this.timerLoop();
            }
            catch (ResourceException exception) {
                FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "." + "messagingEngineDestroyed"), (String)FFDC_PROBE_1, (Object)this);
                SibTr.error((TraceComponent)TRACE, (String)"MESSAGING_ENGINE_STOPPING_CWSIV0765", (Object)new Object[]{exception, messagingEngine.getName(), messagingEngine.getBusName()});
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"messagingEngineDestroyed");
        }
    }
}

