/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer;

import java.time.Instant;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import org.eclipse.yasson.internal.model.customization.Customization;
import org.eclipse.yasson.internal.serializer.AbstractDateTimeSerializer;

public class YearMonthTypeSerializer
extends AbstractDateTimeSerializer<YearMonth> {
    private static final DateTimeFormatter DEFAULT_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM").withZone(UTC);

    public YearMonthTypeSerializer(Customization customization) {
        super(customization);
    }

    @Override
    protected Instant toInstant(YearMonth value) {
        return value.atDay(1).atStartOfDay(UTC).toInstant();
    }

    @Override
    protected String formatDefault(YearMonth value, Locale locale) {
        return DEFAULT_FORMAT.withLocale(locale).format(value);
    }
}

