/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.weaver.model;

import java.util.Collections;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.commons.weaver.model.Weavable;
import org.apache.commons.weaver.model.WeavableClass;

public class WeavablePackage
extends Weavable<WeavablePackage, Package> {
    private final ConcurrentNavigableMap<String, WeavableClass<?>> clazzes = new ConcurrentSkipListMap();

    public WeavablePackage(Package target) {
        super(target);
    }

    public synchronized <T> WeavableClass<T> getWeavable(Class<T> cls) {
        String key = cls.getName();
        if (this.clazzes.containsKey(key)) {
            WeavableClass result = (WeavableClass)this.clazzes.get(key);
            return result;
        }
        WeavableClass<T> result = new WeavableClass<T>(cls, this);
        WeavableClass<T> faster = this.clazzes.putIfAbsent(key, result);
        return faster == null ? result : faster;
    }

    public Iterable<WeavableClass<?>> getClasses() {
        return Collections.unmodifiableCollection(this.clazzes.values());
    }

    @Override
    public int compareTo(WeavablePackage arg0) {
        return ((Package)this.getTarget()).getName().compareTo(((Package)arg0.getTarget()).getName());
    }
}

