/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.weaver.model;

import java.lang.reflect.Member;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.weaver.model.NestedWeavable;
import org.apache.commons.weaver.model.WeavableClass;
import org.apache.commons.weaver.model.WeavableParameter;
import org.apache.commons.weaver.utils.Args;

public abstract class WeavableExecutable<SELF extends WeavableExecutable<SELF, TARGET, T, P>, TARGET extends Member, T, P extends WeavableParameter<P, SELF, TARGET, T>>
extends NestedWeavable<SELF, TARGET, WeavableClass<T>, Class<T>> {
    private final List<P> parameters;

    protected WeavableExecutable(TARGET target, WeavableClass<T> parent) {
        super(target, parent);
        ArrayList<P> params = new ArrayList<P>();
        int paramCount = this.getParameterTypes().length;
        for (int i = 0; i < paramCount; ++i) {
            params.add(this.createParameter(i));
        }
        this.parameters = Collections.unmodifiableList(params);
    }

    protected abstract P createParameter(int var1);

    protected abstract Class<?>[] getParameterTypes();

    @Override
    protected int localCompareTo(SELF obj) {
        return Args.compare(this.getParameterTypes(), ((WeavableExecutable)obj).getParameterTypes());
    }

    public P getWeavableParameter(int index) {
        return (P)((WeavableParameter)this.parameters.get(index));
    }

    public Iterable<P> getParameters() {
        return this.parameters;
    }
}

