/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.recovery;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.common.recoveryPropertyManager;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.objectstore.RecoveryStore;
import com.arjuna.ats.arjuna.objectstore.StoreManager;
import com.arjuna.ats.arjuna.recovery.ExpiryScanner;
import com.arjuna.ats.arjuna.state.InputBuffer;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.internal.arjuna.common.UidHelper;
import com.arjuna.ats.internal.arjuna.recovery.TransactionStatusConnector;
import com.arjuna.ats.internal.arjuna.recovery.TransactionStatusManagerItem;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ExpiredTransactionStatusManagerScanner
implements ExpiryScanner {
    private String _itemTypeName;
    private RecoveryStore _recoveryStore;
    private static final int _expiryTime = recoveryPropertyManager.getRecoveryEnvironmentBean().getTransactionStatusManagerExpiryTime() * 60 * 60;
    private static final SimpleDateFormat _timeFormat = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss");

    public ExpiredTransactionStatusManagerScanner() {
        if (tsLogger.logger.isDebugEnabled()) {
            tsLogger.logger.debug((Object)("ExpiredTransactionStatusManagerScanner created, with expiry time of " + Integer.toString(_expiryTime) + "  seconds"));
        }
        this._recoveryStore = StoreManager.getRecoveryStore();
        this._itemTypeName = TransactionStatusManagerItem.typeName();
    }

    public void scan() {
        Date oldestSurviving = new Date(new Date().getTime() - (long)(_expiryTime * 1000));
        if (tsLogger.logger.isDebugEnabled()) {
            tsLogger.logger.debug((Object)("ExpiredTransactionStatusManagerScanner - scanning to remove items from before " + _timeFormat.format(oldestSurviving)));
        }
        try {
            InputObjectState uids = new InputObjectState();
            if (this._recoveryStore.allObjUids(this._itemTypeName, uids)) {
                Uid theUid = null;
                boolean endOfUids = false;
                while (!endOfUids) {
                    theUid = UidHelper.unpackFrom((InputBuffer)uids);
                    if (theUid.equals(Uid.nullUid())) {
                        endOfUids = true;
                        continue;
                    }
                    Uid newUid = new Uid(theUid);
                    TransactionStatusManagerItem tsmItem = TransactionStatusManagerItem.recreate((Uid)newUid);
                    if (tsmItem == null) continue;
                    Date timeOfDeath = tsmItem.getDeadTime();
                    if (timeOfDeath != null && timeOfDeath.before(oldestSurviving)) {
                        tsLogger.logger.debugf("Removing old transaction status manager item %s", (Object)newUid);
                        this._recoveryStore.remove_committed(newUid, this._itemTypeName);
                        continue;
                    }
                    Uid currentUid = newUid;
                    String process_id = currentUid.getHexPid();
                    TransactionStatusConnector tsc = new TransactionStatusConnector(process_id, currentUid);
                    tsc.test(tsmItem);
                    if (!tsc.isDead()) continue;
                    tsLogger.logger.debugf("Removing old transaction status manager item %s", (Object)newUid);
                    tsc.delete();
                    tsc = null;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean toBeUsed() {
        return _expiryTime != 0;
    }

    static {
        if (tsLogger.logger.isDebugEnabled()) {
            tsLogger.logger.debug((Object)("Expiry scan interval set to  " + Integer.toString(_expiryTime) + "  seconds"));
        }
    }
}

